@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.StateMachineEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsDataKeyReusePeriodSeconds Maximum duration for which Step Functions will reuse data keys. When the period expires, Step Functions will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply when `type` is `AWS_OWNED_KEY`.
 * @property kmsKeyId The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
 * @property type The encryption option specified for the state machine. Valid values: `AWS_OWNED_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
 */
public data class StateMachineEncryptionConfigurationArgs(
    public val kmsDataKeyReusePeriodSeconds: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.StateMachineEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.StateMachineEncryptionConfigurationArgs =
        com.pulumi.aws.sfn.inputs.StateMachineEncryptionConfigurationArgs.builder()
            .kmsDataKeyReusePeriodSeconds(kmsDataKeyReusePeriodSeconds?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StateMachineEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class StateMachineEncryptionConfigurationArgsBuilder internal constructor() {
    private var kmsDataKeyReusePeriodSeconds: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Maximum duration for which Step Functions will reuse data keys. When the period expires, Step Functions will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply when `type` is `AWS_OWNED_KEY`.
     */
    @JvmName("xatatbedmoxnhmfi")
    public suspend fun kmsDataKeyReusePeriodSeconds(`value`: Output<Int>) {
        this.kmsDataKeyReusePeriodSeconds = value
    }

    /**
     * @param value The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
     */
    @JvmName("xmydmmhqrsfyuiwo")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The encryption option specified for the state machine. Valid values: `AWS_OWNED_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
     */
    @JvmName("xgjlbhthgopthchj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Maximum duration for which Step Functions will reuse data keys. When the period expires, Step Functions will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply when `type` is `AWS_OWNED_KEY`.
     */
    @JvmName("msokxmjoninosmwm")
    public suspend fun kmsDataKeyReusePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsDataKeyReusePeriodSeconds = mapped
    }

    /**
     * @param value The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
     */
    @JvmName("cjkynytltoocdyrj")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The encryption option specified for the state machine. Valid values: `AWS_OWNED_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
     */
    @JvmName("miufkennkgvmciwk")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): StateMachineEncryptionConfigurationArgs =
        StateMachineEncryptionConfigurationArgs(
            kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds,
            kmsKeyId = kmsKeyId,
            type = type,
        )
}
