@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.StateMachineLoggingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property includeExecutionData Determines whether execution data is included in your log. When set to `false`, data is excluded.
 * @property level Defines which category of execution history events are logged. Valid values: `ALL`, `ERROR`, `FATAL`, `OFF`
 * @property logDestination Amazon Resource Name (ARN) of a CloudWatch log group. Make sure the State Machine has the correct IAM policies for logging. The ARN must end with `:*`
 */
public data class StateMachineLoggingConfigurationArgs(
    public val includeExecutionData: Output<Boolean>? = null,
    public val level: Output<String>? = null,
    public val logDestination: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.StateMachineLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.StateMachineLoggingConfigurationArgs =
        com.pulumi.aws.sfn.inputs.StateMachineLoggingConfigurationArgs.builder()
            .includeExecutionData(includeExecutionData?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .logDestination(logDestination?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StateMachineLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class StateMachineLoggingConfigurationArgsBuilder internal constructor() {
    private var includeExecutionData: Output<Boolean>? = null

    private var level: Output<String>? = null

    private var logDestination: Output<String>? = null

    /**
     * @param value Determines whether execution data is included in your log. When set to `false`, data is excluded.
     */
    @JvmName("fekdrhgrlmyfxtfd")
    public suspend fun includeExecutionData(`value`: Output<Boolean>) {
        this.includeExecutionData = value
    }

    /**
     * @param value Defines which category of execution history events are logged. Valid values: `ALL`, `ERROR`, `FATAL`, `OFF`
     */
    @JvmName("qjitdpstskmbqcjp")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of a CloudWatch log group. Make sure the State Machine has the correct IAM policies for logging. The ARN must end with `:*`
     */
    @JvmName("iewmvovtxqmwqlxm")
    public suspend fun logDestination(`value`: Output<String>) {
        this.logDestination = value
    }

    /**
     * @param value Determines whether execution data is included in your log. When set to `false`, data is excluded.
     */
    @JvmName("yuaygdcoiibphlhp")
    public suspend fun includeExecutionData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeExecutionData = mapped
    }

    /**
     * @param value Defines which category of execution history events are logged. Valid values: `ALL`, `ERROR`, `FATAL`, `OFF`
     */
    @JvmName("nponvsqllbtstagv")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of a CloudWatch log group. Make sure the State Machine has the correct IAM policies for logging. The ARN must end with `:*`
     */
    @JvmName("msyymhtrfscnjrnp")
    public suspend fun logDestination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    internal fun build(): StateMachineLoggingConfigurationArgs = StateMachineLoggingConfigurationArgs(
        includeExecutionData = includeExecutionData,
        level = level,
        logDestination = logDestination,
    )
}
