@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getStateMachineVersions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property statemachineArn
 * @property statemachineVersions ARN List identifying the statemachine versions.
 */
public data class GetStateMachineVersionsResult(
    public val id: String,
    public val statemachineArn: String,
    public val statemachineVersions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.GetStateMachineVersionsResult): GetStateMachineVersionsResult = GetStateMachineVersionsResult(
            id = javaType.id(),
            statemachineArn = javaType.statemachineArn(),
            statemachineVersions = javaType.statemachineVersions().map({ args0 -> args0 }),
        )
    }
}
