@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsDataKeyReusePeriodSeconds Maximum duration for which Step Functions will reuse data keys. When the period expires, Step Functions will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply when `type` is `AWS_OWNED_KEY`.
 * @property kmsKeyId The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
 * @property type The encryption option specified for the state machine. Valid values: `AWS_OWNED_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
 */
public data class StateMachineEncryptionConfiguration(
    public val kmsDataKeyReusePeriodSeconds: Int? = null,
    public val kmsKeyId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.StateMachineEncryptionConfiguration): StateMachineEncryptionConfiguration = StateMachineEncryptionConfiguration(
            kmsDataKeyReusePeriodSeconds = javaType.kmsDataKeyReusePeriodSeconds().map({ args0 ->
                args0
            }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
