@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property includeExecutionData Determines whether execution data is included in your log. When set to `false`, data is excluded.
 * @property level Defines which category of execution history events are logged. Valid values: `ALL`, `ERROR`, `FATAL`, `OFF`
 * @property logDestination Amazon Resource Name (ARN) of a CloudWatch log group. Make sure the State Machine has the correct IAM policies for logging. The ARN must end with `:*`
 */
public data class StateMachineLoggingConfiguration(
    public val includeExecutionData: Boolean? = null,
    public val level: String? = null,
    public val logDestination: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sfn.outputs.StateMachineLoggingConfiguration): StateMachineLoggingConfiguration = StateMachineLoggingConfiguration(
            includeExecutionData = javaType.includeExecutionData().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            logDestination = javaType.logDestination().map({ args0 -> args0 }).orElse(null),
        )
    }
}
