@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.ApplicationLayerAutomaticResponseArgs.builder
import com.pulumi.aws.shield.kotlin.inputs.ApplicationLayerAutomaticResponseTimeoutsArgs
import com.pulumi.aws.shield.kotlin.inputs.ApplicationLayerAutomaticResponseTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Shield Application Layer Automatic Response for automatic DDoS mitigation.
 * ## Example Usage
 * @property action One of `COUNT` or `BLOCK`
 * @property resourceArn ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
 * @property timeouts
 */
public data class ApplicationLayerAutomaticResponseArgs(
    public val action: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
    public val timeouts: Output<ApplicationLayerAutomaticResponseTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.ApplicationLayerAutomaticResponseArgs> {
    override fun toJava(): com.pulumi.aws.shield.ApplicationLayerAutomaticResponseArgs =
        com.pulumi.aws.shield.ApplicationLayerAutomaticResponseArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationLayerAutomaticResponseArgs].
 */
@PulumiTagMarker
public class ApplicationLayerAutomaticResponseArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var resourceArn: Output<String>? = null

    private var timeouts: Output<ApplicationLayerAutomaticResponseTimeoutsArgs>? = null

    /**
     * @param value One of `COUNT` or `BLOCK`
     */
    @JvmName("kuulpjooncxyfocy")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
     */
    @JvmName("ndlnewfgdqecdctr")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value
     */
    @JvmName("mugxmbtvovldypmo")
    public suspend fun timeouts(`value`: Output<ApplicationLayerAutomaticResponseTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value One of `COUNT` or `BLOCK`
     */
    @JvmName("qdeqltxafnffaxit")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
     */
    @JvmName("xkixctkukreeuwps")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("nsngimymxjfkurms")
    public suspend fun timeouts(`value`: ApplicationLayerAutomaticResponseTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fyrqfeastvfruosd")
    public suspend fun timeouts(argument: suspend ApplicationLayerAutomaticResponseTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationLayerAutomaticResponseTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ApplicationLayerAutomaticResponseArgs =
        ApplicationLayerAutomaticResponseArgs(
            action = action,
            resourceArn = resourceArn,
            timeouts = timeouts,
        )
}
