@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs.builder
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessLogBucketAssociationTimeoutsArgs
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessLogBucketAssociationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Shield DRT Access Log Bucket Association.
 * Up to 10 log buckets can be associated for DRT Access sharing with the Shield Response Team (SRT).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.shield.DrtAccessRoleArnAssociation("test", {roleArn: `arn:aws:iam:${current.name}:${currentAwsCallerIdentity.accountId}:${shieldDrtAccessRoleName}`});
 * const testDrtAccessLogBucketAssociation = new aws.shield.DrtAccessLogBucketAssociation("test", {
 *     logBucket: shieldDrtAccessLogBucket,
 *     roleArnAssociationId: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.shield.DrtAccessRoleArnAssociation("test", role_arn=f"arn:aws:iam:{current['name']}:{current_aws_caller_identity['accountId']}:{shield_drt_access_role_name}")
 * test_drt_access_log_bucket_association = aws.shield.DrtAccessLogBucketAssociation("test",
 *     log_bucket=shield_drt_access_log_bucket,
 *     role_arn_association_id=test.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Shield.DrtAccessRoleArnAssociation("test", new()
 *     {
 *         RoleArn = $"arn:aws:iam:{current.Name}:{currentAwsCallerIdentity.AccountId}:{shieldDrtAccessRoleName}",
 *     });
 *     var testDrtAccessLogBucketAssociation = new Aws.Shield.DrtAccessLogBucketAssociation("test", new()
 *     {
 *         LogBucket = shieldDrtAccessLogBucket,
 *         RoleArnAssociationId = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := shield.NewDrtAccessRoleArnAssociation(ctx, "test", &shield.DrtAccessRoleArnAssociationArgs{
 * 			RoleArn: pulumi.Sprintf("arn:aws:iam:%v:%v:%v", current.Name, currentAwsCallerIdentity.AccountId, shieldDrtAccessRoleName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = shield.NewDrtAccessLogBucketAssociation(ctx, "test", &shield.DrtAccessLogBucketAssociationArgs{
 * 			LogBucket:            pulumi.Any(shieldDrtAccessLogBucket),
 * 			RoleArnAssociationId: test.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import com.pulumi.aws.shield.DrtAccessLogBucketAssociation;
 * import com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new DrtAccessRoleArnAssociation("test", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(String.format("arn:aws:iam:%s:%s:%s", current.name(),currentAwsCallerIdentity.accountId(),shieldDrtAccessRoleName))
 *             .build());
 *         var testDrtAccessLogBucketAssociation = new DrtAccessLogBucketAssociation("testDrtAccessLogBucketAssociation", DrtAccessLogBucketAssociationArgs.builder()
 *             .logBucket(shieldDrtAccessLogBucket)
 *             .roleArnAssociationId(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:shield:DrtAccessRoleArnAssociation
 *     properties:
 *       roleArn: arn:aws:iam:${current.name}:${currentAwsCallerIdentity.accountId}:${shieldDrtAccessRoleName}
 *   testDrtAccessLogBucketAssociation:
 *     type: aws:shield:DrtAccessLogBucketAssociation
 *     name: test
 *     properties:
 *       logBucket: ${shieldDrtAccessLogBucket}
 *       roleArnAssociationId: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Shield DRT access log bucket associations using the `log_bucket`. For example:
 * ```sh
 * $ pulumi import aws:shield/drtAccessLogBucketAssociation:DrtAccessLogBucketAssociation example example-bucket
 * ```
 * @property logBucket The Amazon S3 bucket that contains the logs that you want to share.
 * @property roleArnAssociationId The ID of the Role Arn association used for allowing Shield DRT Access.
 * @property timeouts
 */
public data class DrtAccessLogBucketAssociationArgs(
    public val logBucket: Output<String>? = null,
    public val roleArnAssociationId: Output<String>? = null,
    public val timeouts: Output<DrtAccessLogBucketAssociationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs> {
    override fun toJava(): com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs =
        com.pulumi.aws.shield.DrtAccessLogBucketAssociationArgs.builder()
            .logBucket(logBucket?.applyValue({ args0 -> args0 }))
            .roleArnAssociationId(roleArnAssociationId?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DrtAccessLogBucketAssociationArgs].
 */
@PulumiTagMarker
public class DrtAccessLogBucketAssociationArgsBuilder internal constructor() {
    private var logBucket: Output<String>? = null

    private var roleArnAssociationId: Output<String>? = null

    private var timeouts: Output<DrtAccessLogBucketAssociationTimeoutsArgs>? = null

    /**
     * @param value The Amazon S3 bucket that contains the logs that you want to share.
     */
    @JvmName("kglsxnmjqtfxwqwj")
    public suspend fun logBucket(`value`: Output<String>) {
        this.logBucket = value
    }

    /**
     * @param value The ID of the Role Arn association used for allowing Shield DRT Access.
     */
    @JvmName("pervevcvjkpehhho")
    public suspend fun roleArnAssociationId(`value`: Output<String>) {
        this.roleArnAssociationId = value
    }

    /**
     * @param value
     */
    @JvmName("ramnaysgqrkugwxt")
    public suspend fun timeouts(`value`: Output<DrtAccessLogBucketAssociationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon S3 bucket that contains the logs that you want to share.
     */
    @JvmName("mljvrasmffvjpjqb")
    public suspend fun logBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBucket = mapped
    }

    /**
     * @param value The ID of the Role Arn association used for allowing Shield DRT Access.
     */
    @JvmName("nfwnjvvenkmbhstv")
    public suspend fun roleArnAssociationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArnAssociationId = mapped
    }

    /**
     * @param value
     */
    @JvmName("hfeyakwrjhppnadn")
    public suspend fun timeouts(`value`: DrtAccessLogBucketAssociationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("onwdypvvqatsheun")
    public suspend fun timeouts(argument: suspend DrtAccessLogBucketAssociationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DrtAccessLogBucketAssociationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DrtAccessLogBucketAssociationArgs = DrtAccessLogBucketAssociationArgs(
        logBucket = logBucket,
        roleArnAssociationId = roleArnAssociationId,
        timeouts = timeouts,
    )
}
