@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.kotlin.outputs.DrtAccessRoleArnAssociationTimeouts
import com.pulumi.aws.shield.kotlin.outputs.DrtAccessRoleArnAssociationTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DrtAccessRoleArnAssociation].
 */
@PulumiTagMarker
public class DrtAccessRoleArnAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DrtAccessRoleArnAssociationArgs = DrtAccessRoleArnAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DrtAccessRoleArnAssociationArgsBuilder.() -> Unit) {
        val builder = DrtAccessRoleArnAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DrtAccessRoleArnAssociation {
        val builtJavaResource =
            com.pulumi.aws.shield.DrtAccessRoleArnAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DrtAccessRoleArnAssociation(builtJavaResource)
    }
}

/**
 * Authorizes the Shield Response Team (SRT) using the specified role, to access your AWS account to assist with DDoS attack mitigation during potential attacks.
 * For more information see [Configure AWS SRT Support](https://docs.aws.amazon.com/waf/latest/developerguide/authorize-srt.html)
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.iam.Role("test", {
 *     name: awsShieldDrtAccessRoleArn,
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "",
 *             Effect: "Allow",
 *             Principal: {
 *                 Service: "drt.shield.amazonaws.com",
 *             },
 *             Action: "sts:AssumeRole",
 *         }],
 *     }),
 * });
 * const testRolePolicyAttachment = new aws.iam.RolePolicyAttachment("test", {
 *     role: test.name,
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy",
 * });
 * const testDrtAccessRoleArnAssociation = new aws.shield.DrtAccessRoleArnAssociation("test", {roleArn: test.arn});
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.iam.Role("test",
 *     name=aws_shield_drt_access_role_arn,
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "Service": "drt.shield.amazonaws.com",
 *             },
 *             "Action": "sts:AssumeRole",
 *         }],
 *     }))
 * test_role_policy_attachment = aws.iam.RolePolicyAttachment("test",
 *     role=test.name,
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 * test_drt_access_role_arn_association = aws.shield.DrtAccessRoleArnAssociation("test", role_arn=test.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Iam.Role("test", new()
 *     {
 *         Name = awsShieldDrtAccessRoleArn,
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "drt.shield.amazonaws.com",
 *                     },
 *                     ["Action"] = "sts:AssumeRole",
 *                 },
 *             },
 *         }),
 *     });
 *     var testRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("test", new()
 *     {
 *         Role = test.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy",
 *     });
 *     var testDrtAccessRoleArnAssociation = new Aws.Shield.DrtAccessRoleArnAssociation("test", new()
 *     {
 *         RoleArn = test.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "drt.shield.amazonaws.com",
 * 					},
 * 					"Action": "sts:AssumeRole",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		test, err := iam.NewRole(ctx, "test", &iam.RoleArgs{
 * 			Name:             pulumi.Any(awsShieldDrtAccessRoleArn),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "test", &iam.RolePolicyAttachmentArgs{
 * 			Role:      test.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = shield.NewDrtAccessRoleArnAssociation(ctx, "test", &shield.DrtAccessRoleArnAssociationArgs{
 * 			RoleArn: test.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Role("test", RoleArgs.builder()
 *             .name(awsShieldDrtAccessRoleArn)
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "drt.shield.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var testRolePolicyAttachment = new RolePolicyAttachment("testRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(test.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 *             .build());
 *         var testDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation("testDrtAccessRoleArnAssociation", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(test.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:iam:Role
 *     properties:
 *       name: ${awsShieldDrtAccessRoleArn}
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid:
 *               Effect: Allow
 *               Principal:
 *                 Service: drt.shield.amazonaws.com
 *               Action: sts:AssumeRole
 *   testRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: test
 *     properties:
 *       role: ${test.name}
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy
 *   testDrtAccessRoleArnAssociation:
 *     type: aws:shield:DrtAccessRoleArnAssociation
 *     name: test
 *     properties:
 *       roleArn: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Shield DRT access role ARN association using the AWS account ID. For example:
 * ```sh
 * $ pulumi import aws:shield/drtAccessRoleArnAssociation:DrtAccessRoleArnAssociation example 123456789012
 * ```
 */
public class DrtAccessRoleArnAssociation internal constructor(
    override val javaResource: com.pulumi.aws.shield.DrtAccessRoleArnAssociation,
) : KotlinCustomResource(javaResource, DrtAccessRoleArnAssociationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    public val timeouts: Output<DrtAccessRoleArnAssociationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DrtAccessRoleArnAssociationMapper : ResourceMapper<DrtAccessRoleArnAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.DrtAccessRoleArnAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DrtAccessRoleArnAssociation =
        DrtAccessRoleArnAssociation(javaResource as com.pulumi.aws.shield.DrtAccessRoleArnAssociation)
}

/**
 * @see [DrtAccessRoleArnAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DrtAccessRoleArnAssociation].
 */
public suspend fun drtAccessRoleArnAssociation(
    name: String,
    block: suspend DrtAccessRoleArnAssociationResourceBuilder.() -> Unit,
): DrtAccessRoleArnAssociation {
    val builder = DrtAccessRoleArnAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DrtAccessRoleArnAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun drtAccessRoleArnAssociation(name: String): DrtAccessRoleArnAssociation {
    val builder = DrtAccessRoleArnAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
