@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs.builder
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessRoleArnAssociationTimeoutsArgs
import com.pulumi.aws.shield.kotlin.inputs.DrtAccessRoleArnAssociationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Authorizes the Shield Response Team (SRT) using the specified role, to access your AWS account to assist with DDoS attack mitigation during potential attacks.
 * For more information see [Configure AWS SRT Support](https://docs.aws.amazon.com/waf/latest/developerguide/authorize-srt.html)
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.iam.Role("test", {
 *     name: awsShieldDrtAccessRoleArn,
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "",
 *             Effect: "Allow",
 *             Principal: {
 *                 Service: "drt.shield.amazonaws.com",
 *             },
 *             Action: "sts:AssumeRole",
 *         }],
 *     }),
 * });
 * const testRolePolicyAttachment = new aws.iam.RolePolicyAttachment("test", {
 *     role: test.name,
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy",
 * });
 * const testDrtAccessRoleArnAssociation = new aws.shield.DrtAccessRoleArnAssociation("test", {roleArn: test.arn});
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.iam.Role("test",
 *     name=aws_shield_drt_access_role_arn,
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "Service": "drt.shield.amazonaws.com",
 *             },
 *             "Action": "sts:AssumeRole",
 *         }],
 *     }))
 * test_role_policy_attachment = aws.iam.RolePolicyAttachment("test",
 *     role=test.name,
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 * test_drt_access_role_arn_association = aws.shield.DrtAccessRoleArnAssociation("test", role_arn=test.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Iam.Role("test", new()
 *     {
 *         Name = awsShieldDrtAccessRoleArn,
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "drt.shield.amazonaws.com",
 *                     },
 *                     ["Action"] = "sts:AssumeRole",
 *                 },
 *             },
 *         }),
 *     });
 *     var testRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("test", new()
 *     {
 *         Role = test.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy",
 *     });
 *     var testDrtAccessRoleArnAssociation = new Aws.Shield.DrtAccessRoleArnAssociation("test", new()
 *     {
 *         RoleArn = test.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "drt.shield.amazonaws.com",
 * 					},
 * 					"Action": "sts:AssumeRole",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		test, err := iam.NewRole(ctx, "test", &iam.RoleArgs{
 * 			Name:             pulumi.Any(awsShieldDrtAccessRoleArn),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "test", &iam.RolePolicyAttachmentArgs{
 * 			Role:      test.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = shield.NewDrtAccessRoleArnAssociation(ctx, "test", &shield.DrtAccessRoleArnAssociationArgs{
 * 			RoleArn: test.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Role("test", RoleArgs.builder()
 *             .name(awsShieldDrtAccessRoleArn)
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "drt.shield.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var testRolePolicyAttachment = new RolePolicyAttachment("testRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(test.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 *             .build());
 *         var testDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation("testDrtAccessRoleArnAssociation", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(test.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:iam:Role
 *     properties:
 *       name: ${awsShieldDrtAccessRoleArn}
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid:
 *               Effect: Allow
 *               Principal:
 *                 Service: drt.shield.amazonaws.com
 *               Action: sts:AssumeRole
 *   testRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: test
 *     properties:
 *       role: ${test.name}
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy
 *   testDrtAccessRoleArnAssociation:
 *     type: aws:shield:DrtAccessRoleArnAssociation
 *     name: test
 *     properties:
 *       roleArn: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Shield DRT access role ARN association using the AWS account ID. For example:
 * ```sh
 * $ pulumi import aws:shield/drtAccessRoleArnAssociation:DrtAccessRoleArnAssociation example 123456789012
 * ```
 * @property roleArn The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
 * @property timeouts
 */
public data class DrtAccessRoleArnAssociationArgs(
    public val roleArn: Output<String>? = null,
    public val timeouts: Output<DrtAccessRoleArnAssociationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs> {
    override fun toJava(): com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs =
        com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs.builder()
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DrtAccessRoleArnAssociationArgs].
 */
@PulumiTagMarker
public class DrtAccessRoleArnAssociationArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var timeouts: Output<DrtAccessRoleArnAssociationTimeoutsArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     */
    @JvmName("goeyuuttekvujiku")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value
     */
    @JvmName("aopwkhytrrawnvbf")
    public suspend fun timeouts(`value`: Output<DrtAccessRoleArnAssociationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role the SRT will use to access your AWS account. Prior to making the AssociateDRTRole request, you must attach the `AWSShieldDRTAccessPolicy` managed policy to this role.
     */
    @JvmName("fpbaundtvondtmvr")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("sjcjynqteufnuwkk")
    public suspend fun timeouts(`value`: DrtAccessRoleArnAssociationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dergmfgpeehdtnll")
    public suspend fun timeouts(argument: suspend DrtAccessRoleArnAssociationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DrtAccessRoleArnAssociationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DrtAccessRoleArnAssociationArgs = DrtAccessRoleArnAssociationArgs(
        roleArn = roleArn,
        timeouts = timeouts,
    )
}
