@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.ProactiveEngagementArgs.builder
import com.pulumi.aws.shield.kotlin.inputs.ProactiveEngagementEmergencyContactArgs
import com.pulumi.aws.shield.kotlin.inputs.ProactiveEngagementEmergencyContactArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing a AWS Shield Proactive Engagement.
 * Proactive engagement authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.Role("example", {
 *     name: awsShieldDrtAccessRoleArn,
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "",
 *             Effect: "Allow",
 *             Principal: {
 *                 Service: "drt.shield.amazonaws.com",
 *             },
 *             Action: "sts:AssumeRole",
 *         }],
 *     }),
 * });
 * const exampleRolePolicyAttachment = new aws.iam.RolePolicyAttachment("example", {
 *     role: example.name,
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy",
 * });
 * const exampleDrtAccessRoleArnAssociation = new aws.shield.DrtAccessRoleArnAssociation("example", {roleArn: example.arn});
 * const test = new aws.shield.ProtectionGroup("test", {
 *     protectionGroupId: "example",
 *     aggregation: "MAX",
 *     pattern: "ALL",
 * });
 * const testProactiveEngagement = new aws.shield.ProactiveEngagement("test", {
 *     enabled: true,
 *     emergencyContacts: [
 *         {
 *             contactNotes: "Notes",
 *             emailAddress: "test@company.com",
 *             phoneNumber: "+12358132134",
 *         },
 *         {
 *             contactNotes: "Notes 2",
 *             emailAddress: "test2@company.com",
 *             phoneNumber: "+12358132134",
 *         },
 *     ],
 * }, {
 *     dependsOn: [testAwsShieldDrtAccessRoleArnAssociation],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.iam.Role("example",
 *     name=aws_shield_drt_access_role_arn,
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "Service": "drt.shield.amazonaws.com",
 *             },
 *             "Action": "sts:AssumeRole",
 *         }],
 *     }))
 * example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
 *     role=example.name,
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 * example_drt_access_role_arn_association = aws.shield.DrtAccessRoleArnAssociation("example", role_arn=example.arn)
 * test = aws.shield.ProtectionGroup("test",
 *     protection_group_id="example",
 *     aggregation="MAX",
 *     pattern="ALL")
 * test_proactive_engagement = aws.shield.ProactiveEngagement("test",
 *     enabled=True,
 *     emergency_contacts=[
 *         {
 *             "contact_notes": "Notes",
 *             "email_address": "test@company.com",
 *             "phone_number": "+12358132134",
 *         },
 *         {
 *             "contact_notes": "Notes 2",
 *             "email_address": "test2@company.com",
 *             "phone_number": "+12358132134",
 *         },
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[test_aws_shield_drt_access_role_arn_association]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = awsShieldDrtAccessRoleArn,
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "drt.shield.amazonaws.com",
 *                     },
 *                     ["Action"] = "sts:AssumeRole",
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         Role = example.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy",
 *     });
 *     var exampleDrtAccessRoleArnAssociation = new Aws.Shield.DrtAccessRoleArnAssociation("example", new()
 *     {
 *         RoleArn = example.Arn,
 *     });
 *     var test = new Aws.Shield.ProtectionGroup("test", new()
 *     {
 *         ProtectionGroupId = "example",
 *         Aggregation = "MAX",
 *         Pattern = "ALL",
 *     });
 *     var testProactiveEngagement = new Aws.Shield.ProactiveEngagement("test", new()
 *     {
 *         Enabled = true,
 *         EmergencyContacts = new[]
 *         {
 *             new Aws.Shield.Inputs.ProactiveEngagementEmergencyContactArgs
 *             {
 *                 ContactNotes = "Notes",
 *                 EmailAddress = "test@company.com",
 *                 PhoneNumber = "+12358132134",
 *             },
 *             new Aws.Shield.Inputs.ProactiveEngagementEmergencyContactArgs
 *             {
 *                 ContactNotes = "Notes 2",
 *                 EmailAddress = "test2@company.com",
 *                 PhoneNumber = "+12358132134",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             testAwsShieldDrtAccessRoleArnAssociation,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "drt.shield.amazonaws.com",
 * 					},
 * 					"Action": "sts:AssumeRole",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.Any(awsShieldDrtAccessRoleArn),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			Role:      example.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = shield.NewDrtAccessRoleArnAssociation(ctx, "example", &shield.DrtAccessRoleArnAssociationArgs{
 * 			RoleArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = shield.NewProtectionGroup(ctx, "test", &shield.ProtectionGroupArgs{
 * 			ProtectionGroupId: pulumi.String("example"),
 * 			Aggregation:       pulumi.String("MAX"),
 * 			Pattern:           pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = shield.NewProactiveEngagement(ctx, "test", &shield.ProactiveEngagementArgs{
 * 			Enabled: pulumi.Bool(true),
 * 			EmergencyContacts: shield.ProactiveEngagementEmergencyContactArray{
 * 				&shield.ProactiveEngagementEmergencyContactArgs{
 * 					ContactNotes: pulumi.String("Notes"),
 * 					EmailAddress: pulumi.String("test@company.com"),
 * 					PhoneNumber:  pulumi.String("+12358132134"),
 * 				},
 * 				&shield.ProactiveEngagementEmergencyContactArgs{
 * 					ContactNotes: pulumi.String("Notes 2"),
 * 					EmailAddress: pulumi.String("test2@company.com"),
 * 					PhoneNumber:  pulumi.String("+12358132134"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			testAwsShieldDrtAccessRoleArnAssociation,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociation;
 * import com.pulumi.aws.shield.DrtAccessRoleArnAssociationArgs;
 * import com.pulumi.aws.shield.ProtectionGroup;
 * import com.pulumi.aws.shield.ProtectionGroupArgs;
 * import com.pulumi.aws.shield.ProactiveEngagement;
 * import com.pulumi.aws.shield.ProactiveEngagementArgs;
 * import com.pulumi.aws.shield.inputs.ProactiveEngagementEmergencyContactArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .name(awsShieldDrtAccessRoleArn)
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "drt.shield.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(example.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy")
 *             .build());
 *         var exampleDrtAccessRoleArnAssociation = new DrtAccessRoleArnAssociation("exampleDrtAccessRoleArnAssociation", DrtAccessRoleArnAssociationArgs.builder()
 *             .roleArn(example.arn())
 *             .build());
 *         var test = new ProtectionGroup("test", ProtectionGroupArgs.builder()
 *             .protectionGroupId("example")
 *             .aggregation("MAX")
 *             .pattern("ALL")
 *             .build());
 *         var testProactiveEngagement = new ProactiveEngagement("testProactiveEngagement", ProactiveEngagementArgs.builder()
 *             .enabled(true)
 *             .emergencyContacts(
 *                 ProactiveEngagementEmergencyContactArgs.builder()
 *                     .contactNotes("Notes")
 *                     .emailAddress("test@company.com")
 *                     .phoneNumber("+12358132134")
 *                     .build(),
 *                 ProactiveEngagementEmergencyContactArgs.builder()
 *                     .contactNotes("Notes 2")
 *                     .emailAddress("test2@company.com")
 *                     .phoneNumber("+12358132134")
 *                     .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testAwsShieldDrtAccessRoleArnAssociation)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: ${awsShieldDrtAccessRoleArn}
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid:
 *               Effect: Allow
 *               Principal:
 *                 Service: drt.shield.amazonaws.com
 *               Action: sts:AssumeRole
 *   exampleRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: example
 *     properties:
 *       role: ${example.name}
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy
 *   exampleDrtAccessRoleArnAssociation:
 *     type: aws:shield:DrtAccessRoleArnAssociation
 *     name: example
 *     properties:
 *       roleArn: ${example.arn}
 *   test:
 *     type: aws:shield:ProtectionGroup
 *     properties:
 *       protectionGroupId: example
 *       aggregation: MAX
 *       pattern: ALL
 *   testProactiveEngagement:
 *     type: aws:shield:ProactiveEngagement
 *     name: test
 *     properties:
 *       enabled: true
 *       emergencyContacts:
 *         - contactNotes: Notes
 *           emailAddress: test@company.com
 *           phoneNumber: '+12358132134'
 *         - contactNotes: Notes 2
 *           emailAddress: test2@company.com
 *           phoneNumber: '+12358132134'
 *     options:
 *       dependson:
 *         - ${testAwsShieldDrtAccessRoleArnAssociation}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Shield proactive engagement using the AWS account ID. For example:
 * ```sh
 * $ pulumi import aws:shield/proactiveEngagement:ProactiveEngagement example 123456789012
 * ```
 * @property emergencyContacts One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
 * @property enabled Boolean value indicating if Proactive Engagement should be enabled or not.
 */
public data class ProactiveEngagementArgs(
    public val emergencyContacts: Output<List<ProactiveEngagementEmergencyContactArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.ProactiveEngagementArgs> {
    override fun toJava(): com.pulumi.aws.shield.ProactiveEngagementArgs =
        com.pulumi.aws.shield.ProactiveEngagementArgs.builder()
            .emergencyContacts(
                emergencyContacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProactiveEngagementArgs].
 */
@PulumiTagMarker
public class ProactiveEngagementArgsBuilder internal constructor() {
    private var emergencyContacts: Output<List<ProactiveEngagementEmergencyContactArgs>>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
     */
    @JvmName("vlrbnohmuljttaja")
    public suspend fun emergencyContacts(`value`: Output<List<ProactiveEngagementEmergencyContactArgs>>) {
        this.emergencyContacts = value
    }

    @JvmName("emshuheaxmhxtvfa")
    public suspend fun emergencyContacts(vararg values: Output<ProactiveEngagementEmergencyContactArgs>) {
        this.emergencyContacts = Output.all(values.asList())
    }

    /**
     * @param values One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
     */
    @JvmName("fqubtspdwsfbgkcg")
    public suspend fun emergencyContacts(values: List<Output<ProactiveEngagementEmergencyContactArgs>>) {
        this.emergencyContacts = Output.all(values)
    }

    /**
     * @param value Boolean value indicating if Proactive Engagement should be enabled or not.
     */
    @JvmName("lnngdswjuyiagitd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
     */
    @JvmName("oahrfcijcekhtsyi")
    public suspend fun emergencyContacts(`value`: List<ProactiveEngagementEmergencyContactArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emergencyContacts = mapped
    }

    /**
     * @param argument One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
     */
    @JvmName("vygdntgsqvjmnixv")
    public suspend fun emergencyContacts(argument: List<suspend ProactiveEngagementEmergencyContactArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProactiveEngagementEmergencyContactArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emergencyContacts = mapped
    }

    /**
     * @param argument One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
     */
    @JvmName("brlnjfjghsltmxsj")
    public suspend fun emergencyContacts(vararg argument: suspend ProactiveEngagementEmergencyContactArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProactiveEngagementEmergencyContactArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emergencyContacts = mapped
    }

    /**
     * @param argument One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
     */
    @JvmName("fatsppsiowmjsdrg")
    public suspend fun emergencyContacts(argument: suspend ProactiveEngagementEmergencyContactArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProactiveEngagementEmergencyContactArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.emergencyContacts = mapped
    }

    /**
     * @param values One or more emergency contacts. You must provide at least one phone number in the emergency contact list. See `emergency_contacts`.
     */
    @JvmName("raebstookfkjghio")
    public suspend fun emergencyContacts(vararg values: ProactiveEngagementEmergencyContactArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emergencyContacts = mapped
    }

    /**
     * @param value Boolean value indicating if Proactive Engagement should be enabled or not.
     */
    @JvmName("jkjcoqutbtsfbwjl")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ProactiveEngagementArgs = ProactiveEngagementArgs(
        emergencyContacts = emergencyContacts,
        enabled = enabled,
    )
}
