@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ProtectionGroup].
 */
@PulumiTagMarker
public class ProtectionGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionGroupArgs = ProtectionGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionGroupArgsBuilder.() -> Unit) {
        val builder = ProtectionGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProtectionGroup {
        val builtJavaResource = com.pulumi.aws.shield.ProtectionGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProtectionGroup(builtJavaResource)
    }
}

/**
 * Creates a grouping of protected resources so they can be handled as a collective.
 * This resource grouping improves the accuracy of detection and reduces false positives. For more information see
 * [Managing AWS Shield Advanced protection groups](https://docs.aws.amazon.com/waf/latest/developerguide/manage-protection-group.html)
 * ## Example Usage
 * ### Create protection group for all resources
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.shield.ProtectionGroup("example", {
 *     protectionGroupId: "example",
 *     aggregation: "MAX",
 *     pattern: "ALL",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.shield.ProtectionGroup("example",
 *     protection_group_id="example",
 *     aggregation="MAX",
 *     pattern="ALL")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Shield.ProtectionGroup("example", new()
 *     {
 *         ProtectionGroupId = "example",
 *         Aggregation = "MAX",
 *         Pattern = "ALL",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := shield.NewProtectionGroup(ctx, "example", &shield.ProtectionGroupArgs{
 * 			ProtectionGroupId: pulumi.String("example"),
 * 			Aggregation:       pulumi.String("MAX"),
 * 			Pattern:           pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.ProtectionGroup;
 * import com.pulumi.aws.shield.ProtectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProtectionGroup("example", ProtectionGroupArgs.builder()
 *             .protectionGroupId("example")
 *             .aggregation("MAX")
 *             .pattern("ALL")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:shield:ProtectionGroup
 *     properties:
 *       protectionGroupId: example
 *       aggregation: MAX
 *       pattern: ALL
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create protection group for arbitrary number of resources
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const currentGetCallerIdentity = aws.getCallerIdentity({});
 * const example = new aws.ec2.Eip("example", {domain: "vpc"});
 * const exampleProtection = new aws.shield.Protection("example", {
 *     name: "example",
 *     resourceArn: pulumi.all([current, currentGetCallerIdentity, example&#46;id])&#46;apply(([current, currentGetCallerIdentity, id]) => `arn:aws:ec2:${current.name}:${currentGetCallerIdentity.accountId}:eip-allocation/${id}`),
 * });
 * const exampleProtectionGroup = new aws.shield.ProtectionGroup("example", {
 *     protectionGroupId: "example",
 *     aggregation: "MEAN",
 *     pattern: "ARBITRARY",
 *     members: [pulumi&#46;all([current, currentGetCallerIdentity, example&#46;id])&#46;apply(([current, currentGetCallerIdentity, id]) => `arn:aws:ec2:${current&#46;name}:${currentGetCallerIdentity&#46;accountId}:eip-allocation/${id}`)],
 * }, {
 *     dependsOn: [exampleProtection],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * current_get_caller_identity = aws.get_caller_identity()
 * example = aws.ec2.Eip("example", domain="vpc")
 * example_protection = aws.shield.Protection("example",
 *     name="example",
 *     resource_arn=example.id.apply(lambda id: f"arn:aws:ec2:{current.name}:{current_get_caller_identity.account_id}:eip-allocation/{id}"))
 * example_protection_group = aws.shield.ProtectionGroup("example",
 *     protection_group_id="example",
 *     aggregation="MEAN",
 *     pattern="ARBITRARY",
 *     members=[example&#46;id&#46;apply(lambda id: f"arn:aws:ec2:{current&#46;name}:{current_get_caller_identity&#46;account_id}:eip-allocation/{id}")],
 *     opts = pulumi.ResourceOptions(depends_on=[example_protection]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var currentGetCallerIdentity = Aws.GetCallerIdentity.Invoke();
 *     var example = new Aws.Ec2.Eip("example", new()
 *     {
 *         Domain = "vpc",
 *     });
 *     var exampleProtection = new Aws.Shield.Protection("example", new()
 *     {
 *         Name = "example",
 *         ResourceArn = Output.Tuple(current, currentGetCallerIdentity, example.Id).Apply(values =>
 *         {
 *             var current = values.Item1;
 *             var currentGetCallerIdentity = values.Item2;
 *             var id = values.Item3;
 *             return $"arn:aws:ec2:{current.Apply(getRegionResult => getRegionResult.Name)}:{currentGetCallerIdentity.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:eip-allocation/{id}";
 *         }),
 *     });
 *     var exampleProtectionGroup = new Aws.Shield.ProtectionGroup("example", new()
 *     {
 *         ProtectionGroupId = "example",
 *         Aggregation = "MEAN",
 *         Pattern = "ARBITRARY",
 *         Members = new[]
 *         {
 *             Output.Tuple(current, currentGetCallerIdentity, example.Id).Apply(values =>
 *             {
 *                 var current = values.Item1;
 *                 var currentGetCallerIdentity = values.Item2;
 *                 var id = values.Item3;
 *                 return $"arn:aws:ec2:{current.Apply(getRegionResult => getRegionResult.Name)}:{currentGetCallerIdentity.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:eip-allocation/{id}";
 *             }),
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleProtection,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetCallerIdentity, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ec2.NewEip(ctx, "example", &ec2.EipArgs{
 * 			Domain: pulumi.String("vpc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleProtection, err := shield.NewProtection(ctx, "example", &shield.ProtectionArgs{
 * 			Name: pulumi.String("example"),
 * 			ResourceArn: example.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf("arn:aws:ec2:%v:%v:eip-allocation/%v", current.Name, currentGetCallerIdentity.AccountId, id), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = shield.NewProtectionGroup(ctx, "example", &shield.ProtectionGroupArgs{
 * 			ProtectionGroupId: pulumi.String("example"),
 * 			Aggregation:       pulumi.String("MEAN"),
 * 			Pattern:           pulumi.String("ARBITRARY"),
 * 			Members: pulumi.StringArray{
 * 				example.ID().ApplyT(func(id string) (string, error) {
 * 					return fmt.Sprintf("arn:aws:ec2:%v:%v:eip-allocation/%v", current.Name, currentGetCallerIdentity.AccountId, id), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleProtection,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.shield.Protection;
 * import com.pulumi.aws.shield.ProtectionArgs;
 * import com.pulumi.aws.shield.ProtectionGroup;
 * import com.pulumi.aws.shield.ProtectionGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         final var currentGetCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var example = new Eip("example", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var exampleProtection = new Protection("exampleProtection", ProtectionArgs.builder()
 *             .name("example")
 *             .resourceArn(example.id().applyValue(id -> String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", current.applyValue(getRegionResult -> getRegionResult.name()),currentGetCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),id)))
 *             .build());
 *         var exampleProtectionGroup = new ProtectionGroup("exampleProtectionGroup", ProtectionGroupArgs.builder()
 *             .protectionGroupId("example")
 *             .aggregation("MEAN")
 *             .pattern("ARBITRARY")
 *             .members(example.id().applyValue(id -> String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", current.applyValue(getRegionResult -> getRegionResult.name()),currentGetCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),id)))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleProtection)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Eip
 *     properties:
 *       domain: vpc
 *   exampleProtection:
 *     type: aws:shield:Protection
 *     name: example
 *     properties:
 *       name: example
 *       resourceArn: arn:aws:ec2:${current.name}:${currentGetCallerIdentity.accountId}:eip-allocation/${example.id}
 *   exampleProtectionGroup:
 *     type: aws:shield:ProtectionGroup
 *     name: example
 *     properties:
 *       protectionGroupId: example
 *       aggregation: MEAN
 *       pattern: ARBITRARY
 *       members:
 *         - arn:aws:ec2:${current.name}:${currentGetCallerIdentity.accountId}:eip-allocation/${example.id}
 *     options:
 *       dependson:
 *         - ${exampleProtection}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 *   currentGetCallerIdentity:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create protection group for a type of resource
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.shield.ProtectionGroup("example", {
 *     protectionGroupId: "example",
 *     aggregation: "SUM",
 *     pattern: "BY_RESOURCE_TYPE",
 *     resourceType: "ELASTIC_IP_ALLOCATION",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.shield.ProtectionGroup("example",
 *     protection_group_id="example",
 *     aggregation="SUM",
 *     pattern="BY_RESOURCE_TYPE",
 *     resource_type="ELASTIC_IP_ALLOCATION")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Shield.ProtectionGroup("example", new()
 *     {
 *         ProtectionGroupId = "example",
 *         Aggregation = "SUM",
 *         Pattern = "BY_RESOURCE_TYPE",
 *         ResourceType = "ELASTIC_IP_ALLOCATION",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := shield.NewProtectionGroup(ctx, "example", &shield.ProtectionGroupArgs{
 * 			ProtectionGroupId: pulumi.String("example"),
 * 			Aggregation:       pulumi.String("SUM"),
 * 			Pattern:           pulumi.String("BY_RESOURCE_TYPE"),
 * 			ResourceType:      pulumi.String("ELASTIC_IP_ALLOCATION"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.ProtectionGroup;
 * import com.pulumi.aws.shield.ProtectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProtectionGroup("example", ProtectionGroupArgs.builder()
 *             .protectionGroupId("example")
 *             .aggregation("SUM")
 *             .pattern("BY_RESOURCE_TYPE")
 *             .resourceType("ELASTIC_IP_ALLOCATION")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:shield:ProtectionGroup
 *     properties:
 *       protectionGroupId: example
 *       aggregation: SUM
 *       pattern: BY_RESOURCE_TYPE
 *       resourceType: ELASTIC_IP_ALLOCATION
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Shield protection group resources using their protection group id. For example:
 * ```sh
 * $ pulumi import aws:shield/protectionGroup:ProtectionGroup example example
 * ```
 */
public class ProtectionGroup internal constructor(
    override val javaResource: com.pulumi.aws.shield.ProtectionGroup,
) : KotlinCustomResource(javaResource, ProtectionGroupMapper) {
    /**
     * Defines how AWS Shield combines resource data for the group in order to detect, mitigate, and report events.
     */
    public val aggregation: Output<String>
        get() = javaResource.aggregation().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set `pattern` to ARBITRARY and you must not set it for any other `pattern` setting.
     */
    public val members: Output<List<String>>?
        get() = javaResource.members().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The criteria to use to choose the protected resources for inclusion in the group.
     */
    public val pattern: Output<String>
        get() = javaResource.pattern().applyValue({ args0 -> args0 })

    /**
     * The ARN (Amazon Resource Name) of the protection group.
     */
    public val protectionGroupArn: Output<String>
        get() = javaResource.protectionGroupArn().applyValue({ args0 -> args0 })

    /**
     * The name of the protection group.
     */
    public val protectionGroupId: Output<String>
        get() = javaResource.protectionGroupId().applyValue({ args0 -> args0 })

    /**
     * The resource type to include in the protection group. You must set this when you set `pattern` to BY_RESOURCE_TYPE and you must not set it for any other `pattern` setting.
     */
    public val resourceType: Output<String>?
        get() = javaResource.resourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProtectionGroupMapper : ResourceMapper<ProtectionGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.ProtectionGroup::class == javaResource::class

    override fun map(javaResource: Resource): ProtectionGroup = ProtectionGroup(
        javaResource as
            com.pulumi.aws.shield.ProtectionGroup,
    )
}

/**
 * @see [ProtectionGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectionGroup].
 */
public suspend fun protectionGroup(
    name: String,
    block: suspend ProtectionGroupResourceBuilder.() -> Unit,
): ProtectionGroup {
    val builder = ProtectionGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectionGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectionGroup(name: String): ProtectionGroup {
    val builder = ProtectionGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
