@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Subscription].
 */
@PulumiTagMarker
public class SubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubscriptionArgs = SubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubscriptionArgsBuilder.() -> Unit) {
        val builder = SubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Subscription {
        val builtJavaResource = com.pulumi.aws.shield.Subscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subscription(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Shield Subscription.
 * > This resource creates a subscription to AWS Shield Advanced, which requires a 1 year subscription commitment with a monthly fee. Refer to the [AWS Shield Pricing](https://aws.amazon.com/shield/pricing/) page for more details.
 * > Destruction of this resource will set `auto_renew` to `DISABLED`. Automatic renewal can only be disabled during the last 30 days of a subscription. To unsubscribe outside of this window, you must contact AWS Support. Set `skip_destroy` to `true` to skip modifying the `auto_renew` argument during destruction.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.shield.Subscription("example", {autoRenew: "ENABLED"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.shield.Subscription("example", auto_renew="ENABLED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Shield.Subscription("example", new()
 *     {
 *         AutoRenew = "ENABLED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := shield.NewSubscription(ctx, "example", &shield.SubscriptionArgs{
 * 			AutoRenew: pulumi.String("ENABLED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.Subscription;
 * import com.pulumi.aws.shield.SubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Subscription("example", SubscriptionArgs.builder()
 *             .autoRenew("ENABLED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:shield:Subscription
 *     properties:
 *       autoRenew: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Shield Subscription using the `id`. For example:
 * ```sh
 * $ pulumi import aws:shield/subscription:Subscription example 012345678901
 * ```
 */
public class Subscription internal constructor(
    override val javaResource: com.pulumi.aws.shield.Subscription,
) : KotlinCustomResource(javaResource, SubscriptionMapper) {
    /**
     * Toggle for automated renewal of the subscription. Valid values are `ENABLED` or `DISABLED`. Default is `ENABLED`.
     */
    public val autoRenew: Output<String>
        get() = javaResource.autoRenew().applyValue({ args0 -> args0 })

    /**
     * Skip attempting to disable automated renewal upon destruction. If set to `true`, the `auto_renew` value will be left as-is and the resource will simply be removed from state.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SubscriptionMapper : ResourceMapper<Subscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.shield.Subscription::class == javaResource::class

    override fun map(javaResource: Resource): Subscription = Subscription(
        javaResource as
            com.pulumi.aws.shield.Subscription,
    )
}

/**
 * @see [Subscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subscription].
 */
public suspend fun subscription(
    name: String,
    block: suspend SubscriptionResourceBuilder.() -> Unit,
): Subscription {
    val builder = SubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subscription(name: String): Subscription {
    val builder = SubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
