@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin

import com.pulumi.aws.shield.SubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Shield Subscription.
 * > This resource creates a subscription to AWS Shield Advanced, which requires a 1 year subscription commitment with a monthly fee. Refer to the [AWS Shield Pricing](https://aws.amazon.com/shield/pricing/) page for more details.
 * > Destruction of this resource will set `auto_renew` to `DISABLED`. Automatic renewal can only be disabled during the last 30 days of a subscription. To unsubscribe outside of this window, you must contact AWS Support. Set `skip_destroy` to `true` to skip modifying the `auto_renew` argument during destruction.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.shield.Subscription("example", {autoRenew: "ENABLED"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.shield.Subscription("example", auto_renew="ENABLED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Shield.Subscription("example", new()
 *     {
 *         AutoRenew = "ENABLED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/shield"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := shield.NewSubscription(ctx, "example", &shield.SubscriptionArgs{
 * 			AutoRenew: pulumi.String("ENABLED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.shield.Subscription;
 * import com.pulumi.aws.shield.SubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Subscription("example", SubscriptionArgs.builder()
 *             .autoRenew("ENABLED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:shield:Subscription
 *     properties:
 *       autoRenew: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Shield Subscription using the `id`. For example:
 * ```sh
 * $ pulumi import aws:shield/subscription:Subscription example 012345678901
 * ```
 * @property autoRenew Toggle for automated renewal of the subscription. Valid values are `ENABLED` or `DISABLED`. Default is `ENABLED`.
 * @property skipDestroy Skip attempting to disable automated renewal upon destruction. If set to `true`, the `auto_renew` value will be left as-is and the resource will simply be removed from state.
 */
public data class SubscriptionArgs(
    public val autoRenew: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.SubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.shield.SubscriptionArgs =
        com.pulumi.aws.shield.SubscriptionArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionArgs].
 */
@PulumiTagMarker
public class SubscriptionArgsBuilder internal constructor() {
    private var autoRenew: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    /**
     * @param value Toggle for automated renewal of the subscription. Valid values are `ENABLED` or `DISABLED`. Default is `ENABLED`.
     */
    @JvmName("puiwiinpcxtopbyk")
    public suspend fun autoRenew(`value`: Output<String>) {
        this.autoRenew = value
    }

    /**
     * @param value Skip attempting to disable automated renewal upon destruction. If set to `true`, the `auto_renew` value will be left as-is and the resource will simply be removed from state.
     */
    @JvmName("khbmioklonxsheco")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Toggle for automated renewal of the subscription. Valid values are `ENABLED` or `DISABLED`. Default is `ENABLED`.
     */
    @JvmName("fnmrhoxuhyadeoyj")
    public suspend fun autoRenew(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Skip attempting to disable automated renewal upon destruction. If set to `true`, the `auto_renew` value will be left as-is and the resource will simply be removed from state.
     */
    @JvmName("kgdpgtijrurxglep")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    internal fun build(): SubscriptionArgs = SubscriptionArgs(
        autoRenew = autoRenew,
        skipDestroy = skipDestroy,
    )
}
