@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin.inputs

import com.pulumi.aws.shield.inputs.ProactiveEngagementEmergencyContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactNotes Additional notes regarding the contact.
 * @property emailAddress A valid email address that will be used for this contact.
 * @property phoneNumber A phone number, starting with `+` and up to 15 digits that will be used for this contact.
 */
public data class ProactiveEngagementEmergencyContactArgs(
    public val contactNotes: Output<String>? = null,
    public val emailAddress: Output<String>,
    public val phoneNumber: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.shield.inputs.ProactiveEngagementEmergencyContactArgs> {
    override fun toJava(): com.pulumi.aws.shield.inputs.ProactiveEngagementEmergencyContactArgs =
        com.pulumi.aws.shield.inputs.ProactiveEngagementEmergencyContactArgs.builder()
            .contactNotes(contactNotes?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProactiveEngagementEmergencyContactArgs].
 */
@PulumiTagMarker
public class ProactiveEngagementEmergencyContactArgsBuilder internal constructor() {
    private var contactNotes: Output<String>? = null

    private var emailAddress: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    /**
     * @param value Additional notes regarding the contact.
     */
    @JvmName("wvblebtfcadywxro")
    public suspend fun contactNotes(`value`: Output<String>) {
        this.contactNotes = value
    }

    /**
     * @param value A valid email address that will be used for this contact.
     */
    @JvmName("sebraoibnimaruwa")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value A phone number, starting with `+` and up to 15 digits that will be used for this contact.
     */
    @JvmName("pgwtrglqmdbpwpba")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value Additional notes regarding the contact.
     */
    @JvmName("qyrrocfenrmpduny")
    public suspend fun contactNotes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactNotes = mapped
    }

    /**
     * @param value A valid email address that will be used for this contact.
     */
    @JvmName("gqfqcrmmyjwxogng")
    public suspend fun emailAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value A phone number, starting with `+` and up to 15 digits that will be used for this contact.
     */
    @JvmName("rdkmbygevotidgwn")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    internal fun build(): ProactiveEngagementEmergencyContactArgs =
        ProactiveEngagementEmergencyContactArgs(
            contactNotes = contactNotes,
            emailAddress = emailAddress ?: throw PulumiNullFieldException("emailAddress"),
            phoneNumber = phoneNumber,
        )
}
