@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.shield.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contactNotes Additional notes regarding the contact.
 * @property emailAddress A valid email address that will be used for this contact.
 * @property phoneNumber A phone number, starting with `+` and up to 15 digits that will be used for this contact.
 */
public data class ProactiveEngagementEmergencyContact(
    public val contactNotes: String? = null,
    public val emailAddress: String,
    public val phoneNumber: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.shield.outputs.ProactiveEngagementEmergencyContact): ProactiveEngagementEmergencyContact = ProactiveEngagementEmergencyContact(
            contactNotes = javaType.contactNotes().map({ args0 -> args0 }).orElse(null),
            emailAddress = javaType.emailAddress(),
            phoneNumber = javaType.phoneNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
