@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.SignerFunctions.getSigningJobPlain
import com.pulumi.aws.signer.SignerFunctions.getSigningProfilePlain
import com.pulumi.aws.signer.kotlin.inputs.GetSigningJobPlainArgs
import com.pulumi.aws.signer.kotlin.inputs.GetSigningJobPlainArgsBuilder
import com.pulumi.aws.signer.kotlin.inputs.GetSigningProfilePlainArgs
import com.pulumi.aws.signer.kotlin.inputs.GetSigningProfilePlainArgsBuilder
import com.pulumi.aws.signer.kotlin.outputs.GetSigningJobResult
import com.pulumi.aws.signer.kotlin.outputs.GetSigningProfileResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.signer.kotlin.outputs.GetSigningJobResult.Companion.toKotlin as getSigningJobResultToKotlin
import com.pulumi.aws.signer.kotlin.outputs.GetSigningProfileResult.Companion.toKotlin as getSigningProfileResultToKotlin

public object SignerFunctions {
    /**
     * Provides information about a Signer Signing Job.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const buildSigningJob = aws.signer.getSigningJob({
     *     jobId: "9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * build_signing_job = aws.signer.get_signing_job(job_id="9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var buildSigningJob = Aws.Signer.GetSigningJob.Invoke(new()
     *     {
     *         JobId = "9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/signer"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := signer.LookupSigningJob(ctx, &signer.LookupSigningJobArgs{
     * 			JobId: "9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.signer.SignerFunctions;
     * import com.pulumi.aws.signer.inputs.GetSigningJobArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var buildSigningJob = SignerFunctions.getSigningJob(GetSigningJobArgs.builder()
     *             .jobId("9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   buildSigningJob:
     *     fn::invoke:
     *       Function: aws:signer:getSigningJob
     *       Arguments:
     *         jobId: 9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSigningJob.
     * @return A collection of values returned by getSigningJob.
     */
    public suspend fun getSigningJob(argument: GetSigningJobPlainArgs): GetSigningJobResult =
        getSigningJobResultToKotlin(getSigningJobPlain(argument.toJava()).await())

    /**
     * @see [getSigningJob].
     * @param jobId ID of the signing job on output.
     * @return A collection of values returned by getSigningJob.
     */
    public suspend fun getSigningJob(jobId: String): GetSigningJobResult {
        val argument = GetSigningJobPlainArgs(
            jobId = jobId,
        )
        return getSigningJobResultToKotlin(getSigningJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getSigningJob].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;signer&#46;kotlin&#46;inputs&#46;GetSigningJobPlainArgs].
     * @return A collection of values returned by getSigningJob.
     */
    public suspend fun getSigningJob(argument: suspend GetSigningJobPlainArgsBuilder.() -> Unit): GetSigningJobResult {
        val builder = GetSigningJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSigningJobResultToKotlin(getSigningJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Signer Signing Profile.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const productionSigningProfile = aws.signer.getSigningProfile({
     *     name: "prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * production_signing_profile = aws.signer.get_signing_profile(name="prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var productionSigningProfile = Aws.Signer.GetSigningProfile.Invoke(new()
     *     {
     *         Name = "prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/signer"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := signer.LookupSigningProfile(ctx, &signer.LookupSigningProfileArgs{
     * 			Name: "prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.signer.SignerFunctions;
     * import com.pulumi.aws.signer.inputs.GetSigningProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var productionSigningProfile = SignerFunctions.getSigningProfile(GetSigningProfileArgs.builder()
     *             .name("prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   productionSigningProfile:
     *     fn::invoke:
     *       Function: aws:signer:getSigningProfile
     *       Arguments:
     *         name: prod_profile_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSigningProfile.
     * @return A collection of values returned by getSigningProfile.
     */
    public suspend fun getSigningProfile(argument: GetSigningProfilePlainArgs): GetSigningProfileResult =
        getSigningProfileResultToKotlin(getSigningProfilePlain(argument.toJava()).await())

    /**
     * @see [getSigningProfile].
     * @param name Name of the target signing profile.
     * @param tags List of tags associated with the signing profile.
     * @return A collection of values returned by getSigningProfile.
     */
    public suspend fun getSigningProfile(name: String, tags: Map<String, String>? = null): GetSigningProfileResult {
        val argument = GetSigningProfilePlainArgs(
            name = name,
            tags = tags,
        )
        return getSigningProfileResultToKotlin(getSigningProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getSigningProfile].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;signer&#46;kotlin&#46;inputs&#46;GetSigningProfilePlainArgs].
     * @return A collection of values returned by getSigningProfile.
     */
    public suspend fun getSigningProfile(argument: suspend GetSigningProfilePlainArgsBuilder.() -> Unit): GetSigningProfileResult {
        val builder = GetSigningProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSigningProfileResultToKotlin(getSigningProfilePlain(builtArgument.toJava()).await())
    }
}
