@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.kotlin.outputs.SigningJobDestination
import com.pulumi.aws.signer.kotlin.outputs.SigningJobRevocationRecord
import com.pulumi.aws.signer.kotlin.outputs.SigningJobSignedObject
import com.pulumi.aws.signer.kotlin.outputs.SigningJobSource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.signer.kotlin.outputs.SigningJobDestination.Companion.toKotlin as signingJobDestinationToKotlin
import com.pulumi.aws.signer.kotlin.outputs.SigningJobRevocationRecord.Companion.toKotlin as signingJobRevocationRecordToKotlin
import com.pulumi.aws.signer.kotlin.outputs.SigningJobSignedObject.Companion.toKotlin as signingJobSignedObjectToKotlin
import com.pulumi.aws.signer.kotlin.outputs.SigningJobSource.Companion.toKotlin as signingJobSourceToKotlin

/**
 * Builder for [SigningJob].
 */
@PulumiTagMarker
public class SigningJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SigningJobArgs = SigningJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SigningJobArgsBuilder.() -> Unit) {
        val builder = SigningJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SigningJob {
        val builtJavaResource = com.pulumi.aws.signer.SigningJob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SigningJob(builtJavaResource)
    }
}

/**
 * Creates a Signer Signing Job.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testSp = new aws.signer.SigningProfile("test_sp", {platformId: "AWSLambda-SHA384-ECDSA"});
 * const buildSigningJob = new aws.signer.SigningJob("build_signing_job", {
 *     profileName: testSp.name,
 *     source: {
 *         s3: {
 *             bucket: "s3-bucket-name",
 *             key: "object-to-be-signed.zip",
 *             version: "jADjFYYYEXAMPLETszPjOmCMFDzd9dN1",
 *         },
 *     },
 *     destination: {
 *         s3: {
 *             bucket: "s3-bucket-name",
 *             prefix: "signed/",
 *         },
 *     },
 *     ignoreSigningJobFailure: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_sp = aws.signer.SigningProfile("test_sp", platform_id="AWSLambda-SHA384-ECDSA")
 * build_signing_job = aws.signer.SigningJob("build_signing_job",
 *     profile_name=test_sp.name,
 *     source={
 *         "s3": {
 *             "bucket": "s3-bucket-name",
 *             "key": "object-to-be-signed.zip",
 *             "version": "jADjFYYYEXAMPLETszPjOmCMFDzd9dN1",
 *         },
 *     },
 *     destination={
 *         "s3": {
 *             "bucket": "s3-bucket-name",
 *             "prefix": "signed/",
 *         },
 *     },
 *     ignore_signing_job_failure=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testSp = new Aws.Signer.SigningProfile("test_sp", new()
 *     {
 *         PlatformId = "AWSLambda-SHA384-ECDSA",
 *     });
 *     var buildSigningJob = new Aws.Signer.SigningJob("build_signing_job", new()
 *     {
 *         ProfileName = testSp.Name,
 *         Source = new Aws.Signer.Inputs.SigningJobSourceArgs
 *         {
 *             S3 = new Aws.Signer.Inputs.SigningJobSourceS3Args
 *             {
 *                 Bucket = "s3-bucket-name",
 *                 Key = "object-to-be-signed.zip",
 *                 Version = "jADjFYYYEXAMPLETszPjOmCMFDzd9dN1",
 *             },
 *         },
 *         Destination = new Aws.Signer.Inputs.SigningJobDestinationArgs
 *         {
 *             S3 = new Aws.Signer.Inputs.SigningJobDestinationS3Args
 *             {
 *                 Bucket = "s3-bucket-name",
 *                 Prefix = "signed/",
 *             },
 *         },
 *         IgnoreSigningJobFailure = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/signer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testSp, err := signer.NewSigningProfile(ctx, "test_sp", &signer.SigningProfileArgs{
 * 			PlatformId: pulumi.String("AWSLambda-SHA384-ECDSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = signer.NewSigningJob(ctx, "build_signing_job", &signer.SigningJobArgs{
 * 			ProfileName: testSp.Name,
 * 			Source: &signer.SigningJobSourceArgs{
 * 				S3: &signer.SigningJobSourceS3Args{
 * 					Bucket:  pulumi.String("s3-bucket-name"),
 * 					Key:     pulumi.String("object-to-be-signed.zip"),
 * 					Version: pulumi.String("jADjFYYYEXAMPLETszPjOmCMFDzd9dN1"),
 * 				},
 * 			},
 * 			Destination: &signer.SigningJobDestinationArgs{
 * 				S3: &signer.SigningJobDestinationS3Args{
 * 					Bucket: pulumi.String("s3-bucket-name"),
 * 					Prefix: pulumi.String("signed/"),
 * 				},
 * 			},
 * 			IgnoreSigningJobFailure: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.SigningJob;
 * import com.pulumi.aws.signer.SigningJobArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobSourceArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobSourceS3Args;
 * import com.pulumi.aws.signer.inputs.SigningJobDestinationArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobDestinationS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSp = new SigningProfile("testSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .build());
 *         var buildSigningJob = new SigningJob("buildSigningJob", SigningJobArgs.builder()
 *             .profileName(testSp.name())
 *             .source(SigningJobSourceArgs.builder()
 *                 .s3(SigningJobSourceS3Args.builder()
 *                     .bucket("s3-bucket-name")
 *                     .key("object-to-be-signed.zip")
 *                     .version("jADjFYYYEXAMPLETszPjOmCMFDzd9dN1")
 *                     .build())
 *                 .build())
 *             .destination(SigningJobDestinationArgs.builder()
 *                 .s3(SigningJobDestinationS3Args.builder()
 *                     .bucket("s3-bucket-name")
 *                     .prefix("signed/")
 *                     .build())
 *                 .build())
 *             .ignoreSigningJobFailure(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testSp:
 *     type: aws:signer:SigningProfile
 *     name: test_sp
 *     properties:
 *       platformId: AWSLambda-SHA384-ECDSA
 *   buildSigningJob:
 *     type: aws:signer:SigningJob
 *     name: build_signing_job
 *     properties:
 *       profileName: ${testSp.name}
 *       source:
 *         s3:
 *           bucket: s3-bucket-name
 *           key: object-to-be-signed.zip
 *           version: jADjFYYYEXAMPLETszPjOmCMFDzd9dN1
 *       destination:
 *         s3:
 *           bucket: s3-bucket-name
 *           prefix: signed/
 *       ignoreSigningJobFailure: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Signer signing jobs using the `job_id`. For example:
 * ```sh
 * $ pulumi import aws:signer/signingJob:SigningJob test_signer_signing_job 9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee
 * ```
 */
public class SigningJob internal constructor(
    override val javaResource: com.pulumi.aws.signer.SigningJob,
) : KotlinCustomResource(javaResource, SigningJobMapper) {
    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was completed.
     */
    public val completedAt: Output<String>
        get() = javaResource.completedAt().applyValue({ args0 -> args0 })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the signing job was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The S3 bucket in which to save your signed object. See Destination below for details.
     */
    public val destination: Output<SigningJobDestination>
        get() = javaResource.destination().applyValue({ args0 ->
            args0.let({ args0 ->
                signingJobDestinationToKotlin(args0)
            })
        })

    /**
     * Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
     */
    public val ignoreSigningJobFailure: Output<Boolean>?
        get() = javaResource.ignoreSigningJobFailure().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the signing job on output.
     */
    public val jobId: Output<String>
        get() = javaResource.jobId().applyValue({ args0 -> args0 })

    /**
     * The IAM entity that initiated the signing job.
     */
    public val jobInvoker: Output<String>
        get() = javaResource.jobInvoker().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the job owner.
     */
    public val jobOwner: Output<String>
        get() = javaResource.jobOwner().applyValue({ args0 -> args0 })

    /**
     * A human-readable name for the signing platform associated with the signing job.
     */
    public val platformDisplayName: Output<String>
        get() = javaResource.platformDisplayName().applyValue({ args0 -> args0 })

    /**
     * The platform to which your signed code image will be distributed.
     */
    public val platformId: Output<String>
        get() = javaResource.platformId().applyValue({ args0 -> args0 })

    /**
     * The name of the profile to initiate the signing operation.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * The version of the signing profile used to initiate the signing job.
     */
    public val profileVersion: Output<String>
        get() = javaResource.profileVersion().applyValue({ args0 -> args0 })

    /**
     * The IAM principal that requested the signing job.
     */
    public val requestedBy: Output<String>
        get() = javaResource.requestedBy().applyValue({ args0 -> args0 })

    /**
     * A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.
     */
    public val revocationRecords: Output<List<SigningJobRevocationRecord>>
        get() = javaResource.revocationRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> signingJobRevocationRecordToKotlin(args0) })
            })
        })

    /**
     * The time when the signature of a signing job expires.
     */
    public val signatureExpiresAt: Output<String>
        get() = javaResource.signatureExpiresAt().applyValue({ args0 -> args0 })

    /**
     * Name of the S3 bucket where the signed code image is saved by code signing.
     */
    public val signedObjects: Output<List<SigningJobSignedObject>>
        get() = javaResource.signedObjects().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> signingJobSignedObjectToKotlin(args0) })
            })
        })

    /**
     * The S3 bucket that contains the object to sign. See Source below for details.
     */
    public val source: Output<SigningJobSource>
        get() = javaResource.source().applyValue({ args0 ->
            args0.let({ args0 ->
                signingJobSourceToKotlin(args0)
            })
        })

    /**
     * Status of the signing job.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * String value that contains the status reason.
     */
    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })
}

public object SigningJobMapper : ResourceMapper<SigningJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.signer.SigningJob::class == javaResource::class

    override fun map(javaResource: Resource): SigningJob = SigningJob(
        javaResource as
            com.pulumi.aws.signer.SigningJob,
    )
}

/**
 * @see [SigningJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SigningJob].
 */
public suspend fun signingJob(name: String, block: suspend SigningJobResourceBuilder.() -> Unit): SigningJob {
    val builder = SigningJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SigningJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun signingJob(name: String): SigningJob {
    val builder = SigningJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
