@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.SigningJobArgs.builder
import com.pulumi.aws.signer.kotlin.inputs.SigningJobDestinationArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningJobDestinationArgsBuilder
import com.pulumi.aws.signer.kotlin.inputs.SigningJobSourceArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningJobSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Creates a Signer Signing Job.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testSp = new aws.signer.SigningProfile("test_sp", {platformId: "AWSLambda-SHA384-ECDSA"});
 * const buildSigningJob = new aws.signer.SigningJob("build_signing_job", {
 *     profileName: testSp.name,
 *     source: {
 *         s3: {
 *             bucket: "s3-bucket-name",
 *             key: "object-to-be-signed.zip",
 *             version: "jADjFYYYEXAMPLETszPjOmCMFDzd9dN1",
 *         },
 *     },
 *     destination: {
 *         s3: {
 *             bucket: "s3-bucket-name",
 *             prefix: "signed/",
 *         },
 *     },
 *     ignoreSigningJobFailure: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_sp = aws.signer.SigningProfile("test_sp", platform_id="AWSLambda-SHA384-ECDSA")
 * build_signing_job = aws.signer.SigningJob("build_signing_job",
 *     profile_name=test_sp.name,
 *     source={
 *         "s3": {
 *             "bucket": "s3-bucket-name",
 *             "key": "object-to-be-signed.zip",
 *             "version": "jADjFYYYEXAMPLETszPjOmCMFDzd9dN1",
 *         },
 *     },
 *     destination={
 *         "s3": {
 *             "bucket": "s3-bucket-name",
 *             "prefix": "signed/",
 *         },
 *     },
 *     ignore_signing_job_failure=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testSp = new Aws.Signer.SigningProfile("test_sp", new()
 *     {
 *         PlatformId = "AWSLambda-SHA384-ECDSA",
 *     });
 *     var buildSigningJob = new Aws.Signer.SigningJob("build_signing_job", new()
 *     {
 *         ProfileName = testSp.Name,
 *         Source = new Aws.Signer.Inputs.SigningJobSourceArgs
 *         {
 *             S3 = new Aws.Signer.Inputs.SigningJobSourceS3Args
 *             {
 *                 Bucket = "s3-bucket-name",
 *                 Key = "object-to-be-signed.zip",
 *                 Version = "jADjFYYYEXAMPLETszPjOmCMFDzd9dN1",
 *             },
 *         },
 *         Destination = new Aws.Signer.Inputs.SigningJobDestinationArgs
 *         {
 *             S3 = new Aws.Signer.Inputs.SigningJobDestinationS3Args
 *             {
 *                 Bucket = "s3-bucket-name",
 *                 Prefix = "signed/",
 *             },
 *         },
 *         IgnoreSigningJobFailure = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/signer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testSp, err := signer.NewSigningProfile(ctx, "test_sp", &signer.SigningProfileArgs{
 * 			PlatformId: pulumi.String("AWSLambda-SHA384-ECDSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = signer.NewSigningJob(ctx, "build_signing_job", &signer.SigningJobArgs{
 * 			ProfileName: testSp.Name,
 * 			Source: &signer.SigningJobSourceArgs{
 * 				S3: &signer.SigningJobSourceS3Args{
 * 					Bucket:  pulumi.String("s3-bucket-name"),
 * 					Key:     pulumi.String("object-to-be-signed.zip"),
 * 					Version: pulumi.String("jADjFYYYEXAMPLETszPjOmCMFDzd9dN1"),
 * 				},
 * 			},
 * 			Destination: &signer.SigningJobDestinationArgs{
 * 				S3: &signer.SigningJobDestinationS3Args{
 * 					Bucket: pulumi.String("s3-bucket-name"),
 * 					Prefix: pulumi.String("signed/"),
 * 				},
 * 			},
 * 			IgnoreSigningJobFailure: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.SigningJob;
 * import com.pulumi.aws.signer.SigningJobArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobSourceArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobSourceS3Args;
 * import com.pulumi.aws.signer.inputs.SigningJobDestinationArgs;
 * import com.pulumi.aws.signer.inputs.SigningJobDestinationS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSp = new SigningProfile("testSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .build());
 *         var buildSigningJob = new SigningJob("buildSigningJob", SigningJobArgs.builder()
 *             .profileName(testSp.name())
 *             .source(SigningJobSourceArgs.builder()
 *                 .s3(SigningJobSourceS3Args.builder()
 *                     .bucket("s3-bucket-name")
 *                     .key("object-to-be-signed.zip")
 *                     .version("jADjFYYYEXAMPLETszPjOmCMFDzd9dN1")
 *                     .build())
 *                 .build())
 *             .destination(SigningJobDestinationArgs.builder()
 *                 .s3(SigningJobDestinationS3Args.builder()
 *                     .bucket("s3-bucket-name")
 *                     .prefix("signed/")
 *                     .build())
 *                 .build())
 *             .ignoreSigningJobFailure(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testSp:
 *     type: aws:signer:SigningProfile
 *     name: test_sp
 *     properties:
 *       platformId: AWSLambda-SHA384-ECDSA
 *   buildSigningJob:
 *     type: aws:signer:SigningJob
 *     name: build_signing_job
 *     properties:
 *       profileName: ${testSp.name}
 *       source:
 *         s3:
 *           bucket: s3-bucket-name
 *           key: object-to-be-signed.zip
 *           version: jADjFYYYEXAMPLETszPjOmCMFDzd9dN1
 *       destination:
 *         s3:
 *           bucket: s3-bucket-name
 *           prefix: signed/
 *       ignoreSigningJobFailure: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Signer signing jobs using the `job_id`. For example:
 * ```sh
 * $ pulumi import aws:signer/signingJob:SigningJob test_signer_signing_job 9ed7e5c3-b8d4-4da0-8459-44e0b068f7ee
 * ```
 * @property destination The S3 bucket in which to save your signed object. See Destination below for details.
 * @property ignoreSigningJobFailure Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
 * @property profileName The name of the profile to initiate the signing operation.
 * @property source The S3 bucket that contains the object to sign. See Source below for details.
 */
public data class SigningJobArgs(
    public val destination: Output<SigningJobDestinationArgs>? = null,
    public val ignoreSigningJobFailure: Output<Boolean>? = null,
    public val profileName: Output<String>? = null,
    public val source: Output<SigningJobSourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.signer.SigningJobArgs> {
    override fun toJava(): com.pulumi.aws.signer.SigningJobArgs =
        com.pulumi.aws.signer.SigningJobArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ignoreSigningJobFailure(ignoreSigningJobFailure?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SigningJobArgs].
 */
@PulumiTagMarker
public class SigningJobArgsBuilder internal constructor() {
    private var destination: Output<SigningJobDestinationArgs>? = null

    private var ignoreSigningJobFailure: Output<Boolean>? = null

    private var profileName: Output<String>? = null

    private var source: Output<SigningJobSourceArgs>? = null

    /**
     * @param value The S3 bucket in which to save your signed object. See Destination below for details.
     */
    @JvmName("puavawxhhpawloap")
    public suspend fun destination(`value`: Output<SigningJobDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
     */
    @JvmName("bfxsesobhydwjenb")
    public suspend fun ignoreSigningJobFailure(`value`: Output<Boolean>) {
        this.ignoreSigningJobFailure = value
    }

    /**
     * @param value The name of the profile to initiate the signing operation.
     */
    @JvmName("uaaefpdiokrawhxt")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The S3 bucket that contains the object to sign. See Source below for details.
     */
    @JvmName("qhrqikkwxlqrxsjm")
    public suspend fun source(`value`: Output<SigningJobSourceArgs>) {
        this.source = value
    }

    /**
     * @param value The S3 bucket in which to save your signed object. See Destination below for details.
     */
    @JvmName("qejdwblnqpeqrbwy")
    public suspend fun destination(`value`: SigningJobDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument The S3 bucket in which to save your signed object. See Destination below for details.
     */
    @JvmName("vdlhiuxekvoaraip")
    public suspend fun destination(argument: suspend SigningJobDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = SigningJobDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Set this argument to `true` to ignore signing job failures and retrieve failed status and reason. Default `false`.
     */
    @JvmName("tajarqxbxpgptupp")
    public suspend fun ignoreSigningJobFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreSigningJobFailure = mapped
    }

    /**
     * @param value The name of the profile to initiate the signing operation.
     */
    @JvmName("hegxvshfcshhttpt")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The S3 bucket that contains the object to sign. See Source below for details.
     */
    @JvmName("hhycxunpfygohedc")
    public suspend fun source(`value`: SigningJobSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The S3 bucket that contains the object to sign. See Source below for details.
     */
    @JvmName("egjhnyamhnuotxac")
    public suspend fun source(argument: suspend SigningJobSourceArgsBuilder.() -> Unit) {
        val toBeMapped = SigningJobSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    internal fun build(): SigningJobArgs = SigningJobArgs(
        destination = destination,
        ignoreSigningJobFailure = ignoreSigningJobFailure,
        profileName = profileName,
        source = source,
    )
}
