@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.kotlin.outputs.SigningProfileRevocationRecord
import com.pulumi.aws.signer.kotlin.outputs.SigningProfileSignatureValidityPeriod
import com.pulumi.aws.signer.kotlin.outputs.SigningProfileSigningMaterial
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.signer.kotlin.outputs.SigningProfileRevocationRecord.Companion.toKotlin as signingProfileRevocationRecordToKotlin
import com.pulumi.aws.signer.kotlin.outputs.SigningProfileSignatureValidityPeriod.Companion.toKotlin as signingProfileSignatureValidityPeriodToKotlin
import com.pulumi.aws.signer.kotlin.outputs.SigningProfileSigningMaterial.Companion.toKotlin as signingProfileSigningMaterialToKotlin

/**
 * Builder for [SigningProfile].
 */
@PulumiTagMarker
public class SigningProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SigningProfileArgs = SigningProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SigningProfileArgsBuilder.() -> Unit) {
        val builder = SigningProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SigningProfile {
        val builtJavaResource = com.pulumi.aws.signer.SigningProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SigningProfile(builtJavaResource)
    }
}

/**
 * Creates a Signer Signing Profile. A signing profile contains information about the code signing configuration parameters that can be used by a given code signing user.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testSp = new aws.signer.SigningProfile("test_sp", {platformId: "AWSLambda-SHA384-ECDSA"});
 * const prodSp = new aws.signer.SigningProfile("prod_sp", {
 *     platformId: "AWSLambda-SHA384-ECDSA",
 *     namePrefix: "prod_sp_",
 *     signatureValidityPeriod: {
 *         value: 5,
 *         type: "YEARS",
 *     },
 *     tags: {
 *         tag1: "value1",
 *         tag2: "value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_sp = aws.signer.SigningProfile("test_sp", platform_id="AWSLambda-SHA384-ECDSA")
 * prod_sp = aws.signer.SigningProfile("prod_sp",
 *     platform_id="AWSLambda-SHA384-ECDSA",
 *     name_prefix="prod_sp_",
 *     signature_validity_period={
 *         "value": 5,
 *         "type": "YEARS",
 *     },
 *     tags={
 *         "tag1": "value1",
 *         "tag2": "value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testSp = new Aws.Signer.SigningProfile("test_sp", new()
 *     {
 *         PlatformId = "AWSLambda-SHA384-ECDSA",
 *     });
 *     var prodSp = new Aws.Signer.SigningProfile("prod_sp", new()
 *     {
 *         PlatformId = "AWSLambda-SHA384-ECDSA",
 *         NamePrefix = "prod_sp_",
 *         SignatureValidityPeriod = new Aws.Signer.Inputs.SigningProfileSignatureValidityPeriodArgs
 *         {
 *             Value = 5,
 *             Type = "YEARS",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/signer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signer.NewSigningProfile(ctx, "test_sp", &signer.SigningProfileArgs{
 * 			PlatformId: pulumi.String("AWSLambda-SHA384-ECDSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = signer.NewSigningProfile(ctx, "prod_sp", &signer.SigningProfileArgs{
 * 			PlatformId: pulumi.String("AWSLambda-SHA384-ECDSA"),
 * 			NamePrefix: pulumi.String("prod_sp_"),
 * 			SignatureValidityPeriod: &signer.SigningProfileSignatureValidityPeriodArgs{
 * 				Value: pulumi.Int(5),
 * 				Type:  pulumi.String("YEARS"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.inputs.SigningProfileSignatureValidityPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSp = new SigningProfile("testSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .build());
 *         var prodSp = new SigningProfile("prodSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .namePrefix("prod_sp_")
 *             .signatureValidityPeriod(SigningProfileSignatureValidityPeriodArgs.builder()
 *                 .value(5)
 *                 .type("YEARS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testSp:
 *     type: aws:signer:SigningProfile
 *     name: test_sp
 *     properties:
 *       platformId: AWSLambda-SHA384-ECDSA
 *   prodSp:
 *     type: aws:signer:SigningProfile
 *     name: prod_sp
 *     properties:
 *       platformId: AWSLambda-SHA384-ECDSA
 *       namePrefix: prod_sp_
 *       signatureValidityPeriod:
 *         value: 5
 *         type: YEARS
 *       tags:
 *         tag1: value1
 *         tag2: value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Signer signing profiles using the `name`. For example:
 * ```sh
 * $ pulumi import aws:signer/signingProfile:SigningProfile test_signer_signing_profile test_sp_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK
 * ```
 */
public class SigningProfile internal constructor(
    override val javaResource: com.pulumi.aws.signer.SigningProfile,
) : KotlinCustomResource(javaResource, SigningProfileMapper) {
    /**
     * The Amazon Resource Name (ARN) for the signing profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A human-readable name for the signing platform associated with the signing profile.
     */
    public val platformDisplayName: Output<String>
        get() = javaResource.platformDisplayName().applyValue({ args0 -> args0 })

    /**
     * The ID of the platform that is used by the target signing profile.
     */
    public val platformId: Output<String>
        get() = javaResource.platformId().applyValue({ args0 -> args0 })

    /**
     * Revocation information for a signing profile. See `revocation_record` Block below for details.
     */
    public val revocationRecords: Output<List<SigningProfileRevocationRecord>>
        get() = javaResource.revocationRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> signingProfileRevocationRecordToKotlin(args0) })
            })
        })

    /**
     * The validity period for a signing job. See `signature_validity_period` Block below for details.
     */
    public val signatureValidityPeriod: Output<SigningProfileSignatureValidityPeriod>
        get() = javaResource.signatureValidityPeriod().applyValue({ args0 ->
            args0.let({ args0 ->
                signingProfileSignatureValidityPeriodToKotlin(args0)
            })
        })

    /**
     * The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
     */
    public val signingMaterial: Output<SigningProfileSigningMaterial>
        get() = javaResource.signingMaterial().applyValue({ args0 ->
            args0.let({ args0 ->
                signingProfileSigningMaterialToKotlin(args0)
            })
        })

    /**
     * The status of the target signing profile.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The current version of the signing profile.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The signing profile ARN, including the profile version.
     */
    public val versionArn: Output<String>
        get() = javaResource.versionArn().applyValue({ args0 -> args0 })
}

public object SigningProfileMapper : ResourceMapper<SigningProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.signer.SigningProfile::class == javaResource::class

    override fun map(javaResource: Resource): SigningProfile = SigningProfile(
        javaResource as
            com.pulumi.aws.signer.SigningProfile,
    )
}

/**
 * @see [SigningProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SigningProfile].
 */
public suspend fun signingProfile(
    name: String,
    block: suspend SigningProfileResourceBuilder.() -> Unit,
): SigningProfile {
    val builder = SigningProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SigningProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun signingProfile(name: String): SigningProfile {
    val builder = SigningProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
