@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin

import com.pulumi.aws.signer.SigningProfileArgs.builder
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSignatureValidityPeriodArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSignatureValidityPeriodArgsBuilder
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSigningMaterialArgs
import com.pulumi.aws.signer.kotlin.inputs.SigningProfileSigningMaterialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Signer Signing Profile. A signing profile contains information about the code signing configuration parameters that can be used by a given code signing user.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testSp = new aws.signer.SigningProfile("test_sp", {platformId: "AWSLambda-SHA384-ECDSA"});
 * const prodSp = new aws.signer.SigningProfile("prod_sp", {
 *     platformId: "AWSLambda-SHA384-ECDSA",
 *     namePrefix: "prod_sp_",
 *     signatureValidityPeriod: {
 *         value: 5,
 *         type: "YEARS",
 *     },
 *     tags: {
 *         tag1: "value1",
 *         tag2: "value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_sp = aws.signer.SigningProfile("test_sp", platform_id="AWSLambda-SHA384-ECDSA")
 * prod_sp = aws.signer.SigningProfile("prod_sp",
 *     platform_id="AWSLambda-SHA384-ECDSA",
 *     name_prefix="prod_sp_",
 *     signature_validity_period={
 *         "value": 5,
 *         "type": "YEARS",
 *     },
 *     tags={
 *         "tag1": "value1",
 *         "tag2": "value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testSp = new Aws.Signer.SigningProfile("test_sp", new()
 *     {
 *         PlatformId = "AWSLambda-SHA384-ECDSA",
 *     });
 *     var prodSp = new Aws.Signer.SigningProfile("prod_sp", new()
 *     {
 *         PlatformId = "AWSLambda-SHA384-ECDSA",
 *         NamePrefix = "prod_sp_",
 *         SignatureValidityPeriod = new Aws.Signer.Inputs.SigningProfileSignatureValidityPeriodArgs
 *         {
 *             Value = 5,
 *             Type = "YEARS",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/signer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := signer.NewSigningProfile(ctx, "test_sp", &signer.SigningProfileArgs{
 * 			PlatformId: pulumi.String("AWSLambda-SHA384-ECDSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = signer.NewSigningProfile(ctx, "prod_sp", &signer.SigningProfileArgs{
 * 			PlatformId: pulumi.String("AWSLambda-SHA384-ECDSA"),
 * 			NamePrefix: pulumi.String("prod_sp_"),
 * 			SignatureValidityPeriod: &signer.SigningProfileSignatureValidityPeriodArgs{
 * 				Value: pulumi.Int(5),
 * 				Type:  pulumi.String("YEARS"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.signer.SigningProfile;
 * import com.pulumi.aws.signer.SigningProfileArgs;
 * import com.pulumi.aws.signer.inputs.SigningProfileSignatureValidityPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSp = new SigningProfile("testSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .build());
 *         var prodSp = new SigningProfile("prodSp", SigningProfileArgs.builder()
 *             .platformId("AWSLambda-SHA384-ECDSA")
 *             .namePrefix("prod_sp_")
 *             .signatureValidityPeriod(SigningProfileSignatureValidityPeriodArgs.builder()
 *                 .value(5)
 *                 .type("YEARS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testSp:
 *     type: aws:signer:SigningProfile
 *     name: test_sp
 *     properties:
 *       platformId: AWSLambda-SHA384-ECDSA
 *   prodSp:
 *     type: aws:signer:SigningProfile
 *     name: prod_sp
 *     properties:
 *       platformId: AWSLambda-SHA384-ECDSA
 *       namePrefix: prod_sp_
 *       signatureValidityPeriod:
 *         value: 5
 *         type: YEARS
 *       tags:
 *         tag1: value1
 *         tag2: value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Signer signing profiles using the `name`. For example:
 * ```sh
 * $ pulumi import aws:signer/signingProfile:SigningProfile test_signer_signing_profile test_sp_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK
 * ```
 * @property name
 * @property namePrefix
 * @property platformId The ID of the platform that is used by the target signing profile.
 * @property signatureValidityPeriod The validity period for a signing job. See `signature_validity_period` Block below for details.
 * @property signingMaterial The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
 * @property tags A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SigningProfileArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val platformId: Output<String>? = null,
    public val signatureValidityPeriod: Output<SigningProfileSignatureValidityPeriodArgs>? = null,
    public val signingMaterial: Output<SigningProfileSigningMaterialArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.signer.SigningProfileArgs> {
    override fun toJava(): com.pulumi.aws.signer.SigningProfileArgs =
        com.pulumi.aws.signer.SigningProfileArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .platformId(platformId?.applyValue({ args0 -> args0 }))
            .signatureValidityPeriod(
                signatureValidityPeriod?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .signingMaterial(signingMaterial?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SigningProfileArgs].
 */
@PulumiTagMarker
public class SigningProfileArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var platformId: Output<String>? = null

    private var signatureValidityPeriod: Output<SigningProfileSignatureValidityPeriodArgs>? = null

    private var signingMaterial: Output<SigningProfileSigningMaterialArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("ttfahgxndfonemjj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("gpakmerfturxaogr")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The ID of the platform that is used by the target signing profile.
     */
    @JvmName("lkdhjubqmuscfpel")
    public suspend fun platformId(`value`: Output<String>) {
        this.platformId = value
    }

    /**
     * @param value The validity period for a signing job. See `signature_validity_period` Block below for details.
     */
    @JvmName("anfrngofdxbbjkta")
    public suspend fun signatureValidityPeriod(`value`: Output<SigningProfileSignatureValidityPeriodArgs>) {
        this.signatureValidityPeriod = value
    }

    /**
     * @param value The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
     */
    @JvmName("jogpfpmgwsaxevhd")
    public suspend fun signingMaterial(`value`: Output<SigningProfileSigningMaterialArgs>) {
        this.signingMaterial = value
    }

    /**
     * @param value A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xoeqriacfglfcggi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("lvphwegynjljcgiq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("eshdewxoxtmuqkbj")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The ID of the platform that is used by the target signing profile.
     */
    @JvmName("chbgulcibuebrhes")
    public suspend fun platformId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformId = mapped
    }

    /**
     * @param value The validity period for a signing job. See `signature_validity_period` Block below for details.
     */
    @JvmName("alcjlmkxxyqbdgao")
    public suspend fun signatureValidityPeriod(`value`: SigningProfileSignatureValidityPeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signatureValidityPeriod = mapped
    }

    /**
     * @param argument The validity period for a signing job. See `signature_validity_period` Block below for details.
     */
    @JvmName("osunphhvbmvlfxsu")
    public suspend fun signatureValidityPeriod(argument: suspend SigningProfileSignatureValidityPeriodArgsBuilder.() -> Unit) {
        val toBeMapped = SigningProfileSignatureValidityPeriodArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.signatureValidityPeriod = mapped
    }

    /**
     * @param value The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
     */
    @JvmName("beyvxqfanskniweh")
    public suspend fun signingMaterial(`value`: SigningProfileSigningMaterialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingMaterial = mapped
    }

    /**
     * @param argument The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
     */
    @JvmName("pfkgihiybvnhenbs")
    public suspend fun signingMaterial(argument: suspend SigningProfileSigningMaterialArgsBuilder.() -> Unit) {
        val toBeMapped = SigningProfileSigningMaterialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.signingMaterial = mapped
    }

    /**
     * @param value A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yfewgjenwknjqery")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vtiivpdrxwuyjapt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SigningProfileArgs = SigningProfileArgs(
        name = name,
        namePrefix = namePrefix,
        platformId = platformId,
        signatureValidityPeriod = signatureValidityPeriod,
        signingMaterial = signingMaterial,
        tags = tags,
    )
}
