@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.inputs

import com.pulumi.aws.signer.inputs.GetSigningJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSigningJob.
 * @property jobId ID of the signing job on output.
 */
public data class GetSigningJobPlainArgs(
    public val jobId: String,
) : ConvertibleToJava<com.pulumi.aws.signer.inputs.GetSigningJobPlainArgs> {
    override fun toJava(): com.pulumi.aws.signer.inputs.GetSigningJobPlainArgs =
        com.pulumi.aws.signer.inputs.GetSigningJobPlainArgs.builder()
            .jobId(jobId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSigningJobPlainArgs].
 */
@PulumiTagMarker
public class GetSigningJobPlainArgsBuilder internal constructor() {
    private var jobId: String? = null

    /**
     * @param value ID of the signing job on output.
     */
    @JvmName("jmsqqwvflueuxetk")
    public suspend fun jobId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobId = mapped
    }

    internal fun build(): GetSigningJobPlainArgs = GetSigningJobPlainArgs(
        jobId = jobId ?: throw PulumiNullFieldException("jobId"),
    )
}
