@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.inputs

import com.pulumi.aws.signer.inputs.SigningJobDestinationS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket
 * @property prefix An Amazon S3 object key prefix that you can use to limit signed objects keys to begin with the specified prefix.
 */
public data class SigningJobDestinationS3Args(
    public val bucket: Output<String>,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.signer.inputs.SigningJobDestinationS3Args> {
    override fun toJava(): com.pulumi.aws.signer.inputs.SigningJobDestinationS3Args =
        com.pulumi.aws.signer.inputs.SigningJobDestinationS3Args.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SigningJobDestinationS3Args].
 */
@PulumiTagMarker
public class SigningJobDestinationS3ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("dggrmtwjssptauya")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value An Amazon S3 object key prefix that you can use to limit signed objects keys to begin with the specified prefix.
     */
    @JvmName("qkvryvskmiuvouyh")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value
     */
    @JvmName("ptmiegohggtqalod")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value An Amazon S3 object key prefix that you can use to limit signed objects keys to begin with the specified prefix.
     */
    @JvmName("owhyxjadssusiruv")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): SigningJobDestinationS3Args = SigningJobDestinationS3Args(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        prefix = prefix,
    )
}
