@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.inputs

import com.pulumi.aws.signer.inputs.SigningJobSourceS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket
 * @property key Key name of the object that contains your unsigned code.
 * @property version Version of your source image in your version enabled S3 bucket.
 */
public data class SigningJobSourceS3Args(
    public val bucket: Output<String>,
    public val key: Output<String>,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.signer.inputs.SigningJobSourceS3Args> {
    override fun toJava(): com.pulumi.aws.signer.inputs.SigningJobSourceS3Args =
        com.pulumi.aws.signer.inputs.SigningJobSourceS3Args.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SigningJobSourceS3Args].
 */
@PulumiTagMarker
public class SigningJobSourceS3ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var key: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("llsagshpcjcecipp")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Key name of the object that contains your unsigned code.
     */
    @JvmName("pvyvyedxckpbqevy")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Version of your source image in your version enabled S3 bucket.
     */
    @JvmName("tbgryjgmdfuelhdc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value
     */
    @JvmName("pbhyatgrhxmbiaxb")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Key name of the object that contains your unsigned code.
     */
    @JvmName("yjtrdidgmlwtfjuu")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Version of your source image in your version enabled S3 bucket.
     */
    @JvmName("bcusnmtuowkshmpc")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SigningJobSourceS3Args = SigningJobSourceS3Args(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        key = key ?: throw PulumiNullFieldException("key"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
