@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSigningProfile.
 * @property arn ARN for the signing profile.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property platformDisplayName A human-readable name for the signing platform associated with the signing profile.
 * @property platformId ID of the platform that is used by the target signing profile.
 * @property revocationRecords Revocation information for a signing profile.
 * @property signatureValidityPeriods The validity period for a signing job.
 * @property status Status of the target signing profile.
 * @property tags List of tags associated with the signing profile.
 * @property version Current version of the signing profile.
 * @property versionArn Signing profile ARN, including the profile version.
 */
public data class GetSigningProfileResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val platformDisplayName: String,
    public val platformId: String,
    public val revocationRecords: List<GetSigningProfileRevocationRecord>,
    public val signatureValidityPeriods: List<GetSigningProfileSignatureValidityPeriod>,
    public val status: String,
    public val tags: Map<String, String>,
    public val version: String,
    public val versionArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.signer.outputs.GetSigningProfileResult): GetSigningProfileResult = GetSigningProfileResult(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
            platformDisplayName = javaType.platformDisplayName(),
            platformId = javaType.platformId(),
            revocationRecords = javaType.revocationRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.signer.kotlin.outputs.GetSigningProfileRevocationRecord.Companion.toKotlin(args0)
                })
            }),
            signatureValidityPeriods = javaType.signatureValidityPeriods().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.signer.kotlin.outputs.GetSigningProfileSignatureValidityPeriod.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            version = javaType.version(),
            versionArn = javaType.versionArn(),
        )
    }
}
