@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket
 * @property prefix An Amazon S3 object key prefix that you can use to limit signed objects keys to begin with the specified prefix.
 */
public data class SigningJobDestinationS3(
    public val bucket: String,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.signer.outputs.SigningJobDestinationS3): SigningJobDestinationS3 = SigningJobDestinationS3(
            bucket = javaType.bucket(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
