@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket
 * @property key Key name of the object that contains your unsigned code.
 * @property version Version of your source image in your version enabled S3 bucket.
 */
public data class SigningJobSourceS3(
    public val bucket: String,
    public val key: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.signer.outputs.SigningJobSourceS3): SigningJobSourceS3 = SigningJobSourceS3(
            bucket = javaType.bucket(),
            key = javaType.key(),
            version = javaType.version(),
        )
    }
}
