@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.signer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property revocationEffectiveFrom The time when revocation becomes effective.
 * @property revokedAt The time when the signing profile was revoked.
 * @property revokedBy The identity of the revoker.
 */
public data class SigningProfileRevocationRecord(
    public val revocationEffectiveFrom: String? = null,
    public val revokedAt: String? = null,
    public val revokedBy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.signer.outputs.SigningProfileRevocationRecord): SigningProfileRevocationRecord = SigningProfileRevocationRecord(
            revocationEffectiveFrom = javaType.revocationEffectiveFrom().map({ args0 -> args0 }).orElse(null),
            revokedAt = javaType.revokedAt().map({ args0 -> args0 }).orElse(null),
            revokedBy = javaType.revokedBy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
