@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.simpledb.kotlin

import com.pulumi.aws.simpledb.DomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a SimpleDB domain resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const users = new aws.simpledb.Domain("users", {name: "users"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * users = aws.simpledb.Domain("users", name="users")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var users = new Aws.SimpleDB.Domain("users", new()
 *     {
 *         Name = "users",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/simpledb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := simpledb.NewDomain(ctx, "users", &simpledb.DomainArgs{
 * 			Name: pulumi.String("users"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.simpledb.Domain;
 * import com.pulumi.aws.simpledb.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var users = new Domain("users", DomainArgs.builder()
 *             .name("users")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   users:
 *     type: aws:simpledb:Domain
 *     properties:
 *       name: users
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SimpleDB Domains using the `name`. For example:
 * ```sh
 * $ pulumi import aws:simpledb/domain:Domain users users
 * ```
 * @property name The name of the SimpleDB domain
 */
public data class DomainArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.simpledb.DomainArgs> {
    override fun toJava(): com.pulumi.aws.simpledb.DomainArgs =
        com.pulumi.aws.simpledb.DomainArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the SimpleDB domain
     */
    @JvmName("viegleifonteshuw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the SimpleDB domain
     */
    @JvmName("orergykaelhccnhv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        name = name,
    )
}
