@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PlatformApplication].
 */
@PulumiTagMarker
public class PlatformApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlatformApplicationArgs = PlatformApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlatformApplicationArgsBuilder.() -> Unit) {
        val builder = PlatformApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PlatformApplication {
        val builtJavaResource = com.pulumi.aws.sns.PlatformApplication(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PlatformApplication(builtJavaResource)
    }
}

/**
 * Provides an SNS platform application resource
 * ## Example Usage
 * ### Apple Push Notification Service (APNS) using certificate-based authentication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const apnsApplication = new aws.sns.PlatformApplication("apns_application", {
 *     name: "apns_application",
 *     platform: "APNS",
 *     platformCredential: "<APNS PRIVATE KEY>",
 *     platformPrincipal: "<APNS CERTIFICATE>",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * apns_application = aws.sns.PlatformApplication("apns_application",
 *     name="apns_application",
 *     platform="APNS",
 *     platform_credential="<APNS PRIVATE KEY>",
 *     platform_principal="<APNS CERTIFICATE>")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apnsApplication = new Aws.Sns.PlatformApplication("apns_application", new()
 *     {
 *         Name = "apns_application",
 *         Platform = "APNS",
 *         PlatformCredential = "<APNS PRIVATE KEY>",
 *         PlatformPrincipal = "<APNS CERTIFICATE>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewPlatformApplication(ctx, "apns_application", &sns.PlatformApplicationArgs{
 * 			Name:               pulumi.String("apns_application"),
 * 			Platform:           pulumi.String("APNS"),
 * 			PlatformCredential: pulumi.String("<APNS PRIVATE KEY>"),
 * 			PlatformPrincipal:  pulumi.String("<APNS CERTIFICATE>"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.PlatformApplication;
 * import com.pulumi.aws.sns.PlatformApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apnsApplication = new PlatformApplication("apnsApplication", PlatformApplicationArgs.builder()
 *             .name("apns_application")
 *             .platform("APNS")
 *             .platformCredential("<APNS PRIVATE KEY>")
 *             .platformPrincipal("<APNS CERTIFICATE>")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   apnsApplication:
 *     type: aws:sns:PlatformApplication
 *     name: apns_application
 *     properties:
 *       name: apns_application
 *       platform: APNS
 *       platformCredential: <APNS PRIVATE KEY>
 *       platformPrincipal: <APNS CERTIFICATE>
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Apple Push Notification Service (APNS) using token-based authentication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const apnsApplication = new aws.sns.PlatformApplication("apns_application", {
 *     name: "apns_application",
 *     platform: "APNS",
 *     platformCredential: "<APNS SIGNING KEY>",
 *     platformPrincipal: "<APNS SIGNING KEY ID>",
 *     applePlatformTeamId: "<APPLE TEAM ID>",
 *     applePlatformBundleId: "<APPLE BUNDLE ID>",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * apns_application = aws.sns.PlatformApplication("apns_application",
 *     name="apns_application",
 *     platform="APNS",
 *     platform_credential="<APNS SIGNING KEY>",
 *     platform_principal="<APNS SIGNING KEY ID>",
 *     apple_platform_team_id="<APPLE TEAM ID>",
 *     apple_platform_bundle_id="<APPLE BUNDLE ID>")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apnsApplication = new Aws.Sns.PlatformApplication("apns_application", new()
 *     {
 *         Name = "apns_application",
 *         Platform = "APNS",
 *         PlatformCredential = "<APNS SIGNING KEY>",
 *         PlatformPrincipal = "<APNS SIGNING KEY ID>",
 *         ApplePlatformTeamId = "<APPLE TEAM ID>",
 *         ApplePlatformBundleId = "<APPLE BUNDLE ID>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewPlatformApplication(ctx, "apns_application", &sns.PlatformApplicationArgs{
 * 			Name:                  pulumi.String("apns_application"),
 * 			Platform:              pulumi.String("APNS"),
 * 			PlatformCredential:    pulumi.String("<APNS SIGNING KEY>"),
 * 			PlatformPrincipal:     pulumi.String("<APNS SIGNING KEY ID>"),
 * 			ApplePlatformTeamId:   pulumi.String("<APPLE TEAM ID>"),
 * 			ApplePlatformBundleId: pulumi.String("<APPLE BUNDLE ID>"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.PlatformApplication;
 * import com.pulumi.aws.sns.PlatformApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apnsApplication = new PlatformApplication("apnsApplication", PlatformApplicationArgs.builder()
 *             .name("apns_application")
 *             .platform("APNS")
 *             .platformCredential("<APNS SIGNING KEY>")
 *             .platformPrincipal("<APNS SIGNING KEY ID>")
 *             .applePlatformTeamId("<APPLE TEAM ID>")
 *             .applePlatformBundleId("<APPLE BUNDLE ID>")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   apnsApplication:
 *     type: aws:sns:PlatformApplication
 *     name: apns_application
 *     properties:
 *       name: apns_application
 *       platform: APNS
 *       platformCredential: <APNS SIGNING KEY>
 *       platformPrincipal: <APNS SIGNING KEY ID>
 *       applePlatformTeamId: <APPLE TEAM ID>
 *       applePlatformBundleId: <APPLE BUNDLE ID>
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Google Cloud Messaging (GCM)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const gcmApplication = new aws.sns.PlatformApplication("gcm_application", {
 *     name: "gcm_application",
 *     platform: "GCM",
 *     platformCredential: "<GCM API KEY>",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * gcm_application = aws.sns.PlatformApplication("gcm_application",
 *     name="gcm_application",
 *     platform="GCM",
 *     platform_credential="<GCM API KEY>")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gcmApplication = new Aws.Sns.PlatformApplication("gcm_application", new()
 *     {
 *         Name = "gcm_application",
 *         Platform = "GCM",
 *         PlatformCredential = "<GCM API KEY>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewPlatformApplication(ctx, "gcm_application", &sns.PlatformApplicationArgs{
 * 			Name:               pulumi.String("gcm_application"),
 * 			Platform:           pulumi.String("GCM"),
 * 			PlatformCredential: pulumi.String("<GCM API KEY>"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.PlatformApplication;
 * import com.pulumi.aws.sns.PlatformApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gcmApplication = new PlatformApplication("gcmApplication", PlatformApplicationArgs.builder()
 *             .name("gcm_application")
 *             .platform("GCM")
 *             .platformCredential("<GCM API KEY>")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   gcmApplication:
 *     type: aws:sns:PlatformApplication
 *     name: gcm_application
 *     properties:
 *       name: gcm_application
 *       platform: GCM
 *       platformCredential: <GCM API KEY>
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SNS platform applications using the ARN. For example:
 * ```sh
 * $ pulumi import aws:sns/platformApplication:PlatformApplication gcm_application arn:aws:sns:us-west-2:0123456789012:app/GCM/gcm_application
 * ```
 */
public class PlatformApplication internal constructor(
    override val javaResource: com.pulumi.aws.sns.PlatformApplication,
) : KotlinCustomResource(javaResource, PlatformApplicationMapper) {
    /**
     * The bundle identifier that's assigned to your iOS app. May only include alphanumeric characters, hyphens (-), and periods (.).
     */
    public val applePlatformBundleId: Output<String>?
        get() = javaResource.applePlatformBundleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier that's assigned to your Apple developer account team. Must be 10 alphanumeric characters.
     */
    public val applePlatformTeamId: Output<String>?
        get() = javaResource.applePlatformTeamId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the SNS platform application
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the SNS Topic triggered when a delivery to any of the platform endpoints associated with your platform application encounters a permanent failure.
     */
    public val eventDeliveryFailureTopicArn: Output<String>?
        get() = javaResource.eventDeliveryFailureTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the SNS Topic triggered when a new platform endpoint is added to your platform application.
     */
    public val eventEndpointCreatedTopicArn: Output<String>?
        get() = javaResource.eventEndpointCreatedTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the SNS Topic triggered when an existing platform endpoint is deleted from your platform application.
     */
    public val eventEndpointDeletedTopicArn: Output<String>?
        get() = javaResource.eventEndpointDeletedTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the SNS Topic triggered when an existing platform endpoint is changed from your platform application.
     */
    public val eventEndpointUpdatedTopicArn: Output<String>?
        get() = javaResource.eventEndpointUpdatedTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IAM role ARN permitted to receive failure feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     */
    public val failureFeedbackRoleArn: Output<String>?
        get() = javaResource.failureFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The friendly name for the SNS platform application
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The platform that the app is registered with. See [Platform](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for supported platforms.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Application Platform credential. See [Credential](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-register.html) for type of credential required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     */
    public val platformCredential: Output<String>
        get() = javaResource.platformCredential().applyValue({ args0 -> args0 })

    /**
     * Application Platform principal. See [Principal](http://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html) for type of principal required for platform. The value of this attribute when stored into the state is only a hash of the real value, so therefore it is not practical to use this as an attribute for other resources.
     */
    public val platformPrincipal: Output<String>?
        get() = javaResource.platformPrincipal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IAM role ARN permitted to receive success feedback for this application and give SNS write access to use CloudWatch logs on your behalf.
     */
    public val successFeedbackRoleArn: Output<String>?
        get() = javaResource.successFeedbackRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The sample rate percentage (0-100) of successfully delivered messages.
     * The following attributes are needed only when using APNS token credentials:
     */
    public val successFeedbackSampleRate: Output<String>?
        get() = javaResource.successFeedbackSampleRate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object PlatformApplicationMapper : ResourceMapper<PlatformApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sns.PlatformApplication::class == javaResource::class

    override fun map(javaResource: Resource): PlatformApplication = PlatformApplication(
        javaResource
            as com.pulumi.aws.sns.PlatformApplication,
    )
}

/**
 * @see [PlatformApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PlatformApplication].
 */
public suspend fun platformApplication(
    name: String,
    block: suspend PlatformApplicationResourceBuilder.() -> Unit,
): PlatformApplication {
    val builder = PlatformApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PlatformApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun platformApplication(name: String): PlatformApplication {
    val builder = PlatformApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
