@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SmsPreferences].
 */
@PulumiTagMarker
public class SmsPreferencesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SmsPreferencesArgs = SmsPreferencesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SmsPreferencesArgsBuilder.() -> Unit) {
        val builder = SmsPreferencesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SmsPreferences {
        val builtJavaResource = com.pulumi.aws.sns.SmsPreferences(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SmsPreferences(builtJavaResource)
    }
}

/**
 * Provides a way to set SNS SMS preferences.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const updateSmsPrefs = new aws.sns.SmsPreferences("update_sms_prefs", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * update_sms_prefs = aws.sns.SmsPreferences("update_sms_prefs")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var updateSmsPrefs = new Aws.Sns.SmsPreferences("update_sms_prefs");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewSmsPreferences(ctx, "update_sms_prefs", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.SmsPreferences;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateSmsPrefs = new SmsPreferences("updateSmsPrefs");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   updateSmsPrefs:
 *     type: aws:sns:SmsPreferences
 *     name: update_sms_prefs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import the SMS preferences.
 */
public class SmsPreferences internal constructor(
    override val javaResource: com.pulumi.aws.sns.SmsPreferences,
) : KotlinCustomResource(javaResource, SmsPreferencesMapper) {
    /**
     * A string, such as your business brand, that is displayed as the sender on the receiving device.
     */
    public val defaultSenderId: Output<String>?
        get() = javaResource.defaultSenderId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of SMS message that you will send by default. Possible values are: Promotional, Transactional
     */
    public val defaultSmsType: Output<String>?
        get() = javaResource.defaultSmsType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IAM role that allows Amazon SNS to write logs about SMS deliveries in CloudWatch Logs.
     */
    public val deliveryStatusIamRoleArn: Output<String>?
        get() = javaResource.deliveryStatusIamRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The percentage of successful SMS deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value must be between 0 and 100.
     */
    public val deliveryStatusSuccessSamplingRate: Output<String>?
        get() = javaResource.deliveryStatusSuccessSamplingRate().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The maximum amount in USD that you are willing to spend each month to send SMS messages.
     */
    public val monthlySpendLimit: Output<Int>
        get() = javaResource.monthlySpendLimit().applyValue({ args0 -> args0 })

    /**
     * The name of the Amazon S3 bucket to receive daily SMS usage reports from Amazon SNS.
     */
    public val usageReportS3Bucket: Output<String>?
        get() = javaResource.usageReportS3Bucket().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SmsPreferencesMapper : ResourceMapper<SmsPreferences> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sns.SmsPreferences::class == javaResource::class

    override fun map(javaResource: Resource): SmsPreferences = SmsPreferences(
        javaResource as
            com.pulumi.aws.sns.SmsPreferences,
    )
}

/**
 * @see [SmsPreferences].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SmsPreferences].
 */
public suspend fun smsPreferences(
    name: String,
    block: suspend SmsPreferencesResourceBuilder.() -> Unit,
): SmsPreferences {
    val builder = SmsPreferencesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SmsPreferences].
 * @param name The _unique_ name of the resulting resource.
 */
public fun smsPreferences(name: String): SmsPreferences {
    val builder = SmsPreferencesResourceBuilder()
    builder.name(name)
    return builder.build()
}
