@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.TopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an SNS topic resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const userUpdates = new aws.sns.Topic("user_updates", {name: "user-updates-topic"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user_updates = aws.sns.Topic("user_updates", name="user-updates-topic")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userUpdates = new Aws.Sns.Topic("user_updates", new()
 *     {
 *         Name = "user-updates-topic",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewTopic(ctx, "user_updates", &sns.TopicArgs{
 * 			Name: pulumi.String("user-updates-topic"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates", TopicArgs.builder()
 *             .name("user-updates-topic")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userUpdates:
 *     type: aws:sns:Topic
 *     name: user_updates
 *     properties:
 *       name: user-updates-topic
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Example with Delivery Policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const userUpdates = new aws.sns.Topic("user_updates", {
 *     name: "user-updates-topic",
 *     deliveryPolicy: `{
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user_updates = aws.sns.Topic("user_updates",
 *     name="user-updates-topic",
 *     delivery_policy="""{
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userUpdates = new Aws.Sns.Topic("user_updates", new()
 *     {
 *         Name = "user-updates-topic",
 *         DeliveryPolicy = @"{
 *   ""http"": {
 *     ""defaultHealthyRetryPolicy"": {
 *       ""minDelayTarget"": 20,
 *       ""maxDelayTarget"": 20,
 *       ""numRetries"": 3,
 *       ""numMaxDelayRetries"": 0,
 *       ""numNoDelayRetries"": 0,
 *       ""numMinDelayRetries"": 0,
 *       ""backoffFunction"": ""linear""
 *     },
 *     ""disableSubscriptionOverrides"": false,
 *     ""defaultThrottlePolicy"": {
 *       ""maxReceivesPerSecond"": 1
 *     }
 *   }
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewTopic(ctx, "user_updates", &sns.TopicArgs{
 * 			Name: pulumi.String("user-updates-topic"),
 * 			DeliveryPolicy: pulumi.String(`{
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates", TopicArgs.builder()
 *             .name("user-updates-topic")
 *             .deliveryPolicy("""
 * {
 *   "http": {
 *     "defaultHealthyRetryPolicy": {
 *       "minDelayTarget": 20,
 *       "maxDelayTarget": 20,
 *       "numRetries": 3,
 *       "numMaxDelayRetries": 0,
 *       "numNoDelayRetries": 0,
 *       "numMinDelayRetries": 0,
 *       "backoffFunction": "linear"
 *     },
 *     "disableSubscriptionOverrides": false,
 *     "defaultThrottlePolicy": {
 *       "maxReceivesPerSecond": 1
 *     }
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userUpdates:
 *     type: aws:sns:Topic
 *     name: user_updates
 *     properties:
 *       name: user-updates-topic
 *       deliveryPolicy: |
 *         {
 *           "http": {
 *             "defaultHealthyRetryPolicy": {
 *               "minDelayTarget": 20,
 *               "maxDelayTarget": 20,
 *               "numRetries": 3,
 *               "numMaxDelayRetries": 0,
 *               "numNoDelayRetries": 0,
 *               "numMinDelayRetries": 0,
 *               "backoffFunction": "linear"
 *             },
 *             "disableSubscriptionOverrides": false,
 *             "defaultThrottlePolicy": {
 *               "maxReceivesPerSecond": 1
 *             }
 *           }
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Example with Server-side encryption (SSE)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const userUpdates = new aws.sns.Topic("user_updates", {
 *     name: "user-updates-topic",
 *     kmsMasterKeyId: "alias/aws/sns",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user_updates = aws.sns.Topic("user_updates",
 *     name="user-updates-topic",
 *     kms_master_key_id="alias/aws/sns")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userUpdates = new Aws.Sns.Topic("user_updates", new()
 *     {
 *         Name = "user-updates-topic",
 *         KmsMasterKeyId = "alias/aws/sns",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewTopic(ctx, "user_updates", &sns.TopicArgs{
 * 			Name:           pulumi.String("user-updates-topic"),
 * 			KmsMasterKeyId: pulumi.String("alias/aws/sns"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates", TopicArgs.builder()
 *             .name("user-updates-topic")
 *             .kmsMasterKeyId("alias/aws/sns")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userUpdates:
 *     type: aws:sns:Topic
 *     name: user_updates
 *     properties:
 *       name: user-updates-topic
 *       kmsMasterKeyId: alias/aws/sns
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Example with First-In-First-Out (FIFO)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const userUpdates = new aws.sns.Topic("user_updates", {
 *     name: "user-updates-topic.fifo",
 *     fifoTopic: true,
 *     contentBasedDeduplication: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user_updates = aws.sns.Topic("user_updates",
 *     name="user-updates-topic.fifo",
 *     fifo_topic=True,
 *     content_based_deduplication=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userUpdates = new Aws.Sns.Topic("user_updates", new()
 *     {
 *         Name = "user-updates-topic.fifo",
 *         FifoTopic = true,
 *         ContentBasedDeduplication = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sns.NewTopic(ctx, "user_updates", &sns.TopicArgs{
 * 			Name:                      pulumi.String("user-updates-topic.fifo"),
 * 			FifoTopic:                 pulumi.Bool(true),
 * 			ContentBasedDeduplication: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdates = new Topic("userUpdates", TopicArgs.builder()
 *             .name("user-updates-topic.fifo")
 *             .fifoTopic(true)
 *             .contentBasedDeduplication(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   userUpdates:
 *     type: aws:sns:Topic
 *     name: user_updates
 *     properties:
 *       name: user-updates-topic.fifo
 *       fifoTopic: true
 *       contentBasedDeduplication: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Message Delivery Status Arguments
 * The `<endpoint>_success_feedback_role_arn` and `<endpoint>_failure_feedback_role_arn` arguments are used to give Amazon SNS write access to use CloudWatch Logs on your behalf. The `<endpoint>_success_feedback_sample_rate` argument is for specifying the sample rate percentage (0-100) of successfully delivered messages. After you configure the  `<endpoint>_failure_feedback_role_arn` argument, then all failed message deliveries generate CloudWatch Logs.
 * ## Import
 * Using `pulumi import`, import SNS Topics using the topic `arn`. For example:
 * ```sh
 * $ pulumi import aws:sns/topic:Topic user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
 * ```
 * @property applicationFailureFeedbackRoleArn IAM role for failure feedback
 * @property applicationSuccessFeedbackRoleArn The IAM role permitted to receive success feedback for this topic
 * @property applicationSuccessFeedbackSampleRate Percentage of success to sample
 * @property archivePolicy The message archive policy for FIFO topics. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-topic-owner.html).
 * @property contentBasedDeduplication Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
 * @property deliveryPolicy The SNS delivery policy. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html).
 * @property displayName The display name for the topic
 * @property fifoTopic Boolean indicating whether or not to create a FIFO (first-in-first-out) topic. FIFO topics can't deliver messages to customer managed endpoints, such as email addresses, mobile apps, SMS, or HTTP(S) endpoints. These endpoint types aren't guaranteed to preserve strict message ordering. Default is `false`.
 * @property firehoseFailureFeedbackRoleArn IAM role for failure feedback
 * @property firehoseSuccessFeedbackRoleArn The IAM role permitted to receive success feedback for this topic
 * @property firehoseSuccessFeedbackSampleRate Percentage of success to sample
 * @property httpFailureFeedbackRoleArn IAM role for failure feedback
 * @property httpSuccessFeedbackRoleArn The IAM role permitted to receive success feedback for this topic
 * @property httpSuccessFeedbackSampleRate Percentage of success to sample
 * @property kmsMasterKeyId The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
 * @property lambdaFailureFeedbackRoleArn IAM role for failure feedback
 * @property lambdaSuccessFeedbackRoleArn The IAM role permitted to receive success feedback for this topic
 * @property lambdaSuccessFeedbackSampleRate Percentage of success to sample
 * @property name The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`
 * @property policy The fully-formed AWS policy as JSON.
 * @property signatureVersion If `SignatureVersion` should be [1 (SHA1) or 2 (SHA256)](https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html). The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
 * @property sqsFailureFeedbackRoleArn IAM role for failure feedback
 * @property sqsSuccessFeedbackRoleArn The IAM role permitted to receive success feedback for this topic
 * @property sqsSuccessFeedbackSampleRate Percentage of success to sample
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tracingConfig Tracing mode of an Amazon SNS topic. Valid values: `"PassThrough"`, `"Active"`.
 */
public data class TopicArgs(
    public val applicationFailureFeedbackRoleArn: Output<String>? = null,
    public val applicationSuccessFeedbackRoleArn: Output<String>? = null,
    public val applicationSuccessFeedbackSampleRate: Output<Int>? = null,
    public val archivePolicy: Output<String>? = null,
    public val contentBasedDeduplication: Output<Boolean>? = null,
    public val deliveryPolicy: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val fifoTopic: Output<Boolean>? = null,
    public val firehoseFailureFeedbackRoleArn: Output<String>? = null,
    public val firehoseSuccessFeedbackRoleArn: Output<String>? = null,
    public val firehoseSuccessFeedbackSampleRate: Output<Int>? = null,
    public val httpFailureFeedbackRoleArn: Output<String>? = null,
    public val httpSuccessFeedbackRoleArn: Output<String>? = null,
    public val httpSuccessFeedbackSampleRate: Output<Int>? = null,
    public val kmsMasterKeyId: Output<String>? = null,
    public val lambdaFailureFeedbackRoleArn: Output<String>? = null,
    public val lambdaSuccessFeedbackRoleArn: Output<String>? = null,
    public val lambdaSuccessFeedbackSampleRate: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val signatureVersion: Output<Int>? = null,
    public val sqsFailureFeedbackRoleArn: Output<String>? = null,
    public val sqsSuccessFeedbackRoleArn: Output<String>? = null,
    public val sqsSuccessFeedbackSampleRate: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tracingConfig: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sns.TopicArgs> {
    override fun toJava(): com.pulumi.aws.sns.TopicArgs = com.pulumi.aws.sns.TopicArgs.builder()
        .applicationFailureFeedbackRoleArn(
            applicationFailureFeedbackRoleArn?.applyValue({ args0 ->
                args0
            }),
        )
        .applicationSuccessFeedbackRoleArn(
            applicationSuccessFeedbackRoleArn?.applyValue({ args0 ->
                args0
            }),
        )
        .applicationSuccessFeedbackSampleRate(
            applicationSuccessFeedbackSampleRate?.applyValue({ args0 ->
                args0
            }),
        )
        .archivePolicy(archivePolicy?.applyValue({ args0 -> args0 }))
        .contentBasedDeduplication(contentBasedDeduplication?.applyValue({ args0 -> args0 }))
        .deliveryPolicy(deliveryPolicy?.applyValue({ args0 -> args0 }))
        .displayName(displayName?.applyValue({ args0 -> args0 }))
        .fifoTopic(fifoTopic?.applyValue({ args0 -> args0 }))
        .firehoseFailureFeedbackRoleArn(firehoseFailureFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .firehoseSuccessFeedbackRoleArn(firehoseSuccessFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .firehoseSuccessFeedbackSampleRate(
            firehoseSuccessFeedbackSampleRate?.applyValue({ args0 ->
                args0
            }),
        )
        .httpFailureFeedbackRoleArn(httpFailureFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .httpSuccessFeedbackRoleArn(httpSuccessFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .httpSuccessFeedbackSampleRate(httpSuccessFeedbackSampleRate?.applyValue({ args0 -> args0 }))
        .kmsMasterKeyId(kmsMasterKeyId?.applyValue({ args0 -> args0 }))
        .lambdaFailureFeedbackRoleArn(lambdaFailureFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .lambdaSuccessFeedbackRoleArn(lambdaSuccessFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .lambdaSuccessFeedbackSampleRate(lambdaSuccessFeedbackSampleRate?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
        .policy(policy?.applyValue({ args0 -> args0 }))
        .signatureVersion(signatureVersion?.applyValue({ args0 -> args0 }))
        .sqsFailureFeedbackRoleArn(sqsFailureFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .sqsSuccessFeedbackRoleArn(sqsSuccessFeedbackRoleArn?.applyValue({ args0 -> args0 }))
        .sqsSuccessFeedbackSampleRate(sqsSuccessFeedbackSampleRate?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .tracingConfig(tracingConfig?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var applicationFailureFeedbackRoleArn: Output<String>? = null

    private var applicationSuccessFeedbackRoleArn: Output<String>? = null

    private var applicationSuccessFeedbackSampleRate: Output<Int>? = null

    private var archivePolicy: Output<String>? = null

    private var contentBasedDeduplication: Output<Boolean>? = null

    private var deliveryPolicy: Output<String>? = null

    private var displayName: Output<String>? = null

    private var fifoTopic: Output<Boolean>? = null

    private var firehoseFailureFeedbackRoleArn: Output<String>? = null

    private var firehoseSuccessFeedbackRoleArn: Output<String>? = null

    private var firehoseSuccessFeedbackSampleRate: Output<Int>? = null

    private var httpFailureFeedbackRoleArn: Output<String>? = null

    private var httpSuccessFeedbackRoleArn: Output<String>? = null

    private var httpSuccessFeedbackSampleRate: Output<Int>? = null

    private var kmsMasterKeyId: Output<String>? = null

    private var lambdaFailureFeedbackRoleArn: Output<String>? = null

    private var lambdaSuccessFeedbackRoleArn: Output<String>? = null

    private var lambdaSuccessFeedbackSampleRate: Output<Int>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var policy: Output<String>? = null

    private var signatureVersion: Output<Int>? = null

    private var sqsFailureFeedbackRoleArn: Output<String>? = null

    private var sqsSuccessFeedbackRoleArn: Output<String>? = null

    private var sqsSuccessFeedbackSampleRate: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tracingConfig: Output<String>? = null

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("wqafspahfdaticxj")
    public suspend fun applicationFailureFeedbackRoleArn(`value`: Output<String>) {
        this.applicationFailureFeedbackRoleArn = value
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("bqtmpslvvsnfqktv")
    public suspend fun applicationSuccessFeedbackRoleArn(`value`: Output<String>) {
        this.applicationSuccessFeedbackRoleArn = value
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("njuyeuimvxoursjd")
    public suspend fun applicationSuccessFeedbackSampleRate(`value`: Output<Int>) {
        this.applicationSuccessFeedbackSampleRate = value
    }

    /**
     * @param value The message archive policy for FIFO topics. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-topic-owner.html).
     */
    @JvmName("lkusovspmgikkaji")
    public suspend fun archivePolicy(`value`: Output<String>) {
        this.archivePolicy = value
    }

    /**
     * @param value Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
     */
    @JvmName("cwfomcypsaaxygod")
    public suspend fun contentBasedDeduplication(`value`: Output<Boolean>) {
        this.contentBasedDeduplication = value
    }

    /**
     * @param value The SNS delivery policy. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html).
     */
    @JvmName("anngjlnfrgxwwlai")
    public suspend fun deliveryPolicy(`value`: Output<String>) {
        this.deliveryPolicy = value
    }

    /**
     * @param value The display name for the topic
     */
    @JvmName("sucrillwjlwodudv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Boolean indicating whether or not to create a FIFO (first-in-first-out) topic. FIFO topics can't deliver messages to customer managed endpoints, such as email addresses, mobile apps, SMS, or HTTP(S) endpoints. These endpoint types aren't guaranteed to preserve strict message ordering. Default is `false`.
     */
    @JvmName("ypuduxlddksnaafi")
    public suspend fun fifoTopic(`value`: Output<Boolean>) {
        this.fifoTopic = value
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("eaydgnsridccglgc")
    public suspend fun firehoseFailureFeedbackRoleArn(`value`: Output<String>) {
        this.firehoseFailureFeedbackRoleArn = value
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("kwcoxigrdkckbsjg")
    public suspend fun firehoseSuccessFeedbackRoleArn(`value`: Output<String>) {
        this.firehoseSuccessFeedbackRoleArn = value
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("bjsuujmsmxcxunet")
    public suspend fun firehoseSuccessFeedbackSampleRate(`value`: Output<Int>) {
        this.firehoseSuccessFeedbackSampleRate = value
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("dfhwrkodfjyqnimc")
    public suspend fun httpFailureFeedbackRoleArn(`value`: Output<String>) {
        this.httpFailureFeedbackRoleArn = value
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("vjifhftvbqhcspxx")
    public suspend fun httpSuccessFeedbackRoleArn(`value`: Output<String>) {
        this.httpSuccessFeedbackRoleArn = value
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("mjndlwwtrxxigkjc")
    public suspend fun httpSuccessFeedbackSampleRate(`value`: Output<Int>) {
        this.httpSuccessFeedbackSampleRate = value
    }

    /**
     * @param value The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
     */
    @JvmName("yproffuuidiymxcl")
    public suspend fun kmsMasterKeyId(`value`: Output<String>) {
        this.kmsMasterKeyId = value
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("odkiysfrmdjwuypx")
    public suspend fun lambdaFailureFeedbackRoleArn(`value`: Output<String>) {
        this.lambdaFailureFeedbackRoleArn = value
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("vutqeavcwdcmcbtc")
    public suspend fun lambdaSuccessFeedbackRoleArn(`value`: Output<String>) {
        this.lambdaSuccessFeedbackRoleArn = value
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("xctocgryyunnwuvh")
    public suspend fun lambdaSuccessFeedbackSampleRate(`value`: Output<Int>) {
        this.lambdaSuccessFeedbackSampleRate = value
    }

    /**
     * @param value The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`
     */
    @JvmName("hwyapdbkrdxtryuy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`
     */
    @JvmName("eatskplcsgdxbclu")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The fully-formed AWS policy as JSON.
     */
    @JvmName("juiayxyfxnbcfaeb")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value If `SignatureVersion` should be [1 (SHA1) or 2 (SHA256)](https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html). The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
     */
    @JvmName("tdxuvimveoednpcu")
    public suspend fun signatureVersion(`value`: Output<Int>) {
        this.signatureVersion = value
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("ccgspaqflxeyvggh")
    public suspend fun sqsFailureFeedbackRoleArn(`value`: Output<String>) {
        this.sqsFailureFeedbackRoleArn = value
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("tfaafqjaioonsicr")
    public suspend fun sqsSuccessFeedbackRoleArn(`value`: Output<String>) {
        this.sqsSuccessFeedbackRoleArn = value
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("eubmwamibbmypjda")
    public suspend fun sqsSuccessFeedbackSampleRate(`value`: Output<Int>) {
        this.sqsSuccessFeedbackSampleRate = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dreigqkokbfdasjy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Tracing mode of an Amazon SNS topic. Valid values: `"PassThrough"`, `"Active"`.
     */
    @JvmName("hrcsitbtdtmbesel")
    public suspend fun tracingConfig(`value`: Output<String>) {
        this.tracingConfig = value
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("xmouxvcfgpnwxswo")
    public suspend fun applicationFailureFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationFailureFeedbackRoleArn = mapped
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("vtjhhcafukndapws")
    public suspend fun applicationSuccessFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSuccessFeedbackRoleArn = mapped
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("ixbrugeiqcagukxn")
    public suspend fun applicationSuccessFeedbackSampleRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSuccessFeedbackSampleRate = mapped
    }

    /**
     * @param value The message archive policy for FIFO topics. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-topic-owner.html).
     */
    @JvmName("mgyyachacguowcao")
    public suspend fun archivePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archivePolicy = mapped
    }

    /**
     * @param value Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
     */
    @JvmName("texacuufhovijyte")
    public suspend fun contentBasedDeduplication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentBasedDeduplication = mapped
    }

    /**
     * @param value The SNS delivery policy. More details in the [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html).
     */
    @JvmName("vvvfijakwhqktsgu")
    public suspend fun deliveryPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryPolicy = mapped
    }

    /**
     * @param value The display name for the topic
     */
    @JvmName("bohxhnswvncatsvf")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Boolean indicating whether or not to create a FIFO (first-in-first-out) topic. FIFO topics can't deliver messages to customer managed endpoints, such as email addresses, mobile apps, SMS, or HTTP(S) endpoints. These endpoint types aren't guaranteed to preserve strict message ordering. Default is `false`.
     */
    @JvmName("gmnhexogrtayiirx")
    public suspend fun fifoTopic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fifoTopic = mapped
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("ifyelamsamdcjovf")
    public suspend fun firehoseFailureFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoseFailureFeedbackRoleArn = mapped
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("cshquvrkwdjqtogo")
    public suspend fun firehoseSuccessFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoseSuccessFeedbackRoleArn = mapped
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("smppmanqipxyvpql")
    public suspend fun firehoseSuccessFeedbackSampleRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoseSuccessFeedbackSampleRate = mapped
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("vimubjrkdljagfts")
    public suspend fun httpFailureFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpFailureFeedbackRoleArn = mapped
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("qbbqvwtslohwulsl")
    public suspend fun httpSuccessFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpSuccessFeedbackRoleArn = mapped
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("cglyriyckboqhfqo")
    public suspend fun httpSuccessFeedbackSampleRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpSuccessFeedbackSampleRate = mapped
    }

    /**
     * @param value The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
     */
    @JvmName("tsthabbestyuheio")
    public suspend fun kmsMasterKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsMasterKeyId = mapped
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("arktodclxucgupkw")
    public suspend fun lambdaFailureFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFailureFeedbackRoleArn = mapped
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("jnqbbcbigpmlqtpe")
    public suspend fun lambdaSuccessFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaSuccessFeedbackRoleArn = mapped
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("qclmqgenvigcpiio")
    public suspend fun lambdaSuccessFeedbackSampleRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaSuccessFeedbackSampleRate = mapped
    }

    /**
     * @param value The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`
     */
    @JvmName("nihfionmdghixvgf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`
     */
    @JvmName("kdgjkqqhvggvpxkp")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The fully-formed AWS policy as JSON.
     */
    @JvmName("wstcvnwthepoobxf")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value If `SignatureVersion` should be [1 (SHA1) or 2 (SHA256)](https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html). The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
     */
    @JvmName("bmahmoehoosaqndw")
    public suspend fun signatureVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signatureVersion = mapped
    }

    /**
     * @param value IAM role for failure feedback
     */
    @JvmName("fmkjuajudibuecti")
    public suspend fun sqsFailureFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsFailureFeedbackRoleArn = mapped
    }

    /**
     * @param value The IAM role permitted to receive success feedback for this topic
     */
    @JvmName("fkyxutqrqrykjwvw")
    public suspend fun sqsSuccessFeedbackRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsSuccessFeedbackRoleArn = mapped
    }

    /**
     * @param value Percentage of success to sample
     */
    @JvmName("ynpyxbbvjdotkyml")
    public suspend fun sqsSuccessFeedbackSampleRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsSuccessFeedbackSampleRate = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uwipjlehsscvkdyx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cjuiagefctskeyaj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Tracing mode of an Amazon SNS topic. Valid values: `"PassThrough"`, `"Active"`.
     */
    @JvmName("rgrioxjdvskbraia")
    public suspend fun tracingConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingConfig = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        applicationFailureFeedbackRoleArn = applicationFailureFeedbackRoleArn,
        applicationSuccessFeedbackRoleArn = applicationSuccessFeedbackRoleArn,
        applicationSuccessFeedbackSampleRate = applicationSuccessFeedbackSampleRate,
        archivePolicy = archivePolicy,
        contentBasedDeduplication = contentBasedDeduplication,
        deliveryPolicy = deliveryPolicy,
        displayName = displayName,
        fifoTopic = fifoTopic,
        firehoseFailureFeedbackRoleArn = firehoseFailureFeedbackRoleArn,
        firehoseSuccessFeedbackRoleArn = firehoseSuccessFeedbackRoleArn,
        firehoseSuccessFeedbackSampleRate = firehoseSuccessFeedbackSampleRate,
        httpFailureFeedbackRoleArn = httpFailureFeedbackRoleArn,
        httpSuccessFeedbackRoleArn = httpSuccessFeedbackRoleArn,
        httpSuccessFeedbackSampleRate = httpSuccessFeedbackSampleRate,
        kmsMasterKeyId = kmsMasterKeyId,
        lambdaFailureFeedbackRoleArn = lambdaFailureFeedbackRoleArn,
        lambdaSuccessFeedbackRoleArn = lambdaSuccessFeedbackRoleArn,
        lambdaSuccessFeedbackSampleRate = lambdaSuccessFeedbackSampleRate,
        name = name,
        namePrefix = namePrefix,
        policy = policy,
        signatureVersion = signatureVersion,
        sqsFailureFeedbackRoleArn = sqsFailureFeedbackRoleArn,
        sqsSuccessFeedbackRoleArn = sqsSuccessFeedbackRoleArn,
        sqsSuccessFeedbackSampleRate = sqsSuccessFeedbackSampleRate,
        tags = tags,
        tracingConfig = tracingConfig,
    )
}
