@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.TopicPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SNS topic policy resource
 * > **NOTE:** If a Principal is specified as just an AWS account ID rather than an ARN, AWS silently converts it to the ARN for the root user, causing future deployments to differ. To avoid this problem, just specify the full ARN, e.g. `arn:aws:iam::123456789012:root`
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.sns.Topic("test", {name: "my-topic-with-policy"});
 * const snsTopicPolicy = test.arn.apply(arn => aws.iam.getPolicyDocumentOutput({
 *     policyId: "__default_policy_ID",
 *     statements: [{
 *         actions: [
 *             "SNS:Subscribe",
 *             "SNS:SetTopicAttributes",
 *             "SNS:RemovePermission",
 *             "SNS:Receive",
 *             "SNS:Publish",
 *             "SNS:ListSubscriptionsByTopic",
 *             "SNS:GetTopicAttributes",
 *             "SNS:DeleteTopic",
 *             "SNS:AddPermission",
 *         ],
 *         conditions: [{
 *             test: "StringEquals",
 *             variable: "AWS:SourceOwner",
 *             values: [account_id],
 *         }],
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["*"],
 *         }],
 *         resources: [arn],
 *         sid: "__default_statement_ID",
 *     }],
 * }));
 * const _default = new aws.sns.TopicPolicy("default", {
 *     arn: test.arn,
 *     policy: snsTopicPolicy.apply(snsTopicPolicy => snsTopicPolicy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.sns.Topic("test", name="my-topic-with-policy")
 * sns_topic_policy = test.arn.apply(lambda arn: aws.iam.get_policy_document_output(policy_id="__default_policy_ID",
 *     statements=[{
 *         "actions": [
 *             "SNS:Subscribe",
 *             "SNS:SetTopicAttributes",
 *             "SNS:RemovePermission",
 *             "SNS:Receive",
 *             "SNS:Publish",
 *             "SNS:ListSubscriptionsByTopic",
 *             "SNS:GetTopicAttributes",
 *             "SNS:DeleteTopic",
 *             "SNS:AddPermission",
 *         ],
 *         "conditions": [{
 *             "test": "StringEquals",
 *             "variable": "AWS:SourceOwner",
 *             "values": [account_id],
 *         }],
 *         "effect": "Allow",
 *         "principals": [{
 *             "type": "AWS",
 *             "identifiers": ["*"],
 *         }],
 *         "resources": [arn],
 *         "sid": "__default_statement_ID",
 *     }]))
 * default = aws.sns.TopicPolicy("default",
 *     arn=test.arn,
 *     policy=sns_topic_policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Sns.Topic("test", new()
 *     {
 *         Name = "my-topic-with-policy",
 *     });
 *     var snsTopicPolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         PolicyId = "__default_policy_ID",
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "SNS:Subscribe",
 *                     "SNS:SetTopicAttributes",
 *                     "SNS:RemovePermission",
 *                     "SNS:Receive",
 *                     "SNS:Publish",
 *                     "SNS:ListSubscriptionsByTopic",
 *                     "SNS:GetTopicAttributes",
 *                     "SNS:DeleteTopic",
 *                     "SNS:AddPermission",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "AWS:SourceOwner",
 *                         Values = new[]
 *                         {
 *                             account_id,
 *                         },
 *                     },
 *                 },
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Resources = new[]
 *                 {
 *                     test.Arn,
 *                 },
 *                 Sid = "__default_statement_ID",
 *             },
 *         },
 *     });
 *     var @default = new Aws.Sns.TopicPolicy("default", new()
 *     {
 *         Arn = test.Arn,
 *         Policy = snsTopicPolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * test, err := sns.NewTopic(ctx, "test", &sns.TopicArgs{
 * Name: pulumi.String("my-topic-with-policy"),
 * })
 * if err != nil {
 * return err
 * }
 * snsTopicPolicy := test.Arn.ApplyT(func(arn string) (iam.GetPolicyDocumentResult, error) {
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * PolicyId: "__default_policy_ID",
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "SNS:Subscribe",
 * "SNS:SetTopicAttributes",
 * "SNS:RemovePermission",
 * "SNS:Receive",
 * "SNS:Publish",
 * "SNS:ListSubscriptionsByTopic",
 * "SNS:GetTopicAttributes",
 * "SNS:DeleteTopic",
 * "SNS:AddPermission",
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Variable: "AWS:SourceOwner",
 * Values: interface{}{
 * account_id,
 * },
 * },
 * },
 * Effect: "Allow",
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: []string{
 * "*",
 * },
 * },
 * },
 * Resources: interface{}{
 * arn,
 * },
 * Sid: "__default_statement_ID",
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = sns.NewTopicPolicy(ctx, "default", &sns.TopicPolicyArgs{
 * Arn: test.Arn,
 * Policy: pulumi.String(snsTopicPolicy.ApplyT(func(snsTopicPolicy iam.GetPolicyDocumentResult) (*string, error) {
 * return &snsTopicPolicy.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Topic("test", TopicArgs.builder()
 *             .name("my-topic-with-policy")
 *             .build());
 *         final var snsTopicPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .policyId("__default_policy_ID")
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "SNS:Subscribe",
 *                     "SNS:SetTopicAttributes",
 *                     "SNS:RemovePermission",
 *                     "SNS:Receive",
 *                     "SNS:Publish",
 *                     "SNS:ListSubscriptionsByTopic",
 *                     "SNS:GetTopicAttributes",
 *                     "SNS:DeleteTopic",
 *                     "SNS:AddPermission")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("StringEquals")
 *                     .variable("AWS:SourceOwner")
 *                     .values(account_id)
 *                     .build())
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .resources(test.arn())
 *                 .sid("__default_statement_ID")
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(test.arn())
 *             .policy(snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicy -> snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sns:Topic
 *     properties:
 *       name: my-topic-with-policy
 *   default:
 *     type: aws:sns:TopicPolicy
 *     properties:
 *       arn: ${test.arn}
 *       policy: ${snsTopicPolicy.json}
 * variables:
 *   snsTopicPolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         policyId: __default_policy_ID
 *         statements:
 *           - actions:
 *               - SNS:Subscribe
 *               - SNS:SetTopicAttributes
 *               - SNS:RemovePermission
 *               - SNS:Receive
 *               - SNS:Publish
 *               - SNS:ListSubscriptionsByTopic
 *               - SNS:GetTopicAttributes
 *               - SNS:DeleteTopic
 *               - SNS:AddPermission
 *             conditions:
 *               - test: StringEquals
 *                 variable: AWS:SourceOwner
 *                 values:
 *                   - ${["account-id"]}
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             resources:
 *               - ${test.arn}
 *             sid: __default_statement_ID
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SNS Topic Policy using the topic ARN. For example:
 * ```sh
 * $ pulumi import aws:sns/topicPolicy:TopicPolicy user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
 * ```
 * @property arn The ARN of the SNS topic
 * @property policy The fully-formed AWS policy as JSON.
 */
public data class TopicPolicyArgs(
    public val arn: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sns.TopicPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sns.TopicPolicyArgs =
        com.pulumi.aws.sns.TopicPolicyArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicPolicyArgs].
 */
@PulumiTagMarker
public class TopicPolicyArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("palqciggrqhpmhqq")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The fully-formed AWS policy as JSON.
     */
    @JvmName("dektjmqbdhnegtmx")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ARN of the SNS topic
     */
    @JvmName("kfbotkgirtojocjn")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The fully-formed AWS policy as JSON.
     */
    @JvmName("bxwycfcivywavuht")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): TopicPolicyArgs = TopicPolicyArgs(
        arn = arn,
        policy = policy,
    )
}
