@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getTopic.
 * @property arn ARN of the found topic, suitable for referencing in other resources that support SNS topics.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetTopicResult(
    public val arn: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sns.outputs.GetTopicResult): GetTopicResult =
            GetTopicResult(
                arn = javaType.arn(),
                id = javaType.id(),
                name = javaType.name(),
            )
    }
}
