@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Queue].
 */
@PulumiTagMarker
public class QueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueueArgs = QueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueueArgsBuilder.() -> Unit) {
        val builder = QueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Queue {
        val builtJavaResource = com.pulumi.aws.sqs.Queue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Queue(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const queue = new aws.sqs.Queue("queue", {
 *     name: "example-queue",
 *     delaySeconds: 90,
 *     maxMessageSize: 2048,
 *     messageRetentionSeconds: 86400,
 *     receiveWaitTimeSeconds: 10,
 *     redrivePolicy: JSON.stringify({
 *         deadLetterTargetArn: queueDeadletter.arn,
 *         maxReceiveCount: 4,
 *     }),
 *     tags: {
 *         Environment: "production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * queue = aws.sqs.Queue("queue",
 *     name="example-queue",
 *     delay_seconds=90,
 *     max_message_size=2048,
 *     message_retention_seconds=86400,
 *     receive_wait_time_seconds=10,
 *     redrive_policy=json.dumps({
 *         "deadLetterTargetArn": queue_deadletter["arn"],
 *         "maxReceiveCount": 4,
 *     }),
 *     tags={
 *         "Environment": "production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new Aws.Sqs.Queue("queue", new()
 *     {
 *         Name = "example-queue",
 *         DelaySeconds = 90,
 *         MaxMessageSize = 2048,
 *         MessageRetentionSeconds = 86400,
 *         ReceiveWaitTimeSeconds = 10,
 *         RedrivePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["deadLetterTargetArn"] = queueDeadletter.Arn,
 *             ["maxReceiveCount"] = 4,
 *         }),
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"deadLetterTargetArn": queueDeadletter.Arn,
 * 			"maxReceiveCount":     4,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = sqs.NewQueue(ctx, "queue", &sqs.QueueArgs{
 * 			Name:                    pulumi.String("example-queue"),
 * 			DelaySeconds:            pulumi.Int(90),
 * 			MaxMessageSize:          pulumi.Int(2048),
 * 			MessageRetentionSeconds: pulumi.Int(86400),
 * 			ReceiveWaitTimeSeconds:  pulumi.Int(10),
 * 			RedrivePolicy:           pulumi.String(json0),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("example-queue")
 *             .delaySeconds(90)
 *             .maxMessageSize(2048)
 *             .messageRetentionSeconds(86400)
 *             .receiveWaitTimeSeconds(10)
 *             .redrivePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", queueDeadletter.arn()),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 )))
 *             .tags(Map.of("Environment", "production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: example-queue
 *       delaySeconds: 90
 *       maxMessageSize: 2048
 *       messageRetentionSeconds: 86400
 *       receiveWaitTimeSeconds: 10
 *       redrivePolicy:
 *         fn::toJSON:
 *           deadLetterTargetArn: ${queueDeadletter.arn}
 *           maxReceiveCount: 4
 *       tags:
 *         Environment: production
 * ```
 * <!--End PulumiCodeChooser -->
 * ## FIFO queue
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const queue = new aws.sqs.Queue("queue", {
 *     name: "example-queue.fifo",
 *     fifoQueue: true,
 *     contentBasedDeduplication: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * queue = aws.sqs.Queue("queue",
 *     name="example-queue.fifo",
 *     fifo_queue=True,
 *     content_based_deduplication=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new Aws.Sqs.Queue("queue", new()
 *     {
 *         Name = "example-queue.fifo",
 *         FifoQueue = true,
 *         ContentBasedDeduplication = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqs.NewQueue(ctx, "queue", &sqs.QueueArgs{
 * 			Name:                      pulumi.String("example-queue.fifo"),
 * 			FifoQueue:                 pulumi.Bool(true),
 * 			ContentBasedDeduplication: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("example-queue.fifo")
 *             .fifoQueue(true)
 *             .contentBasedDeduplication(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: example-queue.fifo
 *       fifoQueue: true
 *       contentBasedDeduplication: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## High-throughput FIFO queue
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const queue = new aws.sqs.Queue("queue", {
 *     name: "pulumi-example-queue.fifo",
 *     fifoQueue: true,
 *     deduplicationScope: "messageGroup",
 *     fifoThroughputLimit: "perMessageGroupId",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * queue = aws.sqs.Queue("queue",
 *     name="pulumi-example-queue.fifo",
 *     fifo_queue=True,
 *     deduplication_scope="messageGroup",
 *     fifo_throughput_limit="perMessageGroupId")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new Aws.Sqs.Queue("queue", new()
 *     {
 *         Name = "pulumi-example-queue.fifo",
 *         FifoQueue = true,
 *         DeduplicationScope = "messageGroup",
 *         FifoThroughputLimit = "perMessageGroupId",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqs.NewQueue(ctx, "queue", &sqs.QueueArgs{
 * 			Name:                pulumi.String("pulumi-example-queue.fifo"),
 * 			FifoQueue:           pulumi.Bool(true),
 * 			DeduplicationScope:  pulumi.String("messageGroup"),
 * 			FifoThroughputLimit: pulumi.String("perMessageGroupId"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("pulumi-example-queue.fifo")
 *             .fifoQueue(true)
 *             .deduplicationScope("messageGroup")
 *             .fifoThroughputLimit("perMessageGroupId")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: pulumi-example-queue.fifo
 *       fifoQueue: true
 *       deduplicationScope: messageGroup
 *       fifoThroughputLimit: perMessageGroupId
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Dead-letter queue
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const queue = new aws.sqs.Queue("queue", {
 *     name: "pulumi-example-queue",
 *     redrivePolicy: JSON.stringify({
 *         deadLetterTargetArn: queueDeadletter.arn,
 *         maxReceiveCount: 4,
 *     }),
 * });
 * const exampleQueueDeadletter = new aws.sqs.Queue("example_queue_deadletter", {name: "pulumi-example-deadletter-queue"});
 * const exampleQueueRedriveAllowPolicy = new aws.sqs.RedriveAllowPolicy("example_queue_redrive_allow_policy", {
 *     queueUrl: exampleQueueDeadletter.id,
 *     redriveAllowPolicy: JSON.stringify({
 *         redrivePermission: "byQueue",
 *         sourceQueueArns: [exampleQueue&#46;arn],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * queue = aws.sqs.Queue("queue",
 *     name="pulumi-example-queue",
 *     redrive_policy=json.dumps({
 *         "deadLetterTargetArn": queue_deadletter["arn"],
 *         "maxReceiveCount": 4,
 *     }))
 * example_queue_deadletter = aws.sqs.Queue("example_queue_deadletter", name="pulumi-example-deadletter-queue")
 * example_queue_redrive_allow_policy = aws.sqs.RedriveAllowPolicy("example_queue_redrive_allow_policy",
 *     queue_url=example_queue_deadletter.id,
 *     redrive_allow_policy=json.dumps({
 *         "redrivePermission": "byQueue",
 *         "sourceQueueArns": [example_queue["arn"]],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new Aws.Sqs.Queue("queue", new()
 *     {
 *         Name = "pulumi-example-queue",
 *         RedrivePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["deadLetterTargetArn"] = queueDeadletter.Arn,
 *             ["maxReceiveCount"] = 4,
 *         }),
 *     });
 *     var exampleQueueDeadletter = new Aws.Sqs.Queue("example_queue_deadletter", new()
 *     {
 *         Name = "pulumi-example-deadletter-queue",
 *     });
 *     var exampleQueueRedriveAllowPolicy = new Aws.Sqs.RedriveAllowPolicy("example_queue_redrive_allow_policy", new()
 *     {
 *         QueueUrl = exampleQueueDeadletter.Id,
 *         RedriveAllowPolicyName = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["redrivePermission"] = "byQueue",
 *             ["sourceQueueArns"] = new[]
 *             {
 *                 exampleQueue.Arn,
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"deadLetterTargetArn": queueDeadletter.Arn,
 * 			"maxReceiveCount":     4,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = sqs.NewQueue(ctx, "queue", &sqs.QueueArgs{
 * 			Name:          pulumi.String("pulumi-example-queue"),
 * 			RedrivePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleQueueDeadletter, err := sqs.NewQueue(ctx, "example_queue_deadletter", &sqs.QueueArgs{
 * 			Name: pulumi.String("pulumi-example-deadletter-queue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 			"redrivePermission": "byQueue",
 * 			"sourceQueueArns": []interface{}{
 * 				exampleQueue.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json1 := string(tmpJSON1)
 * 		_, err = sqs.NewRedriveAllowPolicy(ctx, "example_queue_redrive_allow_policy", &sqs.RedriveAllowPolicyArgs{
 * 			QueueUrl:           exampleQueueDeadletter.ID(),
 * 			RedriveAllowPolicy: pulumi.String(json1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedriveAllowPolicy;
 * import com.pulumi.aws.sqs.RedriveAllowPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("pulumi-example-queue")
 *             .redrivePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", queueDeadletter.arn()),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 )))
 *             .build());
 *         var exampleQueueDeadletter = new Queue("exampleQueueDeadletter", QueueArgs.builder()
 *             .name("pulumi-example-deadletter-queue")
 *             .build());
 *         var exampleQueueRedriveAllowPolicy = new RedriveAllowPolicy("exampleQueueRedriveAllowPolicy", RedriveAllowPolicyArgs.builder()
 *             .queueUrl(exampleQueueDeadletter.id())
 *             .redriveAllowPolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("redrivePermission", "byQueue"),
 *                     jsonProperty("sourceQueueArns", jsonArray(exampleQueue.arn()))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: pulumi-example-queue
 *       redrivePolicy:
 *         fn::toJSON:
 *           deadLetterTargetArn: ${queueDeadletter.arn}
 *           maxReceiveCount: 4
 *   exampleQueueDeadletter:
 *     type: aws:sqs:Queue
 *     name: example_queue_deadletter
 *     properties:
 *       name: pulumi-example-deadletter-queue
 *   exampleQueueRedriveAllowPolicy:
 *     type: aws:sqs:RedriveAllowPolicy
 *     name: example_queue_redrive_allow_policy
 *     properties:
 *       queueUrl: ${exampleQueueDeadletter.id}
 *       redriveAllowPolicy:
 *         fn::toJSON:
 *           redrivePermission: byQueue
 *           sourceQueueArns:
 *             - ${exampleQueue.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Server-side encryption (SSE)
 * Using [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html):
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const queue = new aws.sqs.Queue("queue", {
 *     name: "pulumi-example-queue",
 *     sqsManagedSseEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * queue = aws.sqs.Queue("queue",
 *     name="pulumi-example-queue",
 *     sqs_managed_sse_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new Aws.Sqs.Queue("queue", new()
 *     {
 *         Name = "pulumi-example-queue",
 *         SqsManagedSseEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqs.NewQueue(ctx, "queue", &sqs.QueueArgs{
 * 			Name:                 pulumi.String("pulumi-example-queue"),
 * 			SqsManagedSseEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("pulumi-example-queue")
 *             .sqsManagedSseEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: pulumi-example-queue
 *       sqsManagedSseEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * Using [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html):
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const queue = new aws.sqs.Queue("queue", {
 *     name: "example-queue",
 *     kmsMasterKeyId: "alias/aws/sqs",
 *     kmsDataKeyReusePeriodSeconds: 300,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * queue = aws.sqs.Queue("queue",
 *     name="example-queue",
 *     kms_master_key_id="alias/aws/sqs",
 *     kms_data_key_reuse_period_seconds=300)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new Aws.Sqs.Queue("queue", new()
 *     {
 *         Name = "example-queue",
 *         KmsMasterKeyId = "alias/aws/sqs",
 *         KmsDataKeyReusePeriodSeconds = 300,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqs.NewQueue(ctx, "queue", &sqs.QueueArgs{
 * 			Name:                         pulumi.String("example-queue"),
 * 			KmsMasterKeyId:               pulumi.String("alias/aws/sqs"),
 * 			KmsDataKeyReusePeriodSeconds: pulumi.Int(300),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("example-queue")
 *             .kmsMasterKeyId("alias/aws/sqs")
 *             .kmsDataKeyReusePeriodSeconds(300)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: example-queue
 *       kmsMasterKeyId: alias/aws/sqs
 *       kmsDataKeyReusePeriodSeconds: 300
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SQS Queues using the queue `url`. For example:
 * ```sh
 * $ pulumi import aws:sqs/queue:Queue public_queue https://queue.amazonaws.com/80398EXAMPLE/MyQueue
 * ```
 */
public class Queue internal constructor(
    override val javaResource: com.pulumi.aws.sqs.Queue,
) : KotlinCustomResource(javaResource, QueueMapper) {
    /**
     * The ARN of the SQS queue
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Enables content-based deduplication for FIFO queues. For more information, see the [related documentation](http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing)
     */
    public val contentBasedDeduplication: Output<Boolean>?
        get() = javaResource.contentBasedDeduplication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether message deduplication occurs at the message group or queue level. Valid values are `messageGroup` and `queue` (default).
     */
    public val deduplicationScope: Output<String>
        get() = javaResource.deduplicationScope().applyValue({ args0 -> args0 })

    /**
     * The time in seconds that the delivery of all messages in the queue will be delayed. An integer from 0 to 900 (15 minutes). The default for this attribute is 0 seconds.
     */
    public val delaySeconds: Output<Int>?
        get() = javaResource.delaySeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean designating a FIFO queue. If not set, it defaults to `false` making it standard.
     */
    public val fifoQueue: Output<Boolean>?
        get() = javaResource.fifoQueue().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are `perQueue` (default) and `perMessageGroupId`.
     */
    public val fifoThroughputLimit: Output<String>
        get() = javaResource.fifoThroughputLimit().applyValue({ args0 -> args0 })

    /**
     * The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). The default is 300 (5 minutes).
     */
    public val kmsDataKeyReusePeriodSeconds: Output<Int>
        get() = javaResource.kmsDataKeyReusePeriodSeconds().applyValue({ args0 -> args0 })

    /**
     * The ID of an AWS-managed customer master key (CMK) for Amazon SQS or a custom CMK. For more information, see [Key Terms](http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms).
     */
    public val kmsMasterKeyId: Output<String>?
        get() = javaResource.kmsMasterKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The limit of how many bytes a message can contain before Amazon SQS rejects it. An integer from 1024 bytes (1 KiB) up to 262144 bytes (256 KiB). The default for this attribute is 262144 (256 KiB).
     */
    public val maxMessageSize: Output<Int>?
        get() = javaResource.maxMessageSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of seconds Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute) to 1209600 (14 days). The default for this attribute is 345600 (4 days).
     */
    public val messageRetentionSeconds: Output<Int>?
        get() = javaResource.messageRetentionSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the queue. Queue names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 80 characters long. For a FIFO (first-in-first-out) queue, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The JSON policy for the SQS queue.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The time for which a ReceiveMessage call will wait for a message to arrive (long polling) before returning. An integer from 0 to 20 (seconds). The default for this attribute is 0, meaning that the call will return immediately.
     */
    public val receiveWaitTimeSeconds: Output<Int>?
        get() = javaResource.receiveWaitTimeSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The JSON policy to set up the Dead Letter Queue redrive permission, see [AWS docs](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSDeadLetterQueue.html).
     */
    public val redriveAllowPolicy: Output<String>
        get() = javaResource.redriveAllowPolicy().applyValue({ args0 -> args0 })

    /**
     * The JSON policy to set up the Dead Letter Queue, see [AWS docs](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSDeadLetterQueue.html). **Note:** when specifying `maxReceiveCount`, you must specify it as an integer (`5`), and not a string (`"5"`).
     */
    public val redrivePolicy: Output<String>
        get() = javaResource.redrivePolicy().applyValue({ args0 -> args0 })

    /**
     * Boolean to enable server-side encryption (SSE) of message content with SQS-owned encryption keys. See [Encryption at rest](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html). The provider will only perform drift detection of its value when present in a configuration.
     */
    public val sqsManagedSseEnabled: Output<Boolean>
        get() = javaResource.sqsManagedSseEnabled().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the queue. If configured with a provider `default_tags` configuration block) present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Same as `id`: The URL for the created Amazon SQS queue.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * The visibility timeout for the queue. An integer from 0 to 43200 (12 hours). The default for this attribute is 30. For more information about visibility timeout, see [AWS docs](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AboutVT.html).
     */
    public val visibilityTimeoutSeconds: Output<Int>?
        get() = javaResource.visibilityTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object QueueMapper : ResourceMapper<Queue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sqs.Queue::class == javaResource::class

    override fun map(javaResource: Resource): Queue = Queue(javaResource as com.pulumi.aws.sqs.Queue)
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Queue].
 */
public suspend fun queue(name: String, block: suspend QueueResourceBuilder.() -> Unit): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queue(name: String): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
