@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.aws.sqs.RedriveAllowPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a SQS Queue Redrive Allow Policy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sqs.Queue("example", {name: "examplequeue"});
 * const src = new aws.sqs.Queue("src", {
 *     name: "srcqueue",
 *     redrivePolicy: pulumi.jsonStringify({
 *         deadLetterTargetArn: example.arn,
 *         maxReceiveCount: 4,
 *     }),
 * });
 * const exampleRedriveAllowPolicy = new aws.sqs.RedriveAllowPolicy("example", {
 *     queueUrl: example.id,
 *     redriveAllowPolicy: pulumi.jsonStringify({
 *         redrivePermission: "byQueue",
 *         sourceQueueArns: [src&#46;arn],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.sqs.Queue("example", name="examplequeue")
 * src = aws.sqs.Queue("src",
 *     name="srcqueue",
 *     redrive_policy=pulumi.Output.json_dumps({
 *         "deadLetterTargetArn": example.arn,
 *         "maxReceiveCount": 4,
 *     }))
 * example_redrive_allow_policy = aws.sqs.RedriveAllowPolicy("example",
 *     queue_url=example.id,
 *     redrive_allow_policy=pulumi.Output.json_dumps({
 *         "redrivePermission": "byQueue",
 *         "sourceQueueArns": [src&#46;arn],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sqs.Queue("example", new()
 *     {
 *         Name = "examplequeue",
 *     });
 *     var src = new Aws.Sqs.Queue("src", new()
 *     {
 *         Name = "srcqueue",
 *         RedrivePolicy = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["deadLetterTargetArn"] = example.Arn,
 *             ["maxReceiveCount"] = 4,
 *         })),
 *     });
 *     var exampleRedriveAllowPolicy = new Aws.Sqs.RedriveAllowPolicy("example", new()
 *     {
 *         QueueUrl = example.Id,
 *         RedriveAllowPolicyName = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["redrivePermission"] = "byQueue",
 *             ["sourceQueueArns"] = new[]
 *             {
 *                 src.Arn,
 *             },
 *         })),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := sqs.NewQueue(ctx, "example", &sqs.QueueArgs{
 * 			Name: pulumi.String("examplequeue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		src, err := sqs.NewQueue(ctx, "src", &sqs.QueueArgs{
 * 			Name: pulumi.String("srcqueue"),
 * 			RedrivePolicy: example.Arn.ApplyT(func(arn string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 					"deadLetterTargetArn": arn,
 * 					"maxReceiveCount":     4,
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return pulumi.String(json0), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sqs.NewRedriveAllowPolicy(ctx, "example", &sqs.RedriveAllowPolicyArgs{
 * 			QueueUrl: example.ID(),
 * 			RedriveAllowPolicy: src.Arn.ApplyT(func(arn string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 					"redrivePermission": "byQueue",
 * 					"sourceQueueArns": []string{
 * 						arn,
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json1 := string(tmpJSON1)
 * 				return pulumi.String(json1), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedriveAllowPolicy;
 * import com.pulumi.aws.sqs.RedriveAllowPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Queue("example", QueueArgs.builder()
 *             .name("examplequeue")
 *             .build());
 *         var src = new Queue("src", QueueArgs.builder()
 *             .name("srcqueue")
 *             .redrivePolicy(example.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", arn),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 ))))
 *             .build());
 *         var exampleRedriveAllowPolicy = new RedriveAllowPolicy("exampleRedriveAllowPolicy", RedriveAllowPolicyArgs.builder()
 *             .queueUrl(example.id())
 *             .redriveAllowPolicy(src.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("redrivePermission", "byQueue"),
 *                     jsonProperty("sourceQueueArns", jsonArray(arn))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   src:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: srcqueue
 *       redrivePolicy:
 *         fn::toJSON:
 *           deadLetterTargetArn: ${example.arn}
 *           maxReceiveCount: 4
 *   example:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: examplequeue
 *   exampleRedriveAllowPolicy:
 *     type: aws:sqs:RedriveAllowPolicy
 *     name: example
 *     properties:
 *       queueUrl: ${example.id}
 *       redriveAllowPolicy:
 *         fn::toJSON:
 *           redrivePermission: byQueue
 *           sourceQueueArns:
 *             - ${src.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SQS Queue Redrive Allow Policies using the queue URL. For example:
 * ```sh
 * $ pulumi import aws:sqs/redriveAllowPolicy:RedriveAllowPolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 * @property queueUrl The URL of the SQS Queue to which to attach the policy
 * @property redriveAllowPolicy The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
 */
public data class RedriveAllowPolicyArgs(
    public val queueUrl: Output<String>? = null,
    public val redriveAllowPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sqs.RedriveAllowPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sqs.RedriveAllowPolicyArgs =
        com.pulumi.aws.sqs.RedriveAllowPolicyArgs.builder()
            .queueUrl(queueUrl?.applyValue({ args0 -> args0 }))
            .redriveAllowPolicy(redriveAllowPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RedriveAllowPolicyArgs].
 */
@PulumiTagMarker
public class RedriveAllowPolicyArgsBuilder internal constructor() {
    private var queueUrl: Output<String>? = null

    private var redriveAllowPolicy: Output<String>? = null

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("pmekxqlargrbxaki")
    public suspend fun queueUrl(`value`: Output<String>) {
        this.queueUrl = value
    }

    /**
     * @param value The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    @JvmName("rlkpbmtvsohnklfl")
    public suspend fun redriveAllowPolicy(`value`: Output<String>) {
        this.redriveAllowPolicy = value
    }

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("bnmjixiljsxiawbs")
    public suspend fun queueUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueUrl = mapped
    }

    /**
     * @param value The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    @JvmName("aiouvqbgobmbolvd")
    public suspend fun redriveAllowPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redriveAllowPolicy = mapped
    }

    internal fun build(): RedriveAllowPolicyArgs = RedriveAllowPolicyArgs(
        queueUrl = queueUrl,
        redriveAllowPolicy = redriveAllowPolicy,
    )
}
