@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RedrivePolicy].
 */
@PulumiTagMarker
public class RedrivePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RedrivePolicyArgs = RedrivePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RedrivePolicyArgsBuilder.() -> Unit) {
        val builder = RedrivePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RedrivePolicy {
        val builtJavaResource = com.pulumi.aws.sqs.RedrivePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RedrivePolicy(builtJavaResource)
    }
}

/**
 * Allows you to set a redrive policy of an SQS Queue
 * while referencing ARN of the dead letter queue inside the redrive policy.
 * This is useful when you want to set a dedicated
 * dead letter queue for a standard or FIFO queue, but need
 * the dead letter queue to exist before setting the redrive policy.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const q = new aws.sqs.Queue("q", {name: "examplequeue"});
 * const ddl = new aws.sqs.Queue("ddl", {
 *     name: "examplequeue-ddl",
 *     redriveAllowPolicy: pulumi.jsonStringify({
 *         redrivePermission: "byQueue",
 *         sourceQueueArns: [q&#46;arn],
 *     }),
 * });
 * const qRedrivePolicy = new aws.sqs.RedrivePolicy("q", {
 *     queueUrl: q.id,
 *     redrivePolicy: pulumi.jsonStringify({
 *         deadLetterTargetArn: ddl.arn,
 *         maxReceiveCount: 4,
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * q = aws.sqs.Queue("q", name="examplequeue")
 * ddl = aws.sqs.Queue("ddl",
 *     name="examplequeue-ddl",
 *     redrive_allow_policy=pulumi.Output.json_dumps({
 *         "redrivePermission": "byQueue",
 *         "sourceQueueArns": [q&#46;arn],
 *     }))
 * q_redrive_policy = aws.sqs.RedrivePolicy("q",
 *     queue_url=q.id,
 *     redrive_policy=pulumi.Output.json_dumps({
 *         "deadLetterTargetArn": ddl.arn,
 *         "maxReceiveCount": 4,
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var q = new Aws.Sqs.Queue("q", new()
 *     {
 *         Name = "examplequeue",
 *     });
 *     var ddl = new Aws.Sqs.Queue("ddl", new()
 *     {
 *         Name = "examplequeue-ddl",
 *         RedriveAllowPolicy = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["redrivePermission"] = "byQueue",
 *             ["sourceQueueArns"] = new[]
 *             {
 *                 q.Arn,
 *             },
 *         })),
 *     });
 *     var qRedrivePolicy = new Aws.Sqs.RedrivePolicy("q", new()
 *     {
 *         QueueUrl = q.Id,
 *         RedrivePolicyName = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["deadLetterTargetArn"] = ddl.Arn,
 *             ["maxReceiveCount"] = 4,
 *         })),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		q, err := sqs.NewQueue(ctx, "q", &sqs.QueueArgs{
 * 			Name: pulumi.String("examplequeue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ddl, err := sqs.NewQueue(ctx, "ddl", &sqs.QueueArgs{
 * 			Name: pulumi.String("examplequeue-ddl"),
 * 			RedriveAllowPolicy: q.Arn.ApplyT(func(arn string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 					"redrivePermission": "byQueue",
 * 					"sourceQueueArns": []string{
 * 						arn,
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return pulumi.String(json0), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sqs.NewRedrivePolicy(ctx, "q", &sqs.RedrivePolicyArgs{
 * 			QueueUrl: q.ID(),
 * 			RedrivePolicy: ddl.Arn.ApplyT(func(arn string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 					"deadLetterTargetArn": arn,
 * 					"maxReceiveCount":     4,
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json1 := string(tmpJSON1)
 * 				return pulumi.String(json1), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedrivePolicy;
 * import com.pulumi.aws.sqs.RedrivePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var q = new Queue("q", QueueArgs.builder()
 *             .name("examplequeue")
 *             .build());
 *         var ddl = new Queue("ddl", QueueArgs.builder()
 *             .name("examplequeue-ddl")
 *             .redriveAllowPolicy(q.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("redrivePermission", "byQueue"),
 *                     jsonProperty("sourceQueueArns", jsonArray(arn))
 *                 ))))
 *             .build());
 *         var qRedrivePolicy = new RedrivePolicy("qRedrivePolicy", RedrivePolicyArgs.builder()
 *             .queueUrl(q.id())
 *             .redrivePolicy(ddl.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", arn),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   q:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: examplequeue
 *   ddl:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: examplequeue-ddl
 *       redriveAllowPolicy:
 *         fn::toJSON:
 *           redrivePermission: byQueue
 *           sourceQueueArns:
 *             - ${q.arn}
 *   qRedrivePolicy:
 *     type: aws:sqs:RedrivePolicy
 *     name: q
 *     properties:
 *       queueUrl: ${q.id}
 *       redrivePolicy:
 *         fn::toJSON:
 *           deadLetterTargetArn: ${ddl.arn}
 *           maxReceiveCount: 4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SQS Queue Redrive Policies using the queue URL. For example:
 * ```sh
 * $ pulumi import aws:sqs/redrivePolicy:RedrivePolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 */
public class RedrivePolicy internal constructor(
    override val javaResource: com.pulumi.aws.sqs.RedrivePolicy,
) : KotlinCustomResource(javaResource, RedrivePolicyMapper) {
    /**
     * The URL of the SQS Queue to which to attach the policy
     */
    public val queueUrl: Output<String>
        get() = javaResource.queueUrl().applyValue({ args0 -> args0 })

    /**
     * The JSON redrive policy for the SQS queue. Accepts two key/val pairs: `deadLetterTargetArn` and `maxReceiveCount`. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    public val redrivePolicy: Output<String>
        get() = javaResource.redrivePolicy().applyValue({ args0 -> args0 })
}

public object RedrivePolicyMapper : ResourceMapper<RedrivePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sqs.RedrivePolicy::class == javaResource::class

    override fun map(javaResource: Resource): RedrivePolicy = RedrivePolicy(
        javaResource as
            com.pulumi.aws.sqs.RedrivePolicy,
    )
}

/**
 * @see [RedrivePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RedrivePolicy].
 */
public suspend fun redrivePolicy(
    name: String,
    block: suspend RedrivePolicyResourceBuilder.() -> Unit,
): RedrivePolicy {
    val builder = RedrivePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RedrivePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun redrivePolicy(name: String): RedrivePolicy {
    val builder = RedrivePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
