@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin.inputs

import com.pulumi.aws.sqs.inputs.GetQueuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQueue.
 * @property name Name of the queue to match.
 * @property tags Map of tags for the resource.
 */
public data class GetQueuePlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sqs.inputs.GetQueuePlainArgs> {
    override fun toJava(): com.pulumi.aws.sqs.inputs.GetQueuePlainArgs =
        com.pulumi.aws.sqs.inputs.GetQueuePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetQueuePlainArgs].
 */
@PulumiTagMarker
public class GetQueuePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the queue to match.
     */
    @JvmName("bacfgdhvvedytrbr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("fscvpahhqpxteelw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("xeddbmhctwmgsxuy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetQueuePlainArgs = GetQueuePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
