@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin.inputs

import com.pulumi.aws.sqs.inputs.GetQueuesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQueues.
 * @property queueNamePrefix A string to use for filtering the list results. Only those queues whose name begins with the specified string are returned. Queue URLs and names are case-sensitive.
 */
public data class GetQueuesPlainArgs(
    public val queueNamePrefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.sqs.inputs.GetQueuesPlainArgs> {
    override fun toJava(): com.pulumi.aws.sqs.inputs.GetQueuesPlainArgs =
        com.pulumi.aws.sqs.inputs.GetQueuesPlainArgs.builder()
            .queueNamePrefix(queueNamePrefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQueuesPlainArgs].
 */
@PulumiTagMarker
public class GetQueuesPlainArgsBuilder internal constructor() {
    private var queueNamePrefix: String? = null

    /**
     * @param value A string to use for filtering the list results. Only those queues whose name begins with the specified string are returned. Queue URLs and names are case-sensitive.
     */
    @JvmName("xugcvakvmtlvfoxt")
    public suspend fun queueNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queueNamePrefix = mapped
    }

    internal fun build(): GetQueuesPlainArgs = GetQueuesPlainArgs(
        queueNamePrefix = queueNamePrefix,
    )
}
