@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getQueues.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property queueNamePrefix
 * @property queueUrls A list of queue URLs.
 */
public data class GetQueuesResult(
    public val id: String,
    public val queueNamePrefix: String? = null,
    public val queueUrls: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sqs.outputs.GetQueuesResult): GetQueuesResult =
            GetQueuesResult(
                id = javaType.id(),
                queueNamePrefix = javaType.queueNamePrefix().map({ args0 -> args0 }).orElse(null),
                queueUrls = javaType.queueUrls().map({ args0 -> args0 }),
            )
    }
}
