@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.AssociationArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.AssociationOutputLocationArgs
import com.pulumi.aws.ssm.kotlin.inputs.AssociationOutputLocationArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.AssociationTargetArgs
import com.pulumi.aws.ssm.kotlin.inputs.AssociationTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Associates an SSM Document to an instance or EC2 tag.
 * ## Example Usage
 * ### Create an association for a specific instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.Association("example", {
 *     name: exampleAwsSsmDocument.name,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.Association("example",
 *     name=example_aws_ssm_document["name"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.Association("example", new()
 *     {
 *         Name = exampleAwsSsmDocument.Name,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.AssociationTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewAssociation(ctx, "example", &ssm.AssociationArgs{
 * 			Name: pulumi.Any(exampleAwsSsmDocument.Name),
 * 			Targets: ssm.AssociationTargetArray{
 * 				&ssm.AssociationTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .name(exampleAwsSsmDocument.name())
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:Association
 *     properties:
 *       name: ${exampleAwsSsmDocument.name}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create an association for all managed instances in an AWS account
 * To target all managed instances in an AWS account, set the `key` as `"InstanceIds"` with `values` set as `["*"]`. This example also illustrates how to use an Amazon owned SSM document named `AmazonCloudWatch-ManageAgent`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.Association("example", {
 *     name: "AmazonCloudWatch-ManageAgent",
 *     targets: [{
 *         key: "InstanceIds",
 *         values: ["*"],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.Association("example",
 *     name="AmazonCloudWatch-ManageAgent",
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": ["*"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.Association("example", new()
 *     {
 *         Name = "AmazonCloudWatch-ManageAgent",
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.AssociationTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewAssociation(ctx, "example", &ssm.AssociationArgs{
 * 			Name: pulumi.String("AmazonCloudWatch-ManageAgent"),
 * 			Targets: ssm.AssociationTargetArray{
 * 				&ssm.AssociationTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .name("AmazonCloudWatch-ManageAgent")
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:Association
 *     properties:
 *       name: AmazonCloudWatch-ManageAgent
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create an association for a specific tag
 * This example shows how to target all managed instances that are assigned a tag key of `Environment` and value of `Development`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.Association("example", {
 *     name: "AmazonCloudWatch-ManageAgent",
 *     targets: [{
 *         key: "tag:Environment",
 *         values: ["Development"],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.Association("example",
 *     name="AmazonCloudWatch-ManageAgent",
 *     targets=[{
 *         "key": "tag:Environment",
 *         "values": ["Development"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.Association("example", new()
 *     {
 *         Name = "AmazonCloudWatch-ManageAgent",
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.AssociationTargetArgs
 *             {
 *                 Key = "tag:Environment",
 *                 Values = new[]
 *                 {
 *                     "Development",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewAssociation(ctx, "example", &ssm.AssociationArgs{
 * 			Name: pulumi.String("AmazonCloudWatch-ManageAgent"),
 * 			Targets: ssm.AssociationTargetArray{
 * 				&ssm.AssociationTargetArgs{
 * 					Key: pulumi.String("tag:Environment"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("Development"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .name("AmazonCloudWatch-ManageAgent")
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("tag:Environment")
 *                 .values("Development")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:Association
 *     properties:
 *       name: AmazonCloudWatch-ManageAgent
 *       targets:
 *         - key: tag:Environment
 *           values:
 *             - Development
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create an association with a specific schedule
 * This example shows how to schedule an association in various ways.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.Association("example", {
 *     name: exampleAwsSsmDocument.name,
 *     scheduleExpression: "cron(0 2 ? * SUN *)",
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.Association("example",
 *     name=example_aws_ssm_document["name"],
 *     schedule_expression="cron(0 2 ? * SUN *)",
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.Association("example", new()
 *     {
 *         Name = exampleAwsSsmDocument.Name,
 *         ScheduleExpression = "cron(0 2 ? * SUN *)",
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.AssociationTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewAssociation(ctx, "example", &ssm.AssociationArgs{
 * 			Name:               pulumi.Any(exampleAwsSsmDocument.Name),
 * 			ScheduleExpression: pulumi.String("cron(0 2 ? * SUN *)"),
 * 			Targets: ssm.AssociationTargetArray{
 * 				&ssm.AssociationTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .name(exampleAwsSsmDocument.name())
 *             .scheduleExpression("cron(0 2 ? * SUN *)")
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:Association
 *     properties:
 *       name: ${exampleAwsSsmDocument.name}
 *       scheduleExpression: cron(0 2 ? * SUN *)
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSM associations using the `association_id`. For example:
 * ```sh
 * $ pulumi import aws:ssm/association:Association test-association 10abcdef-0abc-1234-5678-90abcdef123456
 * ```
 * @property applyOnlyAtCronInterval By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
 * @property associationName The descriptive name for the association.
 * @property automationTargetParameterName Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
 * @property complianceSeverity The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
 * @property documentVersion The document version you want to associate with the target(s). Can be a specific version or the default version.
 * @property instanceId The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
 * @property maxConcurrency The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
 * @property maxErrors The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
 * @property name The name of the SSM document to apply.
 * @property outputLocation An output location block. Output Location is documented below.
 * @property parameters A block of arbitrary string parameters to pass to the SSM document.
 * @property scheduleExpression A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
 * @property syncCompliance The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
 * @property tags A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targets A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
 * @property waitForSuccessTimeoutSeconds The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
 * Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
 */
public data class AssociationArgs(
    public val applyOnlyAtCronInterval: Output<Boolean>? = null,
    public val associationName: Output<String>? = null,
    public val automationTargetParameterName: Output<String>? = null,
    public val complianceSeverity: Output<String>? = null,
    public val documentVersion: Output<String>? = null,
    @Deprecated(
        message = """
  use 'targets' argument instead.
      https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId
  """,
    )
    public val instanceId: Output<String>? = null,
    public val maxConcurrency: Output<String>? = null,
    public val maxErrors: Output<String>? = null,
    public val name: Output<String>? = null,
    public val outputLocation: Output<AssociationOutputLocationArgs>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val scheduleExpression: Output<String>? = null,
    public val syncCompliance: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targets: Output<List<AssociationTargetArgs>>? = null,
    public val waitForSuccessTimeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.AssociationArgs> {
    override fun toJava(): com.pulumi.aws.ssm.AssociationArgs =
        com.pulumi.aws.ssm.AssociationArgs.builder()
            .applyOnlyAtCronInterval(applyOnlyAtCronInterval?.applyValue({ args0 -> args0 }))
            .associationName(associationName?.applyValue({ args0 -> args0 }))
            .automationTargetParameterName(automationTargetParameterName?.applyValue({ args0 -> args0 }))
            .complianceSeverity(complianceSeverity?.applyValue({ args0 -> args0 }))
            .documentVersion(documentVersion?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .maxConcurrency(maxConcurrency?.applyValue({ args0 -> args0 }))
            .maxErrors(maxErrors?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .outputLocation(outputLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .scheduleExpression(scheduleExpression?.applyValue({ args0 -> args0 }))
            .syncCompliance(syncCompliance?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .waitForSuccessTimeoutSeconds(waitForSuccessTimeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssociationArgs].
 */
@PulumiTagMarker
public class AssociationArgsBuilder internal constructor() {
    private var applyOnlyAtCronInterval: Output<Boolean>? = null

    private var associationName: Output<String>? = null

    private var automationTargetParameterName: Output<String>? = null

    private var complianceSeverity: Output<String>? = null

    private var documentVersion: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var maxConcurrency: Output<String>? = null

    private var maxErrors: Output<String>? = null

    private var name: Output<String>? = null

    private var outputLocation: Output<AssociationOutputLocationArgs>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var scheduleExpression: Output<String>? = null

    private var syncCompliance: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targets: Output<List<AssociationTargetArgs>>? = null

    private var waitForSuccessTimeoutSeconds: Output<Int>? = null

    /**
     * @param value By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
     */
    @JvmName("wwjpjqyvmvybndvl")
    public suspend fun applyOnlyAtCronInterval(`value`: Output<Boolean>) {
        this.applyOnlyAtCronInterval = value
    }

    /**
     * @param value The descriptive name for the association.
     */
    @JvmName("jbegheyfugehjhsw")
    public suspend fun associationName(`value`: Output<String>) {
        this.associationName = value
    }

    /**
     * @param value Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
     */
    @JvmName("tdlyvobacixaevdf")
    public suspend fun automationTargetParameterName(`value`: Output<String>) {
        this.automationTargetParameterName = value
    }

    /**
     * @param value The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
     */
    @JvmName("sdcrmtjqywtjiskx")
    public suspend fun complianceSeverity(`value`: Output<String>) {
        this.complianceSeverity = value
    }

    /**
     * @param value The document version you want to associate with the target(s). Can be a specific version or the default version.
     */
    @JvmName("vsvsembujmwhqkkd")
    public suspend fun documentVersion(`value`: Output<String>) {
        this.documentVersion = value
    }

    /**
     * @param value The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
     */
    @Deprecated(
        message = """
  use 'targets' argument instead.
      https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId
  """,
    )
    @JvmName("xmytxskhqfbimvgo")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
     */
    @JvmName("hyltafdwkfeajwnv")
    public suspend fun maxConcurrency(`value`: Output<String>) {
        this.maxConcurrency = value
    }

    /**
     * @param value The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
     */
    @JvmName("wdxiatcqxtpxqpoe")
    public suspend fun maxErrors(`value`: Output<String>) {
        this.maxErrors = value
    }

    /**
     * @param value The name of the SSM document to apply.
     */
    @JvmName("yrutioxlqtfekhyj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An output location block. Output Location is documented below.
     */
    @JvmName("hrgluwcfjajvqnvs")
    public suspend fun outputLocation(`value`: Output<AssociationOutputLocationArgs>) {
        this.outputLocation = value
    }

    /**
     * @param value A block of arbitrary string parameters to pass to the SSM document.
     */
    @JvmName("agqttwlimowwoane")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
     */
    @JvmName("pyrommukcxptihip")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
     */
    @JvmName("ajvcuypihrkykpnp")
    public suspend fun syncCompliance(`value`: Output<String>) {
        this.syncCompliance = value
    }

    /**
     * @param value A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mmcflgkmucpxmcbe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    @JvmName("djqkmnvdwaioelno")
    public suspend fun targets(`value`: Output<List<AssociationTargetArgs>>) {
        this.targets = value
    }

    @JvmName("khxcexhmtotlkqxx")
    public suspend fun targets(vararg values: Output<AssociationTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    @JvmName("maqcjcledipmohus")
    public suspend fun targets(values: List<Output<AssociationTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
     * Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
     */
    @JvmName("ntdqfaunkvlhytrb")
    public suspend fun waitForSuccessTimeoutSeconds(`value`: Output<Int>) {
        this.waitForSuccessTimeoutSeconds = value
    }

    /**
     * @param value By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
     */
    @JvmName("kvgcjmkyiwpitmup")
    public suspend fun applyOnlyAtCronInterval(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyOnlyAtCronInterval = mapped
    }

    /**
     * @param value The descriptive name for the association.
     */
    @JvmName("wfpatpklmwaoespw")
    public suspend fun associationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationName = mapped
    }

    /**
     * @param value Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
     */
    @JvmName("lbavrxrpakioflot")
    public suspend fun automationTargetParameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationTargetParameterName = mapped
    }

    /**
     * @param value The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
     */
    @JvmName("ixktjmkrgfiflanx")
    public suspend fun complianceSeverity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceSeverity = mapped
    }

    /**
     * @param value The document version you want to associate with the target(s). Can be a specific version or the default version.
     */
    @JvmName("bnkdlvpullkgursw")
    public suspend fun documentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentVersion = mapped
    }

    /**
     * @param value The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
     */
    @Deprecated(
        message = """
  use 'targets' argument instead.
      https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId
  """,
    )
    @JvmName("yffqgexuaauirjco")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
     */
    @JvmName("gursjlqdwcukavlq")
    public suspend fun maxConcurrency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrency = mapped
    }

    /**
     * @param value The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
     */
    @JvmName("rpftrjpfqjuwwkcw")
    public suspend fun maxErrors(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxErrors = mapped
    }

    /**
     * @param value The name of the SSM document to apply.
     */
    @JvmName("lohmqaoynulnhfrp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An output location block. Output Location is documented below.
     */
    @JvmName("ojjixnsphyqighup")
    public suspend fun outputLocation(`value`: AssociationOutputLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputLocation = mapped
    }

    /**
     * @param argument An output location block. Output Location is documented below.
     */
    @JvmName("hodvenfxtqgkvmmo")
    public suspend fun outputLocation(argument: suspend AssociationOutputLocationArgsBuilder.() -> Unit) {
        val toBeMapped = AssociationOutputLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputLocation = mapped
    }

    /**
     * @param value A block of arbitrary string parameters to pass to the SSM document.
     */
    @JvmName("fsfhaokbeawwdrqa")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values A block of arbitrary string parameters to pass to the SSM document.
     */
    @JvmName("qyrgxnnytiisgaje")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
     */
    @JvmName("abrkcqpmtkuevrmk")
    public suspend fun scheduleExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    /**
     * @param value The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
     */
    @JvmName("pwqfqubguukundox")
    public suspend fun syncCompliance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncCompliance = mapped
    }

    /**
     * @param value A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("umvulhdukopjbaww")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("huyjjgbjhcjagtlc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    @JvmName("gqfongicogisowsf")
    public suspend fun targets(`value`: List<AssociationTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    @JvmName("kssicusjedjcmvpa")
    public suspend fun targets(argument: List<suspend AssociationTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssociationTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    @JvmName("evhfcpaolqepltdp")
    public suspend fun targets(vararg argument: suspend AssociationTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssociationTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    @JvmName("qniywnnrjyvicorn")
    public suspend fun targets(argument: suspend AssociationTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssociationTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    @JvmName("dintmxbhoewsevcm")
    public suspend fun targets(vararg values: AssociationTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
     * Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
     */
    @JvmName("kyfvvkktnxwdhgns")
    public suspend fun waitForSuccessTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForSuccessTimeoutSeconds = mapped
    }

    internal fun build(): AssociationArgs = AssociationArgs(
        applyOnlyAtCronInterval = applyOnlyAtCronInterval,
        associationName = associationName,
        automationTargetParameterName = automationTargetParameterName,
        complianceSeverity = complianceSeverity,
        documentVersion = documentVersion,
        instanceId = instanceId,
        maxConcurrency = maxConcurrency,
        maxErrors = maxErrors,
        name = name,
        outputLocation = outputLocation,
        parameters = parameters,
        scheduleExpression = scheduleExpression,
        syncCompliance = syncCompliance,
        tags = tags,
        targets = targets,
        waitForSuccessTimeoutSeconds = waitForSuccessTimeoutSeconds,
    )
}
