@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.ContactsRotationRecurrence
import com.pulumi.aws.ssm.kotlin.outputs.ContactsRotationRecurrence.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ContactsRotation].
 */
@PulumiTagMarker
public class ContactsRotationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactsRotationArgs = ContactsRotationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactsRotationArgsBuilder.() -> Unit) {
        val builder = ContactsRotationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContactsRotation {
        val builtJavaResource = com.pulumi.aws.ssm.ContactsRotation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContactsRotation(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.ContactsRotation("example", {
 *     contactIds: [exampleAwsSsmcontactsContact&#46;arn],
 *     name: "rotation",
 *     recurrence: {
 *         numberOfOnCalls: 1,
 *         recurrenceMultiplier: 1,
 *         dailySettings: [{
 *             hourOfDay: 9,
 *             minuteOfHour: 0,
 *         }],
 *     },
 *     timeZoneId: "Australia/Sydney",
 * }, {
 *     dependsOn: [exampleAwsSsmincidentsReplicationSet],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.ContactsRotation("example",
 *     contact_ids=[example_aws_ssmcontacts_contact["arn"]],
 *     name="rotation",
 *     recurrence={
 *         "number_of_on_calls": 1,
 *         "recurrence_multiplier": 1,
 *         "daily_settings": [{
 *             "hour_of_day": 9,
 *             "minute_of_hour": 0,
 *         }],
 *     },
 *     time_zone_id="Australia/Sydney",
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.ContactsRotation("example", new()
 *     {
 *         ContactIds = new[]
 *         {
 *             exampleAwsSsmcontactsContact.Arn,
 *         },
 *         Name = "rotation",
 *         Recurrence = new Aws.Ssm.Inputs.ContactsRotationRecurrenceArgs
 *         {
 *             NumberOfOnCalls = 1,
 *             RecurrenceMultiplier = 1,
 *             DailySettings = new[]
 *             {
 *                 new Aws.Ssm.Inputs.ContactsRotationRecurrenceDailySettingArgs
 *                 {
 *                     HourOfDay = 9,
 *                     MinuteOfHour = 0,
 *                 },
 *             },
 *         },
 *         TimeZoneId = "Australia/Sydney",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSsmincidentsReplicationSet,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewContactsRotation(ctx, "example", &ssm.ContactsRotationArgs{
 * 			ContactIds: pulumi.StringArray{
 * 				exampleAwsSsmcontactsContact.Arn,
 * 			},
 * 			Name: pulumi.String("rotation"),
 * 			Recurrence: &ssm.ContactsRotationRecurrenceArgs{
 * 				NumberOfOnCalls:      pulumi.Int(1),
 * 				RecurrenceMultiplier: pulumi.Int(1),
 * 				DailySettings: ssm.ContactsRotationRecurrenceDailySettingArray{
 * 					&ssm.ContactsRotationRecurrenceDailySettingArgs{
 * 						HourOfDay:    pulumi.Int(9),
 * 						MinuteOfHour: pulumi.Int(0),
 * 					},
 * 				},
 * 			},
 * 			TimeZoneId: pulumi.String("Australia/Sydney"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSsmincidentsReplicationSet,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.ContactsRotation;
 * import com.pulumi.aws.ssm.ContactsRotationArgs;
 * import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactsRotation("example", ContactsRotationArgs.builder()
 *             .contactIds(exampleAwsSsmcontactsContact.arn())
 *             .name("rotation")
 *             .recurrence(ContactsRotationRecurrenceArgs.builder()
 *                 .numberOfOnCalls(1)
 *                 .recurrenceMultiplier(1)
 *                 .dailySettings(ContactsRotationRecurrenceDailySettingArgs.builder()
 *                     .hourOfDay(9)
 *                     .minuteOfHour(0)
 *                     .build())
 *                 .build())
 *             .timeZoneId("Australia/Sydney")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSsmincidentsReplicationSet)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:ContactsRotation
 *     properties:
 *       contactIds:
 *         - ${exampleAwsSsmcontactsContact.arn}
 *       name: rotation
 *       recurrence:
 *         numberOfOnCalls: 1
 *         recurrenceMultiplier: 1
 *         dailySettings:
 *           - hourOfDay: 9
 *             minuteOfHour: 0
 *       timeZoneId: Australia/Sydney
 *     options:
 *       dependson:
 *         - ${exampleAwsSsmincidentsReplicationSet}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with Weekly Settings and Shift Coverages Fields
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.ContactsRotation("example", {
 *     contactIds: [exampleAwsSsmcontactsContact&#46;arn],
 *     name: "rotation",
 *     recurrence: {
 *         numberOfOnCalls: 1,
 *         recurrenceMultiplier: 1,
 *         weeklySettings: [
 *             {
 *                 dayOfWeek: "WED",
 *                 handOffTime: {
 *                     hourOfDay: 4,
 *                     minuteOfHour: 25,
 *                 },
 *             },
 *             {
 *                 dayOfWeek: "FRI",
 *                 handOffTime: {
 *                     hourOfDay: 15,
 *                     minuteOfHour: 57,
 *                 },
 *             },
 *         ],
 *         shiftCoverages: [{
 *             mapBlockKey: "MON",
 *             coverageTimes: [{
 *                 start: {
 *                     hourOfDay: 1,
 *                     minuteOfHour: 0,
 *                 },
 *                 end: {
 *                     hourOfDay: 23,
 *                     minuteOfHour: 0,
 *                 },
 *             }],
 *         }],
 *     },
 *     startTime: "2023-07-20T02:21:49+00:00",
 *     timeZoneId: "Australia/Sydney",
 *     tags: {
 *         key1: "tag1",
 *         key2: "tag2",
 *     },
 * }, {
 *     dependsOn: [exampleAwsSsmincidentsReplicationSet],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.ContactsRotation("example",
 *     contact_ids=[example_aws_ssmcontacts_contact["arn"]],
 *     name="rotation",
 *     recurrence={
 *         "number_of_on_calls": 1,
 *         "recurrence_multiplier": 1,
 *         "weekly_settings": [
 *             {
 *                 "day_of_week": "WED",
 *                 "hand_off_time": {
 *                     "hour_of_day": 4,
 *                     "minute_of_hour": 25,
 *                 },
 *             },
 *             {
 *                 "day_of_week": "FRI",
 *                 "hand_off_time": {
 *                     "hour_of_day": 15,
 *                     "minute_of_hour": 57,
 *                 },
 *             },
 *         ],
 *         "shift_coverages": [{
 *             "map_block_key": "MON",
 *             "coverage_times": [{
 *                 "start": {
 *                     "hour_of_day": 1,
 *                     "minute_of_hour": 0,
 *                 },
 *                 "end": {
 *                     "hour_of_day": 23,
 *                     "minute_of_hour": 0,
 *                 },
 *             }],
 *         }],
 *     },
 *     start_time="2023-07-20T02:21:49+00:00",
 *     time_zone_id="Australia/Sydney",
 *     tags={
 *         "key1": "tag1",
 *         "key2": "tag2",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.ContactsRotation("example", new()
 *     {
 *         ContactIds = new[]
 *         {
 *             exampleAwsSsmcontactsContact.Arn,
 *         },
 *         Name = "rotation",
 *         Recurrence = new Aws.Ssm.Inputs.ContactsRotationRecurrenceArgs
 *         {
 *             NumberOfOnCalls = 1,
 *             RecurrenceMultiplier = 1,
 *             WeeklySettings = new[]
 *             {
 *                 new Aws.Ssm.Inputs.ContactsRotationRecurrenceWeeklySettingArgs
 *                 {
 *                     DayOfWeek = "WED",
 *                     HandOffTime = new Aws.Ssm.Inputs.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs
 *                     {
 *                         HourOfDay = 4,
 *                         MinuteOfHour = 25,
 *                     },
 *                 },
 *                 new Aws.Ssm.Inputs.ContactsRotationRecurrenceWeeklySettingArgs
 *                 {
 *                     DayOfWeek = "FRI",
 *                     HandOffTime = new Aws.Ssm.Inputs.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs
 *                     {
 *                         HourOfDay = 15,
 *                         MinuteOfHour = 57,
 *                     },
 *                 },
 *             },
 *             ShiftCoverages = new[]
 *             {
 *                 new Aws.Ssm.Inputs.ContactsRotationRecurrenceShiftCoverageArgs
 *                 {
 *                     MapBlockKey = "MON",
 *                     CoverageTimes = new[]
 *                     {
 *                         new Aws.Ssm.Inputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs
 *                         {
 *                             Start = new Aws.Ssm.Inputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs
 *                             {
 *                                 HourOfDay = 1,
 *                                 MinuteOfHour = 0,
 *                             },
 *                             End = new Aws.Ssm.Inputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs
 *                             {
 *                                 HourOfDay = 23,
 *                                 MinuteOfHour = 0,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         StartTime = "2023-07-20T02:21:49+00:00",
 *         TimeZoneId = "Australia/Sydney",
 *         Tags =
 *         {
 *             { "key1", "tag1" },
 *             { "key2", "tag2" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSsmincidentsReplicationSet,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewContactsRotation(ctx, "example", &ssm.ContactsRotationArgs{
 * 			ContactIds: pulumi.StringArray{
 * 				exampleAwsSsmcontactsContact.Arn,
 * 			},
 * 			Name: pulumi.String("rotation"),
 * 			Recurrence: &ssm.ContactsRotationRecurrenceArgs{
 * 				NumberOfOnCalls:      pulumi.Int(1),
 * 				RecurrenceMultiplier: pulumi.Int(1),
 * 				WeeklySettings: ssm.ContactsRotationRecurrenceWeeklySettingArray{
 * 					&ssm.ContactsRotationRecurrenceWeeklySettingArgs{
 * 						DayOfWeek: pulumi.String("WED"),
 * 						HandOffTime: &ssm.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs{
 * 							HourOfDay:    pulumi.Int(4),
 * 							MinuteOfHour: pulumi.Int(25),
 * 						},
 * 					},
 * 					&ssm.ContactsRotationRecurrenceWeeklySettingArgs{
 * 						DayOfWeek: pulumi.String("FRI"),
 * 						HandOffTime: &ssm.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs{
 * 							HourOfDay:    pulumi.Int(15),
 * 							MinuteOfHour: pulumi.Int(57),
 * 						},
 * 					},
 * 				},
 * 				ShiftCoverages: ssm.ContactsRotationRecurrenceShiftCoverageArray{
 * 					&ssm.ContactsRotationRecurrenceShiftCoverageArgs{
 * 						MapBlockKey: pulumi.String("MON"),
 * 						CoverageTimes: ssm.ContactsRotationRecurrenceShiftCoverageCoverageTimeArray{
 * 							&ssm.ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs{
 * 								Start: &ssm.ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs{
 * 									HourOfDay:    pulumi.Int(1),
 * 									MinuteOfHour: pulumi.Int(0),
 * 								},
 * 								End: &ssm.ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs{
 * 									HourOfDay:    pulumi.Int(23),
 * 									MinuteOfHour: pulumi.Int(0),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			StartTime:  pulumi.String("2023-07-20T02:21:49+00:00"),
 * 			TimeZoneId: pulumi.String("Australia/Sydney"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("tag1"),
 * 				"key2": pulumi.String("tag2"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSsmincidentsReplicationSet,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.ContactsRotation;
 * import com.pulumi.aws.ssm.ContactsRotationArgs;
 * import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactsRotation("example", ContactsRotationArgs.builder()
 *             .contactIds(exampleAwsSsmcontactsContact.arn())
 *             .name("rotation")
 *             .recurrence(ContactsRotationRecurrenceArgs.builder()
 *                 .numberOfOnCalls(1)
 *                 .recurrenceMultiplier(1)
 *                 .weeklySettings(
 *                     ContactsRotationRecurrenceWeeklySettingArgs.builder()
 *                         .dayOfWeek("WED")
 *                         .handOffTime(ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs.builder()
 *                             .hourOfDay(4)
 *                             .minuteOfHour(25)
 *                             .build())
 *                         .build(),
 *                     ContactsRotationRecurrenceWeeklySettingArgs.builder()
 *                         .dayOfWeek("FRI")
 *                         .handOffTime(ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs.builder()
 *                             .hourOfDay(15)
 *                             .minuteOfHour(57)
 *                             .build())
 *                         .build())
 *                 .shiftCoverages(ContactsRotationRecurrenceShiftCoverageArgs.builder()
 *                     .mapBlockKey("MON")
 *                     .coverageTimes(ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs.builder()
 *                         .start(ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs.builder()
 *                             .hourOfDay(1)
 *                             .minuteOfHour(0)
 *                             .build())
 *                         .end(ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs.builder()
 *                             .hourOfDay(23)
 *                             .minuteOfHour(0)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .startTime("2023-07-20T02:21:49+00:00")
 *             .timeZoneId("Australia/Sydney")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "tag1"),
 *                 Map.entry("key2", "tag2")
 *             ))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSsmincidentsReplicationSet)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:ContactsRotation
 *     properties:
 *       contactIds:
 *         - ${exampleAwsSsmcontactsContact.arn}
 *       name: rotation
 *       recurrence:
 *         numberOfOnCalls: 1
 *         recurrenceMultiplier: 1
 *         weeklySettings:
 *           - dayOfWeek: WED
 *             handOffTime:
 *               hourOfDay: 4
 *               minuteOfHour: 25
 *           - dayOfWeek: FRI
 *             handOffTime:
 *               hourOfDay: 15
 *               minuteOfHour: 57
 *         shiftCoverages:
 *           - mapBlockKey: MON
 *             coverageTimes:
 *               - start:
 *                   hourOfDay: 1
 *                   minuteOfHour: 0
 *                 end:
 *                   hourOfDay: 23
 *                   minuteOfHour: 0
 *       startTime: 2023-07-20T02:21:49+00:00
 *       timeZoneId: Australia/Sydney
 *       tags:
 *         key1: tag1
 *         key2: tag2
 *     options:
 *       dependson:
 *         - ${exampleAwsSsmincidentsReplicationSet}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with Monthly Settings Fields
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.ContactsRotation("example", {
 *     contactIds: [exampleAwsSsmcontactsContact&#46;arn],
 *     name: "rotation",
 *     recurrence: {
 *         numberOfOnCalls: 1,
 *         recurrenceMultiplier: 1,
 *         monthlySettings: [
 *             {
 *                 dayOfMonth: 20,
 *                 handOffTime: {
 *                     hourOfDay: 8,
 *                     minuteOfHour: 0,
 *                 },
 *             },
 *             {
 *                 dayOfMonth: 13,
 *                 handOffTime: {
 *                     hourOfDay: 12,
 *                     minuteOfHour: 34,
 *                 },
 *             },
 *         ],
 *     },
 *     timeZoneId: "Australia/Sydney",
 * }, {
 *     dependsOn: [exampleAwsSsmincidentsReplicationSet],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.ContactsRotation("example",
 *     contact_ids=[example_aws_ssmcontacts_contact["arn"]],
 *     name="rotation",
 *     recurrence={
 *         "number_of_on_calls": 1,
 *         "recurrence_multiplier": 1,
 *         "monthly_settings": [
 *             {
 *                 "day_of_month": 20,
 *                 "hand_off_time": {
 *                     "hour_of_day": 8,
 *                     "minute_of_hour": 0,
 *                 },
 *             },
 *             {
 *                 "day_of_month": 13,
 *                 "hand_off_time": {
 *                     "hour_of_day": 12,
 *                     "minute_of_hour": 34,
 *                 },
 *             },
 *         ],
 *     },
 *     time_zone_id="Australia/Sydney",
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.ContactsRotation("example", new()
 *     {
 *         ContactIds = new[]
 *         {
 *             exampleAwsSsmcontactsContact.Arn,
 *         },
 *         Name = "rotation",
 *         Recurrence = new Aws.Ssm.Inputs.ContactsRotationRecurrenceArgs
 *         {
 *             NumberOfOnCalls = 1,
 *             RecurrenceMultiplier = 1,
 *             MonthlySettings = new[]
 *             {
 *                 new Aws.Ssm.Inputs.ContactsRotationRecurrenceMonthlySettingArgs
 *                 {
 *                     DayOfMonth = 20,
 *                     HandOffTime = new Aws.Ssm.Inputs.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs
 *                     {
 *                         HourOfDay = 8,
 *                         MinuteOfHour = 0,
 *                     },
 *                 },
 *                 new Aws.Ssm.Inputs.ContactsRotationRecurrenceMonthlySettingArgs
 *                 {
 *                     DayOfMonth = 13,
 *                     HandOffTime = new Aws.Ssm.Inputs.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs
 *                     {
 *                         HourOfDay = 12,
 *                         MinuteOfHour = 34,
 *                     },
 *                 },
 *             },
 *         },
 *         TimeZoneId = "Australia/Sydney",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSsmincidentsReplicationSet,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewContactsRotation(ctx, "example", &ssm.ContactsRotationArgs{
 * 			ContactIds: pulumi.StringArray{
 * 				exampleAwsSsmcontactsContact.Arn,
 * 			},
 * 			Name: pulumi.String("rotation"),
 * 			Recurrence: &ssm.ContactsRotationRecurrenceArgs{
 * 				NumberOfOnCalls:      pulumi.Int(1),
 * 				RecurrenceMultiplier: pulumi.Int(1),
 * 				MonthlySettings: ssm.ContactsRotationRecurrenceMonthlySettingArray{
 * 					&ssm.ContactsRotationRecurrenceMonthlySettingArgs{
 * 						DayOfMonth: pulumi.Int(20),
 * 						HandOffTime: &ssm.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs{
 * 							HourOfDay:    pulumi.Int(8),
 * 							MinuteOfHour: pulumi.Int(0),
 * 						},
 * 					},
 * 					&ssm.ContactsRotationRecurrenceMonthlySettingArgs{
 * 						DayOfMonth: pulumi.Int(13),
 * 						HandOffTime: &ssm.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs{
 * 							HourOfDay:    pulumi.Int(12),
 * 							MinuteOfHour: pulumi.Int(34),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			TimeZoneId: pulumi.String("Australia/Sydney"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSsmincidentsReplicationSet,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.ContactsRotation;
 * import com.pulumi.aws.ssm.ContactsRotationArgs;
 * import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactsRotation("example", ContactsRotationArgs.builder()
 *             .contactIds(exampleAwsSsmcontactsContact.arn())
 *             .name("rotation")
 *             .recurrence(ContactsRotationRecurrenceArgs.builder()
 *                 .numberOfOnCalls(1)
 *                 .recurrenceMultiplier(1)
 *                 .monthlySettings(
 *                     ContactsRotationRecurrenceMonthlySettingArgs.builder()
 *                         .dayOfMonth(20)
 *                         .handOffTime(ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs.builder()
 *                             .hourOfDay(8)
 *                             .minuteOfHour(0)
 *                             .build())
 *                         .build(),
 *                     ContactsRotationRecurrenceMonthlySettingArgs.builder()
 *                         .dayOfMonth(13)
 *                         .handOffTime(ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs.builder()
 *                             .hourOfDay(12)
 *                             .minuteOfHour(34)
 *                             .build())
 *                         .build())
 *                 .build())
 *             .timeZoneId("Australia/Sydney")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSsmincidentsReplicationSet)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:ContactsRotation
 *     properties:
 *       contactIds:
 *         - ${exampleAwsSsmcontactsContact.arn}
 *       name: rotation
 *       recurrence:
 *         numberOfOnCalls: 1
 *         recurrenceMultiplier: 1
 *         monthlySettings:
 *           - dayOfMonth: 20
 *             handOffTime:
 *               hourOfDay: 8
 *               minuteOfHour: 0
 *           - dayOfMonth: 13
 *             handOffTime:
 *               hourOfDay: 12
 *               minuteOfHour: 34
 *       timeZoneId: Australia/Sydney
 *     options:
 *       dependson:
 *         - ${exampleAwsSsmincidentsReplicationSet}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeGuru Profiler Profiling Group using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:ssm/contactsRotation:ContactsRotation example arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example
 * ```
 */
public class ContactsRotation internal constructor(
    override val javaResource: com.pulumi.aws.ssm.ContactsRotation,
) : KotlinCustomResource(javaResource, ContactsRotationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the rotation.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
     */
    public val contactIds: Output<List<String>>
        get() = javaResource.contactIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name for the rotation.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.
     * The following arguments are optional:
     */
    public val recurrence: Output<ContactsRotationRecurrence>?
        get() = javaResource.recurrence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The date and time, in RFC 3339 format, that the rotation goes into effect.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
     */
    public val timeZoneId: Output<String>
        get() = javaResource.timeZoneId().applyValue({ args0 -> args0 })
}

public object ContactsRotationMapper : ResourceMapper<ContactsRotation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.ContactsRotation::class == javaResource::class

    override fun map(javaResource: Resource): ContactsRotation = ContactsRotation(
        javaResource as
            com.pulumi.aws.ssm.ContactsRotation,
    )
}

/**
 * @see [ContactsRotation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContactsRotation].
 */
public suspend fun contactsRotation(
    name: String,
    block: suspend ContactsRotationResourceBuilder.() -> Unit,
): ContactsRotation {
    val builder = ContactsRotationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContactsRotation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contactsRotation(name: String): ContactsRotation {
    val builder = ContactsRotationResourceBuilder()
    builder.name(name)
    return builder.build()
}
