@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.DocumentArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.DocumentAttachmentsSourceArgs
import com.pulumi.aws.ssm.kotlin.inputs.DocumentAttachmentsSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an SSM Document resource
 * > **NOTE on updating SSM documents:** Only documents with a schema version of 2.0
 * or greater can update their content once created, see [SSM Schema Features](http://docs&#46;aws&#46;amazon&#46;com/systems-manager/latest/userguide/sysman-ssm-docs&#46;html#document-schemas-features)&#46; To update a document with an older schema version you must recreate the resource&#46; Not all document types support a schema version of 2&#46;0 or greater&#46; Refer to [SSM document schema features and examples](https://docs.aws.amazon.com/systems-manager/latest/userguide/document-schemas-features.html) for information about which schema versions are supported for the respective `document_type`.
 * ## Example Usage
 * ### Create an ssm document in JSON format
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ssm.Document("foo", {
 *     name: "test_document",
 *     documentType: "Command",
 *     content: `  {
 *     "schemaVersion": "1.2",
 *     "description": "Check ip configuration of a Linux instance.",
 *     "parameters": {
 *     },
 *     "runtimeConfig": {
 *       "aws:runShellScript": {
 *         "properties": [
 *           {
 *             "id": "0.aws:runShellScript",
 *             "runCommand": ["ifconfig"]
 *           }
 *         ]
 *       }
 *     }
 *   }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ssm.Document("foo",
 *     name="test_document",
 *     document_type="Command",
 *     content="""  {
 *     "schemaVersion": "1.2",
 *     "description": "Check ip configuration of a Linux instance.",
 *     "parameters": {
 *     },
 *     "runtimeConfig": {
 *       "aws:runShellScript": {
 *         "properties": [
 *           {
 *             "id": "0.aws:runShellScript",
 *             "runCommand": ["ifconfig"]
 *           }
 *         ]
 *       }
 *     }
 *   }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ssm.Document("foo", new()
 *     {
 *         Name = "test_document",
 *         DocumentType = "Command",
 *         Content = @"  {
 *     ""schemaVersion"": ""1.2"",
 *     ""description"": ""Check ip configuration of a Linux instance."",
 *     ""parameters"": {
 *     },
 *     ""runtimeConfig"": {
 *       ""aws:runShellScript"": {
 *         ""properties"": [
 *           {
 *             ""id"": ""0.aws:runShellScript"",
 *             ""runCommand"": [""ifconfig""]
 *           }
 *         ]
 *       }
 *     }
 *   }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewDocument(ctx, "foo", &ssm.DocumentArgs{
 * 			Name:         pulumi.String("test_document"),
 * 			DocumentType: pulumi.String("Command"),
 * 			Content: pulumi.String(`  {
 *     "schemaVersion": "1.2",
 *     "description": "Check ip configuration of a Linux instance.",
 *     "parameters": {
 *     },
 *     "runtimeConfig": {
 *       "aws:runShellScript": {
 *         "properties": [
 *           {
 *             "id": "0.aws:runShellScript",
 *             "runCommand": ["ifconfig"]
 *           }
 *         ]
 *       }
 *     }
 *   }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Document;
 * import com.pulumi.aws.ssm.DocumentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Document("foo", DocumentArgs.builder()
 *             .name("test_document")
 *             .documentType("Command")
 *             .content("""
 *   {
 *     "schemaVersion": "1.2",
 *     "description": "Check ip configuration of a Linux instance.",
 *     "parameters": {
 *     },
 *     "runtimeConfig": {
 *       "aws:runShellScript": {
 *         "properties": [
 *           {
 *             "id": "0.aws:runShellScript",
 *             "runCommand": ["ifconfig"]
 *           }
 *         ]
 *       }
 *     }
 *   }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ssm:Document
 *     properties:
 *       name: test_document
 *       documentType: Command
 *       content: |2
 *           {
 *             "schemaVersion": "1.2",
 *             "description": "Check ip configuration of a Linux instance.",
 *             "parameters": {
 *             },
 *             "runtimeConfig": {
 *               "aws:runShellScript": {
 *                 "properties": [
 *                   {
 *                     "id": "0.aws:runShellScript",
 *                     "runCommand": ["ifconfig"]
 *                   }
 *                 ]
 *               }
 *             }
 *           }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create an ssm document in YAML format
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ssm.Document("foo", {
 *     name: "test_document",
 *     documentFormat: "YAML",
 *     documentType: "Command",
 *     content: `schemaVersion: '1.2'
 * description: Check ip configuration of a Linux instance.
 * parameters: {}
 * runtimeConfig:
 *   'aws:runShellScript':
 *     properties:
 *       - id: '0.aws:runShellScript'
 *         runCommand:
 *           - ifconfig
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ssm.Document("foo",
 *     name="test_document",
 *     document_format="YAML",
 *     document_type="Command",
 *     content="""schemaVersion: '1.2'
 * description: Check ip configuration of a Linux instance.
 * parameters: {}
 * runtimeConfig:
 *   'aws:runShellScript':
 *     properties:
 *       - id: '0.aws:runShellScript'
 *         runCommand:
 *           - ifconfig
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ssm.Document("foo", new()
 *     {
 *         Name = "test_document",
 *         DocumentFormat = "YAML",
 *         DocumentType = "Command",
 *         Content = @"schemaVersion: '1.2'
 * description: Check ip configuration of a Linux instance.
 * parameters: {}
 * runtimeConfig:
 *   'aws:runShellScript':
 *     properties:
 *       - id: '0.aws:runShellScript'
 *         runCommand:
 *           - ifconfig
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewDocument(ctx, "foo", &ssm.DocumentArgs{
 * 			Name:           pulumi.String("test_document"),
 * 			DocumentFormat: pulumi.String("YAML"),
 * 			DocumentType:   pulumi.String("Command"),
 * 			Content: pulumi.String(`schemaVersion: '1.2'
 * description: Check ip configuration of a Linux instance.
 * parameters: {}
 * runtimeConfig:
 *   'aws:runShellScript':
 *     properties:
 *       - id: '0.aws:runShellScript'
 *         runCommand:
 *           - ifconfig
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Document;
 * import com.pulumi.aws.ssm.DocumentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Document("foo", DocumentArgs.builder()
 *             .name("test_document")
 *             .documentFormat("YAML")
 *             .documentType("Command")
 *             .content("""
 * schemaVersion: '1.2'
 * description: Check ip configuration of a Linux instance.
 * parameters: {}
 * runtimeConfig:
 *   'aws:runShellScript':
 *     properties:
 *       - id: '0.aws:runShellScript'
 *         runCommand:
 *           - ifconfig
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ssm:Document
 *     properties:
 *       name: test_document
 *       documentFormat: YAML
 *       documentType: Command
 *       content: |
 *         schemaVersion: '1.2'
 *         description: Check ip configuration of a Linux instance.
 *         parameters: {}
 *         runtimeConfig:
 *           'aws:runShellScript':
 *             properties:
 *               - id: '0.aws:runShellScript'
 *                 runCommand:
 *                   - ifconfig
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSM Documents using the name. For example:
 * ```sh
 * $ pulumi import aws:ssm/document:Document example example
 * ```
 * The `attachments_source` argument does not have an SSM API method for reading the attachment information detail after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property attachmentsSources One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
 * @property content The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
 * @property documentFormat The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
 * @property documentType The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
 * @property name The name of the document.
 * @property permissions Additional permissions to attach to the document. See Permissions below for details.
 * @property tags A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetType The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
 * @property versionName The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
 */
public data class DocumentArgs(
    public val attachmentsSources: Output<List<DocumentAttachmentsSourceArgs>>? = null,
    public val content: Output<String>? = null,
    public val documentFormat: Output<String>? = null,
    public val documentType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val permissions: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetType: Output<String>? = null,
    public val versionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.DocumentArgs> {
    override fun toJava(): com.pulumi.aws.ssm.DocumentArgs = com.pulumi.aws.ssm.DocumentArgs.builder()
        .attachmentsSources(
            attachmentsSources?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .content(content?.applyValue({ args0 -> args0 }))
        .documentFormat(documentFormat?.applyValue({ args0 -> args0 }))
        .documentType(documentType?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .permissions(
            permissions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .targetType(targetType?.applyValue({ args0 -> args0 }))
        .versionName(versionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentArgs].
 */
@PulumiTagMarker
public class DocumentArgsBuilder internal constructor() {
    private var attachmentsSources: Output<List<DocumentAttachmentsSourceArgs>>? = null

    private var content: Output<String>? = null

    private var documentFormat: Output<String>? = null

    private var documentType: Output<String>? = null

    private var name: Output<String>? = null

    private var permissions: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetType: Output<String>? = null

    private var versionName: Output<String>? = null

    /**
     * @param value One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
     */
    @JvmName("xninpkirmnuywdmn")
    public suspend fun attachmentsSources(`value`: Output<List<DocumentAttachmentsSourceArgs>>) {
        this.attachmentsSources = value
    }

    @JvmName("gonkxmtltojmmwss")
    public suspend fun attachmentsSources(vararg values: Output<DocumentAttachmentsSourceArgs>) {
        this.attachmentsSources = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
     */
    @JvmName("deuorvgbboamnbsj")
    public suspend fun attachmentsSources(values: List<Output<DocumentAttachmentsSourceArgs>>) {
        this.attachmentsSources = Output.all(values)
    }

    /**
     * @param value The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
     */
    @JvmName("yafnjfspnqxgdtce")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
     */
    @JvmName("nsadjqaiuwkhekih")
    public suspend fun documentFormat(`value`: Output<String>) {
        this.documentFormat = value
    }

    /**
     * @param value The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
     */
    @JvmName("ggkjvlekgmbhequv")
    public suspend fun documentType(`value`: Output<String>) {
        this.documentType = value
    }

    /**
     * @param value The name of the document.
     */
    @JvmName("btrayhkptgythagl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Additional permissions to attach to the document. See Permissions below for details.
     */
    @JvmName("pfbsyjacdlhhdskh")
    public suspend fun permissions(`value`: Output<Map<String, String>>) {
        this.permissions = value
    }

    /**
     * @param value A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ritpaowfqhdkfjsj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
     */
    @JvmName("olkfarvvjsfmfghr")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
     */
    @JvmName("yfyhfpppgprxpgsk")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
     */
    @JvmName("qewytkpojvxuogxt")
    public suspend fun attachmentsSources(`value`: List<DocumentAttachmentsSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentsSources = mapped
    }

    /**
     * @param argument One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
     */
    @JvmName("wmfwmnsteuicmgwg")
    public suspend fun attachmentsSources(argument: List<suspend DocumentAttachmentsSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DocumentAttachmentsSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attachmentsSources = mapped
    }

    /**
     * @param argument One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
     */
    @JvmName("njjxcllmoqshscrh")
    public suspend fun attachmentsSources(vararg argument: suspend DocumentAttachmentsSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DocumentAttachmentsSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attachmentsSources = mapped
    }

    /**
     * @param argument One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
     */
    @JvmName("ujydmuscqpmdsjpk")
    public suspend fun attachmentsSources(argument: suspend DocumentAttachmentsSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DocumentAttachmentsSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attachmentsSources = mapped
    }

    /**
     * @param values One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
     */
    @JvmName("eqbavxirwgvgwdfb")
    public suspend fun attachmentsSources(vararg values: DocumentAttachmentsSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attachmentsSources = mapped
    }

    /**
     * @param value The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
     */
    @JvmName("ypeevquasnxfkvdd")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
     */
    @JvmName("ohkpxbfecpekhndy")
    public suspend fun documentFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentFormat = mapped
    }

    /**
     * @param value The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
     */
    @JvmName("qtwamcwtawepspeq")
    public suspend fun documentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentType = mapped
    }

    /**
     * @param value The name of the document.
     */
    @JvmName("pkbtbcxuwyseqsrw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Additional permissions to attach to the document. See Permissions below for details.
     */
    @JvmName("vyxqqqryjrvnwotu")
    public suspend fun permissions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values Additional permissions to attach to the document. See Permissions below for details.
     */
    @JvmName("mfppwjtgoxsgmdrr")
    public fun permissions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wwwhrmpiwifitjfy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("shohpkxhppswnhpx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
     */
    @JvmName("luvwwgglfyewhujp")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
     */
    @JvmName("sgvfdmvyftnljokp")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    internal fun build(): DocumentArgs = DocumentArgs(
        attachmentsSources = attachmentsSources,
        content = content,
        documentFormat = documentFormat,
        documentType = documentType,
        name = name,
        permissions = permissions,
        tags = tags,
        targetType = targetType,
        versionName = versionName,
    )
}
