@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTarget
import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParameters
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTarget.Companion.toKotlin as maintenanceWindowTaskTargetToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParameters.Companion.toKotlin as maintenanceWindowTaskTaskInvocationParametersToKotlin

/**
 * Builder for [MaintenanceWindowTask].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MaintenanceWindowTaskArgs = MaintenanceWindowTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MaintenanceWindowTaskArgsBuilder.() -> Unit) {
        val builder = MaintenanceWindowTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MaintenanceWindowTask {
        val builtJavaResource = com.pulumi.aws.ssm.MaintenanceWindowTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MaintenanceWindowTask(builtJavaResource)
    }
}

/**
 * Provides an SSM Maintenance Window Task resource
 * ## Example Usage
 * ### Automation Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: "AWS-RestartEC2Instance",
 *     taskType: "AUTOMATION",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         automationParameters: {
 *             documentVersion: "$LATEST",
 *             parameters: [{
 *                 name: "InstanceId",
 *                 values: [exampleAwsInstance&#46;id],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn="AWS-RestartEC2Instance",
 *     task_type="AUTOMATION",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "automation_parameters": {
 *             "document_version": "$LATEST",
 *             "parameters": [{
 *                 "name": "InstanceId",
 *                 "values": [example_aws_instance["id"]],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = "AWS-RestartEC2Instance",
 *         TaskType = "AUTOMATION",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             AutomationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs
 *             {
 *                 DocumentVersion = "$LATEST",
 *                 Parameters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs
 *                     {
 *                         Name = "InstanceId",
 *                         Values = new[]
 *                         {
 *                             exampleAwsInstance.Id,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.String("AWS-RestartEC2Instance"),
 * 			TaskType:       pulumi.String("AUTOMATION"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				AutomationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs{
 * 					DocumentVersion: pulumi.String("$LATEST"),
 * 					Parameters: ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArray{
 * 						&ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs{
 * 							Name: pulumi.String("InstanceId"),
 * 							Values: pulumi.StringArray{
 * 								exampleAwsInstance.Id,
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RestartEC2Instance")
 *             .taskType("AUTOMATION")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .automationParameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs.builder()
 *                     .documentVersion("$LATEST")
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs.builder()
 *                         .name("InstanceId")
 *                         .values(exampleAwsInstance.id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: AWS-RestartEC2Instance
 *       taskType: AUTOMATION
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         automationParameters:
 *           documentVersion: $LATEST
 *           parameters:
 *             - name: InstanceId
 *               values:
 *                 - ${exampleAwsInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Lambda Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: exampleAwsLambdaFunction.arn,
 *     taskType: "LAMBDA",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         lambdaParameters: {
 *             clientContext: std.base64encode({
 *                 input: "{\"key1\":\"value1\"}",
 *             }).then(invoke => invoke.result),
 *             payload: "{\"key1\":\"value1\"}",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn=example_aws_lambda_function["arn"],
 *     task_type="LAMBDA",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "lambda_parameters": {
 *             "client_context": std.base64encode(input="{\"key1\":\"value1\"}").result,
 *             "payload": "{\"key1\":\"value1\"}",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = exampleAwsLambdaFunction.Arn,
 *         TaskType = "LAMBDA",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             LambdaParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs
 *             {
 *                 ClientContext = Std.Base64encode.Invoke(new()
 *                 {
 *                     Input = "{\"key1\":\"value1\"}",
 *                 }).Apply(invoke => invoke.Result),
 *                 Payload = "{\"key1\":\"value1\"}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "{\"key1\":\"value1\"}",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			TaskType:       pulumi.String("LAMBDA"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				LambdaParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs{
 * 					ClientContext: pulumi.String(invokeBase64encode.Result),
 * 					Payload:       pulumi.String("{\"key1\":\"value1\"}"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn(exampleAwsLambdaFunction.arn())
 *             .taskType("LAMBDA")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .lambdaParameters(MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs.builder()
 *                     .clientContext(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                         .input("{\"key1\":\"value1\"}")
 *                         .build()).result())
 *                     .payload("{\"key1\":\"value1\"}")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: ${exampleAwsLambdaFunction.arn}
 *       taskType: LAMBDA
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         lambdaParameters:
 *           clientContext:
 *             fn::invoke:
 *               Function: std:base64encode
 *               Arguments:
 *                 input: '{"key1":"value1"}'
 *               Return: result
 *           payload: '{"key1":"value1"}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Run Command Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: "AWS-RunShellScript",
 *     taskType: "RUN_COMMAND",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         runCommandParameters: {
 *             outputS3Bucket: exampleAwsS3Bucket.id,
 *             outputS3KeyPrefix: "output",
 *             serviceRoleArn: exampleAwsIamRole.arn,
 *             timeoutSeconds: 600,
 *             notificationConfig: {
 *                 notificationArn: exampleAwsSnsTopic.arn,
 *                 notificationEvents: ["All"],
 *                 notificationType: "Command",
 *             },
 *             parameters: [{
 *                 name: "commands",
 *                 values: ["date"],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn="AWS-RunShellScript",
 *     task_type="RUN_COMMAND",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "run_command_parameters": {
 *             "output_s3_bucket": example_aws_s3_bucket["id"],
 *             "output_s3_key_prefix": "output",
 *             "service_role_arn": example_aws_iam_role["arn"],
 *             "timeout_seconds": 600,
 *             "notification_config": {
 *                 "notification_arn": example_aws_sns_topic["arn"],
 *                 "notification_events": ["All"],
 *                 "notification_type": "Command",
 *             },
 *             "parameters": [{
 *                 "name": "commands",
 *                 "values": ["date"],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = "AWS-RunShellScript",
 *         TaskType = "RUN_COMMAND",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             RunCommandParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs
 *             {
 *                 OutputS3Bucket = exampleAwsS3Bucket.Id,
 *                 OutputS3KeyPrefix = "output",
 *                 ServiceRoleArn = exampleAwsIamRole.Arn,
 *                 TimeoutSeconds = 600,
 *                 NotificationConfig = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs
 *                 {
 *                     NotificationArn = exampleAwsSnsTopic.Arn,
 *                     NotificationEvents = new[]
 *                     {
 *                         "All",
 *                     },
 *                     NotificationType = "Command",
 *                 },
 *                 Parameters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs
 *                     {
 *                         Name = "commands",
 *                         Values = new[]
 *                         {
 *                             "date",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.String("AWS-RunShellScript"),
 * 			TaskType:       pulumi.String("RUN_COMMAND"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				RunCommandParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs{
 * 					OutputS3Bucket:    pulumi.Any(exampleAwsS3Bucket.Id),
 * 					OutputS3KeyPrefix: pulumi.String("output"),
 * 					ServiceRoleArn:    pulumi.Any(exampleAwsIamRole.Arn),
 * 					TimeoutSeconds:    pulumi.Int(600),
 * 					NotificationConfig: &ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs{
 * 						NotificationArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 						NotificationEvents: pulumi.StringArray{
 * 							pulumi.String("All"),
 * 						},
 * 						NotificationType: pulumi.String("Command"),
 * 					},
 * 					Parameters: ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArray{
 * 						&ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs{
 * 							Name: pulumi.String("commands"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("date"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RunShellScript")
 *             .taskType("RUN_COMMAND")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .runCommandParameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs.builder()
 *                     .outputS3Bucket(exampleAwsS3Bucket.id())
 *                     .outputS3KeyPrefix("output")
 *                     .serviceRoleArn(exampleAwsIamRole.arn())
 *                     .timeoutSeconds(600)
 *                     .notificationConfig(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs.builder()
 *                         .notificationArn(exampleAwsSnsTopic.arn())
 *                         .notificationEvents("All")
 *                         .notificationType("Command")
 *                         .build())
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs.builder()
 *                         .name("commands")
 *                         .values("date")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: AWS-RunShellScript
 *       taskType: RUN_COMMAND
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         runCommandParameters:
 *           outputS3Bucket: ${exampleAwsS3Bucket.id}
 *           outputS3KeyPrefix: output
 *           serviceRoleArn: ${exampleAwsIamRole.arn}
 *           timeoutSeconds: 600
 *           notificationConfig:
 *             notificationArn: ${exampleAwsSnsTopic.arn}
 *             notificationEvents:
 *               - All
 *             notificationType: Command
 *           parameters:
 *             - name: commands
 *               values:
 *                 - date
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Step Function Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: exampleAwsSfnActivity.id,
 *     taskType: "STEP_FUNCTIONS",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         stepFunctionsParameters: {
 *             input: "{\"key1\":\"value1\"}",
 *             name: "example",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn=example_aws_sfn_activity["id"],
 *     task_type="STEP_FUNCTIONS",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "step_functions_parameters": {
 *             "input": "{\"key1\":\"value1\"}",
 *             "name": "example",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = exampleAwsSfnActivity.Id,
 *         TaskType = "STEP_FUNCTIONS",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             StepFunctionsParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs
 *             {
 *                 Input = "{\"key1\":\"value1\"}",
 *                 Name = "example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.Any(exampleAwsSfnActivity.Id),
 * 			TaskType:       pulumi.String("STEP_FUNCTIONS"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				StepFunctionsParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs{
 * 					Input: pulumi.String("{\"key1\":\"value1\"}"),
 * 					Name:  pulumi.String("example"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn(exampleAwsSfnActivity.id())
 *             .taskType("STEP_FUNCTIONS")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .stepFunctionsParameters(MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs.builder()
 *                     .input("{\"key1\":\"value1\"}")
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: ${exampleAwsSfnActivity.id}
 *       taskType: STEP_FUNCTIONS
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         stepFunctionsParameters:
 *           input: '{"key1":"value1"}'
 *           name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Maintenance Window Task using the `window_id` and `window_task_id` separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:ssm/maintenanceWindowTask:MaintenanceWindowTask task <window_id>/<window_task_id>
 * ```
 */
public class MaintenanceWindowTask internal constructor(
    override val javaResource: com.pulumi.aws.ssm.MaintenanceWindowTask,
) : KotlinCustomResource(javaResource, MaintenanceWindowTaskMapper) {
    /**
     * The ARN of the maintenance window task.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     */
    public val cutoffBehavior: Output<String>?
        get() = javaResource.cutoffBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the maintenance window task.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of targets this task can be run for in parallel.
     */
    public val maxConcurrency: Output<String>
        get() = javaResource.maxConcurrency().applyValue({ args0 -> args0 })

    /**
     * The maximum number of errors allowed before this task stops being scheduled.
     */
    public val maxErrors: Output<String>
        get() = javaResource.maxErrors().applyValue({ args0 -> args0 })

    /**
     * The name of the maintenance window task.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     */
    public val serviceRoleArn: Output<String>
        get() = javaResource.serviceRoleArn().applyValue({ args0 -> args0 })

    /**
     * The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    public val targets: Output<List<MaintenanceWindowTaskTarget>>?
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> maintenanceWindowTaskTargetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ARN of the task to execute.
     */
    public val taskArn: Output<String>
        get() = javaResource.taskArn().applyValue({ args0 -> args0 })

    /**
     * Configuration block with parameters for task execution.
     */
    public val taskInvocationParameters: Output<MaintenanceWindowTaskTaskInvocationParameters>?
        get() = javaResource.taskInvocationParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    maintenanceWindowTaskTaskInvocationParametersToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     */
    public val taskType: Output<String>
        get() = javaResource.taskType().applyValue({ args0 -> args0 })

    /**
     * The Id of the maintenance window to register the task with.
     */
    public val windowId: Output<String>
        get() = javaResource.windowId().applyValue({ args0 -> args0 })

    /**
     * The ID of the maintenance window task.
     */
    public val windowTaskId: Output<String>
        get() = javaResource.windowTaskId().applyValue({ args0 -> args0 })
}

public object MaintenanceWindowTaskMapper : ResourceMapper<MaintenanceWindowTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.MaintenanceWindowTask::class == javaResource::class

    override fun map(javaResource: Resource): MaintenanceWindowTask =
        MaintenanceWindowTask(javaResource as com.pulumi.aws.ssm.MaintenanceWindowTask)
}

/**
 * @see [MaintenanceWindowTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MaintenanceWindowTask].
 */
public suspend fun maintenanceWindowTask(
    name: String,
    block: suspend MaintenanceWindowTaskResourceBuilder.() -> Unit,
): MaintenanceWindowTask {
    val builder = MaintenanceWindowTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MaintenanceWindowTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun maintenanceWindowTask(name: String): MaintenanceWindowTask {
    val builder = MaintenanceWindowTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
