@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTargetArgs
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTargetArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTaskInvocationParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an SSM Maintenance Window Task resource
 * ## Example Usage
 * ### Automation Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: "AWS-RestartEC2Instance",
 *     taskType: "AUTOMATION",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         automationParameters: {
 *             documentVersion: "$LATEST",
 *             parameters: [{
 *                 name: "InstanceId",
 *                 values: [exampleAwsInstance&#46;id],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn="AWS-RestartEC2Instance",
 *     task_type="AUTOMATION",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "automation_parameters": {
 *             "document_version": "$LATEST",
 *             "parameters": [{
 *                 "name": "InstanceId",
 *                 "values": [example_aws_instance["id"]],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = "AWS-RestartEC2Instance",
 *         TaskType = "AUTOMATION",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             AutomationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs
 *             {
 *                 DocumentVersion = "$LATEST",
 *                 Parameters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs
 *                     {
 *                         Name = "InstanceId",
 *                         Values = new[]
 *                         {
 *                             exampleAwsInstance.Id,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.String("AWS-RestartEC2Instance"),
 * 			TaskType:       pulumi.String("AUTOMATION"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				AutomationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs{
 * 					DocumentVersion: pulumi.String("$LATEST"),
 * 					Parameters: ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArray{
 * 						&ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs{
 * 							Name: pulumi.String("InstanceId"),
 * 							Values: pulumi.StringArray{
 * 								exampleAwsInstance.Id,
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RestartEC2Instance")
 *             .taskType("AUTOMATION")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .automationParameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs.builder()
 *                     .documentVersion("$LATEST")
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs.builder()
 *                         .name("InstanceId")
 *                         .values(exampleAwsInstance.id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: AWS-RestartEC2Instance
 *       taskType: AUTOMATION
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         automationParameters:
 *           documentVersion: $LATEST
 *           parameters:
 *             - name: InstanceId
 *               values:
 *                 - ${exampleAwsInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Lambda Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: exampleAwsLambdaFunction.arn,
 *     taskType: "LAMBDA",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         lambdaParameters: {
 *             clientContext: std.base64encode({
 *                 input: "{\"key1\":\"value1\"}",
 *             }).then(invoke => invoke.result),
 *             payload: "{\"key1\":\"value1\"}",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn=example_aws_lambda_function["arn"],
 *     task_type="LAMBDA",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "lambda_parameters": {
 *             "client_context": std.base64encode(input="{\"key1\":\"value1\"}").result,
 *             "payload": "{\"key1\":\"value1\"}",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = exampleAwsLambdaFunction.Arn,
 *         TaskType = "LAMBDA",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             LambdaParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs
 *             {
 *                 ClientContext = Std.Base64encode.Invoke(new()
 *                 {
 *                     Input = "{\"key1\":\"value1\"}",
 *                 }).Apply(invoke => invoke.Result),
 *                 Payload = "{\"key1\":\"value1\"}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "{\"key1\":\"value1\"}",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			TaskType:       pulumi.String("LAMBDA"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				LambdaParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs{
 * 					ClientContext: pulumi.String(invokeBase64encode.Result),
 * 					Payload:       pulumi.String("{\"key1\":\"value1\"}"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn(exampleAwsLambdaFunction.arn())
 *             .taskType("LAMBDA")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .lambdaParameters(MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs.builder()
 *                     .clientContext(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                         .input("{\"key1\":\"value1\"}")
 *                         .build()).result())
 *                     .payload("{\"key1\":\"value1\"}")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: ${exampleAwsLambdaFunction.arn}
 *       taskType: LAMBDA
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         lambdaParameters:
 *           clientContext:
 *             fn::invoke:
 *               Function: std:base64encode
 *               Arguments:
 *                 input: '{"key1":"value1"}'
 *               Return: result
 *           payload: '{"key1":"value1"}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Run Command Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: "AWS-RunShellScript",
 *     taskType: "RUN_COMMAND",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         runCommandParameters: {
 *             outputS3Bucket: exampleAwsS3Bucket.id,
 *             outputS3KeyPrefix: "output",
 *             serviceRoleArn: exampleAwsIamRole.arn,
 *             timeoutSeconds: 600,
 *             notificationConfig: {
 *                 notificationArn: exampleAwsSnsTopic.arn,
 *                 notificationEvents: ["All"],
 *                 notificationType: "Command",
 *             },
 *             parameters: [{
 *                 name: "commands",
 *                 values: ["date"],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn="AWS-RunShellScript",
 *     task_type="RUN_COMMAND",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "run_command_parameters": {
 *             "output_s3_bucket": example_aws_s3_bucket["id"],
 *             "output_s3_key_prefix": "output",
 *             "service_role_arn": example_aws_iam_role["arn"],
 *             "timeout_seconds": 600,
 *             "notification_config": {
 *                 "notification_arn": example_aws_sns_topic["arn"],
 *                 "notification_events": ["All"],
 *                 "notification_type": "Command",
 *             },
 *             "parameters": [{
 *                 "name": "commands",
 *                 "values": ["date"],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = "AWS-RunShellScript",
 *         TaskType = "RUN_COMMAND",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             RunCommandParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs
 *             {
 *                 OutputS3Bucket = exampleAwsS3Bucket.Id,
 *                 OutputS3KeyPrefix = "output",
 *                 ServiceRoleArn = exampleAwsIamRole.Arn,
 *                 TimeoutSeconds = 600,
 *                 NotificationConfig = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs
 *                 {
 *                     NotificationArn = exampleAwsSnsTopic.Arn,
 *                     NotificationEvents = new[]
 *                     {
 *                         "All",
 *                     },
 *                     NotificationType = "Command",
 *                 },
 *                 Parameters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs
 *                     {
 *                         Name = "commands",
 *                         Values = new[]
 *                         {
 *                             "date",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.String("AWS-RunShellScript"),
 * 			TaskType:       pulumi.String("RUN_COMMAND"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				RunCommandParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs{
 * 					OutputS3Bucket:    pulumi.Any(exampleAwsS3Bucket.Id),
 * 					OutputS3KeyPrefix: pulumi.String("output"),
 * 					ServiceRoleArn:    pulumi.Any(exampleAwsIamRole.Arn),
 * 					TimeoutSeconds:    pulumi.Int(600),
 * 					NotificationConfig: &ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs{
 * 						NotificationArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 						NotificationEvents: pulumi.StringArray{
 * 							pulumi.String("All"),
 * 						},
 * 						NotificationType: pulumi.String("Command"),
 * 					},
 * 					Parameters: ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArray{
 * 						&ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs{
 * 							Name: pulumi.String("commands"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("date"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RunShellScript")
 *             .taskType("RUN_COMMAND")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .runCommandParameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs.builder()
 *                     .outputS3Bucket(exampleAwsS3Bucket.id())
 *                     .outputS3KeyPrefix("output")
 *                     .serviceRoleArn(exampleAwsIamRole.arn())
 *                     .timeoutSeconds(600)
 *                     .notificationConfig(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs.builder()
 *                         .notificationArn(exampleAwsSnsTopic.arn())
 *                         .notificationEvents("All")
 *                         .notificationType("Command")
 *                         .build())
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs.builder()
 *                         .name("commands")
 *                         .values("date")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: AWS-RunShellScript
 *       taskType: RUN_COMMAND
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         runCommandParameters:
 *           outputS3Bucket: ${exampleAwsS3Bucket.id}
 *           outputS3KeyPrefix: output
 *           serviceRoleArn: ${exampleAwsIamRole.arn}
 *           timeoutSeconds: 600
 *           notificationConfig:
 *             notificationArn: ${exampleAwsSnsTopic.arn}
 *             notificationEvents:
 *               - All
 *             notificationType: Command
 *           parameters:
 *             - name: commands
 *               values:
 *                 - date
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Step Function Tasks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssm.MaintenanceWindowTask("example", {
 *     maxConcurrency: "2",
 *     maxErrors: "1",
 *     priority: 1,
 *     taskArn: exampleAwsSfnActivity.id,
 *     taskType: "STEP_FUNCTIONS",
 *     windowId: exampleAwsSsmMaintenanceWindow.id,
 *     targets: [{
 *         key: "InstanceIds",
 *         values: [exampleAwsInstance&#46;id],
 *     }],
 *     taskInvocationParameters: {
 *         stepFunctionsParameters: {
 *             input: "{\"key1\":\"value1\"}",
 *             name: "example",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssm.MaintenanceWindowTask("example",
 *     max_concurrency="2",
 *     max_errors="1",
 *     priority=1,
 *     task_arn=example_aws_sfn_activity["id"],
 *     task_type="STEP_FUNCTIONS",
 *     window_id=example_aws_ssm_maintenance_window["id"],
 *     targets=[{
 *         "key": "InstanceIds",
 *         "values": [example_aws_instance["id"]],
 *     }],
 *     task_invocation_parameters={
 *         "step_functions_parameters": {
 *             "input": "{\"key1\":\"value1\"}",
 *             "name": "example",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ssm.MaintenanceWindowTask("example", new()
 *     {
 *         MaxConcurrency = "2",
 *         MaxErrors = "1",
 *         Priority = 1,
 *         TaskArn = exampleAwsSfnActivity.Id,
 *         TaskType = "STEP_FUNCTIONS",
 *         WindowId = exampleAwsSsmMaintenanceWindow.Id,
 *         Targets = new[]
 *         {
 *             new Aws.Ssm.Inputs.MaintenanceWindowTaskTargetArgs
 *             {
 *                 Key = "InstanceIds",
 *                 Values = new[]
 *                 {
 *                     exampleAwsInstance.Id,
 *                 },
 *             },
 *         },
 *         TaskInvocationParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
 *         {
 *             StepFunctionsParameters = new Aws.Ssm.Inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs
 *             {
 *                 Input = "{\"key1\":\"value1\"}",
 *                 Name = "example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewMaintenanceWindowTask(ctx, "example", &ssm.MaintenanceWindowTaskArgs{
 * 			MaxConcurrency: pulumi.String("2"),
 * 			MaxErrors:      pulumi.String("1"),
 * 			Priority:       pulumi.Int(1),
 * 			TaskArn:        pulumi.Any(exampleAwsSfnActivity.Id),
 * 			TaskType:       pulumi.String("STEP_FUNCTIONS"),
 * 			WindowId:       pulumi.Any(exampleAwsSsmMaintenanceWindow.Id),
 * 			Targets: ssm.MaintenanceWindowTaskTargetArray{
 * 				&ssm.MaintenanceWindowTaskTargetArgs{
 * 					Key: pulumi.String("InstanceIds"),
 * 					Values: pulumi.StringArray{
 * 						exampleAwsInstance.Id,
 * 					},
 * 				},
 * 			},
 * 			TaskInvocationParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersArgs{
 * 				StepFunctionsParameters: &ssm.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs{
 * 					Input: pulumi.String("{\"key1\":\"value1\"}"),
 * 					Name:  pulumi.String("example"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn(exampleAwsSfnActivity.id())
 *             .taskType("STEP_FUNCTIONS")
 *             .windowId(exampleAwsSsmMaintenanceWindow.id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(exampleAwsInstance.id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .stepFunctionsParameters(MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs.builder()
 *                     .input("{\"key1\":\"value1\"}")
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssm:MaintenanceWindowTask
 *     properties:
 *       maxConcurrency: 2
 *       maxErrors: 1
 *       priority: 1
 *       taskArn: ${exampleAwsSfnActivity.id}
 *       taskType: STEP_FUNCTIONS
 *       windowId: ${exampleAwsSsmMaintenanceWindow.id}
 *       targets:
 *         - key: InstanceIds
 *           values:
 *             - ${exampleAwsInstance.id}
 *       taskInvocationParameters:
 *         stepFunctionsParameters:
 *           input: '{"key1":"value1"}'
 *           name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Maintenance Window Task using the `window_id` and `window_task_id` separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:ssm/maintenanceWindowTask:MaintenanceWindowTask task <window_id>/<window_task_id>
 * ```
 * @property cutoffBehavior Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
 * @property description The description of the maintenance window task.
 * @property maxConcurrency The maximum number of targets this task can be run for in parallel.
 * @property maxErrors The maximum number of errors allowed before this task stops being scheduled.
 * @property name The name of the maintenance window task.
 * @property priority The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
 * @property serviceRoleArn The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
 * @property targets The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
 * @property taskArn The ARN of the task to execute.
 * @property taskInvocationParameters Configuration block with parameters for task execution.
 * @property taskType The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
 * @property windowId The Id of the maintenance window to register the task with.
 */
public data class MaintenanceWindowTaskArgs(
    public val cutoffBehavior: Output<String>? = null,
    public val description: Output<String>? = null,
    public val maxConcurrency: Output<String>? = null,
    public val maxErrors: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val serviceRoleArn: Output<String>? = null,
    public val targets: Output<List<MaintenanceWindowTaskTargetArgs>>? = null,
    public val taskArn: Output<String>? = null,
    public val taskInvocationParameters: Output<MaintenanceWindowTaskTaskInvocationParametersArgs>? =
        null,
    public val taskType: Output<String>? = null,
    public val windowId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.MaintenanceWindowTaskArgs> {
    override fun toJava(): com.pulumi.aws.ssm.MaintenanceWindowTaskArgs =
        com.pulumi.aws.ssm.MaintenanceWindowTaskArgs.builder()
            .cutoffBehavior(cutoffBehavior?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .maxConcurrency(maxConcurrency?.applyValue({ args0 -> args0 }))
            .maxErrors(maxErrors?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .taskArn(taskArn?.applyValue({ args0 -> args0 }))
            .taskInvocationParameters(
                taskInvocationParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .taskType(taskType?.applyValue({ args0 -> args0 }))
            .windowId(windowId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTaskArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskArgsBuilder internal constructor() {
    private var cutoffBehavior: Output<String>? = null

    private var description: Output<String>? = null

    private var maxConcurrency: Output<String>? = null

    private var maxErrors: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var serviceRoleArn: Output<String>? = null

    private var targets: Output<List<MaintenanceWindowTaskTargetArgs>>? = null

    private var taskArn: Output<String>? = null

    private var taskInvocationParameters: Output<MaintenanceWindowTaskTaskInvocationParametersArgs>? =
        null

    private var taskType: Output<String>? = null

    private var windowId: Output<String>? = null

    /**
     * @param value Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     */
    @JvmName("hwyalkooaqtnbyxw")
    public suspend fun cutoffBehavior(`value`: Output<String>) {
        this.cutoffBehavior = value
    }

    /**
     * @param value The description of the maintenance window task.
     */
    @JvmName("widqnwxgpmjsshyy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The maximum number of targets this task can be run for in parallel.
     */
    @JvmName("usaqtylibaphbunq")
    public suspend fun maxConcurrency(`value`: Output<String>) {
        this.maxConcurrency = value
    }

    /**
     * @param value The maximum number of errors allowed before this task stops being scheduled.
     */
    @JvmName("wxmyuxbdbfdrrofm")
    public suspend fun maxErrors(`value`: Output<String>) {
        this.maxErrors = value
    }

    /**
     * @param value The name of the maintenance window task.
     */
    @JvmName("sygjfrfpyorxitta")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     */
    @JvmName("gjwickflmpvxncjf")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     */
    @JvmName("oruojgmnamiqifey")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("udixkvabvtsjvkbk")
    public suspend fun targets(`value`: Output<List<MaintenanceWindowTaskTargetArgs>>) {
        this.targets = value
    }

    @JvmName("rwwlityvkrnyajyo")
    public suspend fun targets(vararg values: Output<MaintenanceWindowTaskTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("jjioctpmbvuumugx")
    public suspend fun targets(values: List<Output<MaintenanceWindowTaskTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The ARN of the task to execute.
     */
    @JvmName("lwmcyrqpbrrcmtqg")
    public suspend fun taskArn(`value`: Output<String>) {
        this.taskArn = value
    }

    /**
     * @param value Configuration block with parameters for task execution.
     */
    @JvmName("asmufsrvboqxkmbp")
    public suspend fun taskInvocationParameters(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersArgs>) {
        this.taskInvocationParameters = value
    }

    /**
     * @param value The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     */
    @JvmName("wtpdpsxlnsjmyoqt")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value The Id of the maintenance window to register the task with.
     */
    @JvmName("qwexhprirdutpxee")
    public suspend fun windowId(`value`: Output<String>) {
        this.windowId = value
    }

    /**
     * @param value Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     */
    @JvmName("duabeltruromfbbk")
    public suspend fun cutoffBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cutoffBehavior = mapped
    }

    /**
     * @param value The description of the maintenance window task.
     */
    @JvmName("xewaqfsrimoufyva")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The maximum number of targets this task can be run for in parallel.
     */
    @JvmName("wukfibpgublklrch")
    public suspend fun maxConcurrency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrency = mapped
    }

    /**
     * @param value The maximum number of errors allowed before this task stops being scheduled.
     */
    @JvmName("dpsxwmaagtvteifk")
    public suspend fun maxErrors(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxErrors = mapped
    }

    /**
     * @param value The name of the maintenance window task.
     */
    @JvmName("rvvuuyndqdcwpwmg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     */
    @JvmName("akbphjrnyyawmprw")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     */
    @JvmName("lrvxejimkkxoxuve")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("esefclatnvpqkepg")
    public suspend fun targets(`value`: List<MaintenanceWindowTaskTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("qxnsjyjubndbgssh")
    public suspend fun targets(argument: List<suspend MaintenanceWindowTaskTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("kdbucakekpmbuadw")
    public suspend fun targets(vararg argument: suspend MaintenanceWindowTaskTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("hdnuaxmflecfetsn")
    public suspend fun targets(argument: suspend MaintenanceWindowTaskTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MaintenanceWindowTaskTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("ktebudhglevvbcei")
    public suspend fun targets(vararg values: MaintenanceWindowTaskTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value The ARN of the task to execute.
     */
    @JvmName("ttwoxmwlbupyaqce")
    public suspend fun taskArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskArn = mapped
    }

    /**
     * @param value Configuration block with parameters for task execution.
     */
    @JvmName("pyxidudpgdudujak")
    public suspend fun taskInvocationParameters(`value`: MaintenanceWindowTaskTaskInvocationParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskInvocationParameters = mapped
    }

    /**
     * @param argument Configuration block with parameters for task execution.
     */
    @JvmName("vhldccjeomdolggc")
    public suspend fun taskInvocationParameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersArgsBuilder.() -> Unit) {
        val toBeMapped = MaintenanceWindowTaskTaskInvocationParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.taskInvocationParameters = mapped
    }

    /**
     * @param value The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     */
    @JvmName("hckhongnelvoxbvn")
    public suspend fun taskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value The Id of the maintenance window to register the task with.
     */
    @JvmName("yfxvpyjxppgyhhot")
    public suspend fun windowId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowId = mapped
    }

    internal fun build(): MaintenanceWindowTaskArgs = MaintenanceWindowTaskArgs(
        cutoffBehavior = cutoffBehavior,
        description = description,
        maxConcurrency = maxConcurrency,
        maxErrors = maxErrors,
        name = name,
        priority = priority,
        serviceRoleArn = serviceRoleArn,
        targets = targets,
        taskArn = taskArn,
        taskInvocationParameters = taskInvocationParameters,
        taskType = taskType,
        windowId = windowId,
    )
}
