@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineApprovalRule
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineGlobalFilter
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineSource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineApprovalRule.Companion.toKotlin as patchBaselineApprovalRuleToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineGlobalFilter.Companion.toKotlin as patchBaselineGlobalFilterToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineSource.Companion.toKotlin as patchBaselineSourceToKotlin

/**
 * Builder for [PatchBaseline].
 */
@PulumiTagMarker
public class PatchBaselineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PatchBaselineArgs = PatchBaselineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PatchBaselineArgsBuilder.() -> Unit) {
        val builder = PatchBaselineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PatchBaseline {
        val builtJavaResource = com.pulumi.aws.ssm.PatchBaseline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PatchBaseline(builtJavaResource)
    }
}

/**
 * Provides an SSM Patch Baseline resource.
 * > **NOTE on Patch Baselines:** The `approved_patches` and `approval_rule` are
 * both marked as optional fields, but the Patch Baseline requires that at least one
 * of them is specified.
 * ## Example Usage
 * ### Basic Usage
 * Using `approved_patches` only.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const production = new aws.ssm.PatchBaseline("production", {
 *     name: "patch-baseline",
 *     approvedPatches: ["KB123456"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * production = aws.ssm.PatchBaseline("production",
 *     name="patch-baseline",
 *     approved_patches=["KB123456"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var production = new Aws.Ssm.PatchBaseline("production", new()
 *     {
 *         Name = "patch-baseline",
 *         ApprovedPatches = new[]
 *         {
 *             "KB123456",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "production", &ssm.PatchBaselineArgs{
 * 			Name: pulumi.String("patch-baseline"),
 * 			ApprovedPatches: pulumi.StringArray{
 * 				pulumi.String("KB123456"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .name("patch-baseline")
 *             .approvedPatches("KB123456")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   production:
 *     type: aws:ssm:PatchBaseline
 *     properties:
 *       name: patch-baseline
 *       approvedPatches:
 *         - KB123456
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Advanced Usage, specifying patch filters
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const production = new aws.ssm.PatchBaseline("production", {
 *     name: "patch-baseline",
 *     description: "Patch Baseline Description",
 *     approvedPatches: [
 *         "KB123456",
 *         "KB456789",
 *     ],
 *     rejectedPatches: ["KB987654"],
 *     globalFilters: [
 *         {
 *             key: "PRODUCT",
 *             values: ["WindowsServer2008"],
 *         },
 *         {
 *             key: "CLASSIFICATION",
 *             values: ["ServicePacks"],
 *         },
 *         {
 *             key: "MSRC_SEVERITY",
 *             values: ["Low"],
 *         },
 *     ],
 *     approvalRules: [
 *         {
 *             approveAfterDays: 7,
 *             complianceLevel: "HIGH",
 *             patchFilters: [
 *                 {
 *                     key: "PRODUCT",
 *                     values: ["WindowsServer2016"],
 *                 },
 *                 {
 *                     key: "CLASSIFICATION",
 *                     values: [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                         "Updates",
 *                     ],
 *                 },
 *                 {
 *                     key: "MSRC_SEVERITY",
 *                     values: [
 *                         "Critical",
 *                         "Important",
 *                         "Moderate",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             approveAfterDays: 7,
 *             patchFilters: [{
 *                 key: "PRODUCT",
 *                 values: ["WindowsServer2012"],
 *             }],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * production = aws.ssm.PatchBaseline("production",
 *     name="patch-baseline",
 *     description="Patch Baseline Description",
 *     approved_patches=[
 *         "KB123456",
 *         "KB456789",
 *     ],
 *     rejected_patches=["KB987654"],
 *     global_filters=[
 *         {
 *             "key": "PRODUCT",
 *             "values": ["WindowsServer2008"],
 *         },
 *         {
 *             "key": "CLASSIFICATION",
 *             "values": ["ServicePacks"],
 *         },
 *         {
 *             "key": "MSRC_SEVERITY",
 *             "values": ["Low"],
 *         },
 *     ],
 *     approval_rules=[
 *         {
 *             "approve_after_days": 7,
 *             "compliance_level": "HIGH",
 *             "patch_filters": [
 *                 {
 *                     "key": "PRODUCT",
 *                     "values": ["WindowsServer2016"],
 *                 },
 *                 {
 *                     "key": "CLASSIFICATION",
 *                     "values": [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                         "Updates",
 *                     ],
 *                 },
 *                 {
 *                     "key": "MSRC_SEVERITY",
 *                     "values": [
 *                         "Critical",
 *                         "Important",
 *                         "Moderate",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             "approve_after_days": 7,
 *             "patch_filters": [{
 *                 "key": "PRODUCT",
 *                 "values": ["WindowsServer2012"],
 *             }],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var production = new Aws.Ssm.PatchBaseline("production", new()
 *     {
 *         Name = "patch-baseline",
 *         Description = "Patch Baseline Description",
 *         ApprovedPatches = new[]
 *         {
 *             "KB123456",
 *             "KB456789",
 *         },
 *         RejectedPatches = new[]
 *         {
 *             "KB987654",
 *         },
 *         GlobalFilters = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineGlobalFilterArgs
 *             {
 *                 Key = "PRODUCT",
 *                 Values = new[]
 *                 {
 *                     "WindowsServer2008",
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineGlobalFilterArgs
 *             {
 *                 Key = "CLASSIFICATION",
 *                 Values = new[]
 *                 {
 *                     "ServicePacks",
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineGlobalFilterArgs
 *             {
 *                 Key = "MSRC_SEVERITY",
 *                 Values = new[]
 *                 {
 *                     "Low",
 *                 },
 *             },
 *         },
 *         ApprovalRules = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 ComplianceLevel = "HIGH",
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PRODUCT",
 *                         Values = new[]
 *                         {
 *                             "WindowsServer2016",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "CLASSIFICATION",
 *                         Values = new[]
 *                         {
 *                             "CriticalUpdates",
 *                             "SecurityUpdates",
 *                             "Updates",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "MSRC_SEVERITY",
 *                         Values = new[]
 *                         {
 *                             "Critical",
 *                             "Important",
 *                             "Moderate",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PRODUCT",
 *                         Values = new[]
 *                         {
 *                             "WindowsServer2012",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "production", &ssm.PatchBaselineArgs{
 * 			Name:        pulumi.String("patch-baseline"),
 * 			Description: pulumi.String("Patch Baseline Description"),
 * 			ApprovedPatches: pulumi.StringArray{
 * 				pulumi.String("KB123456"),
 * 				pulumi.String("KB456789"),
 * 			},
 * 			RejectedPatches: pulumi.StringArray{
 * 				pulumi.String("KB987654"),
 * 			},
 * 			GlobalFilters: ssm.PatchBaselineGlobalFilterArray{
 * 				&ssm.PatchBaselineGlobalFilterArgs{
 * 					Key: pulumi.String("PRODUCT"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("WindowsServer2008"),
 * 					},
 * 				},
 * 				&ssm.PatchBaselineGlobalFilterArgs{
 * 					Key: pulumi.String("CLASSIFICATION"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("ServicePacks"),
 * 					},
 * 				},
 * 				&ssm.PatchBaselineGlobalFilterArgs{
 * 					Key: pulumi.String("MSRC_SEVERITY"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("Low"),
 * 					},
 * 				},
 * 			},
 * 			ApprovalRules: ssm.PatchBaselineApprovalRuleArray{
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					ComplianceLevel:  pulumi.String("HIGH"),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PRODUCT"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("WindowsServer2016"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("CLASSIFICATION"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("CriticalUpdates"),
 * 								pulumi.String("SecurityUpdates"),
 * 								pulumi.String("Updates"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("MSRC_SEVERITY"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("Critical"),
 * 								pulumi.String("Important"),
 * 								pulumi.String("Moderate"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PRODUCT"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("WindowsServer2012"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineGlobalFilterArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .name("patch-baseline")
 *             .description("Patch Baseline Description")
 *             .approvedPatches(
 *                 "KB123456",
 *                 "KB456789")
 *             .rejectedPatches("KB987654")
 *             .globalFilters(
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("PRODUCT")
 *                     .values("WindowsServer2008")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("CLASSIFICATION")
 *                     .values("ServicePacks")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("MSRC_SEVERITY")
 *                     .values("Low")
 *                     .build())
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .complianceLevel("HIGH")
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values("WindowsServer2016")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates",
 *                                 "Updates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important",
 *                                 "Moderate")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                         .key("PRODUCT")
 *                         .values("WindowsServer2012")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   production:
 *     type: aws:ssm:PatchBaseline
 *     properties:
 *       name: patch-baseline
 *       description: Patch Baseline Description
 *       approvedPatches:
 *         - KB123456
 *         - KB456789
 *       rejectedPatches:
 *         - KB987654
 *       globalFilters:
 *         - key: PRODUCT
 *           values:
 *             - WindowsServer2008
 *         - key: CLASSIFICATION
 *           values:
 *             - ServicePacks
 *         - key: MSRC_SEVERITY
 *           values:
 *             - Low
 *       approvalRules:
 *         - approveAfterDays: 7
 *           complianceLevel: HIGH
 *           patchFilters:
 *             - key: PRODUCT
 *               values:
 *                 - WindowsServer2016
 *             - key: CLASSIFICATION
 *               values:
 *                 - CriticalUpdates
 *                 - SecurityUpdates
 *                 - Updates
 *             - key: MSRC_SEVERITY
 *               values:
 *                 - Critical
 *                 - Important
 *                 - Moderate
 *         - approveAfterDays: 7
 *           patchFilters:
 *             - key: PRODUCT
 *               values:
 *                 - WindowsServer2012
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Advanced usage, specifying Microsoft application and Windows patch rules
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const windowsOsApps = new aws.ssm.PatchBaseline("windows_os_apps", {
 *     name: "WindowsOSAndMicrosoftApps",
 *     description: "Patch both Windows and Microsoft apps",
 *     operatingSystem: "WINDOWS",
 *     approvalRules: [
 *         {
 *             approveAfterDays: 7,
 *             patchFilters: [
 *                 {
 *                     key: "CLASSIFICATION",
 *                     values: [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                     ],
 *                 },
 *                 {
 *                     key: "MSRC_SEVERITY",
 *                     values: [
 *                         "Critical",
 *                         "Important",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             approveAfterDays: 7,
 *             patchFilters: [
 *                 {
 *                     key: "PATCH_SET",
 *                     values: ["APPLICATION"],
 *                 },
 *                 {
 *                     key: "PRODUCT",
 *                     values: [
 *                         "Office 2013",
 *                         "Office 2016",
 *                     ],
 *                 },
 *             ],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * windows_os_apps = aws.ssm.PatchBaseline("windows_os_apps",
 *     name="WindowsOSAndMicrosoftApps",
 *     description="Patch both Windows and Microsoft apps",
 *     operating_system="WINDOWS",
 *     approval_rules=[
 *         {
 *             "approve_after_days": 7,
 *             "patch_filters": [
 *                 {
 *                     "key": "CLASSIFICATION",
 *                     "values": [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                     ],
 *                 },
 *                 {
 *                     "key": "MSRC_SEVERITY",
 *                     "values": [
 *                         "Critical",
 *                         "Important",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             "approve_after_days": 7,
 *             "patch_filters": [
 *                 {
 *                     "key": "PATCH_SET",
 *                     "values": ["APPLICATION"],
 *                 },
 *                 {
 *                     "key": "PRODUCT",
 *                     "values": [
 *                         "Office 2013",
 *                         "Office 2016",
 *                     ],
 *                 },
 *             ],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var windowsOsApps = new Aws.Ssm.PatchBaseline("windows_os_apps", new()
 *     {
 *         Name = "WindowsOSAndMicrosoftApps",
 *         Description = "Patch both Windows and Microsoft apps",
 *         OperatingSystem = "WINDOWS",
 *         ApprovalRules = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "CLASSIFICATION",
 *                         Values = new[]
 *                         {
 *                             "CriticalUpdates",
 *                             "SecurityUpdates",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "MSRC_SEVERITY",
 *                         Values = new[]
 *                         {
 *                             "Critical",
 *                             "Important",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PATCH_SET",
 *                         Values = new[]
 *                         {
 *                             "APPLICATION",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PRODUCT",
 *                         Values = new[]
 *                         {
 *                             "Office 2013",
 *                             "Office 2016",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "windows_os_apps", &ssm.PatchBaselineArgs{
 * 			Name:            pulumi.String("WindowsOSAndMicrosoftApps"),
 * 			Description:     pulumi.String("Patch both Windows and Microsoft apps"),
 * 			OperatingSystem: pulumi.String("WINDOWS"),
 * 			ApprovalRules: ssm.PatchBaselineApprovalRuleArray{
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("CLASSIFICATION"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("CriticalUpdates"),
 * 								pulumi.String("SecurityUpdates"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("MSRC_SEVERITY"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("Critical"),
 * 								pulumi.String("Important"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PATCH_SET"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("APPLICATION"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PRODUCT"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("Office 2013"),
 * 								pulumi.String("Office 2016"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var windowsOsApps = new PatchBaseline("windowsOsApps", PatchBaselineArgs.builder()
 *             .name("WindowsOSAndMicrosoftApps")
 *             .description("Patch both Windows and Microsoft apps")
 *             .operatingSystem("WINDOWS")
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PATCH_SET")
 *                             .values("APPLICATION")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values(
 *                                 "Office 2013",
 *                                 "Office 2016")
 *                             .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   windowsOsApps:
 *     type: aws:ssm:PatchBaseline
 *     name: windows_os_apps
 *     properties:
 *       name: WindowsOSAndMicrosoftApps
 *       description: Patch both Windows and Microsoft apps
 *       operatingSystem: WINDOWS
 *       approvalRules:
 *         - approveAfterDays: 7
 *           patchFilters:
 *             - key: CLASSIFICATION
 *               values:
 *                 - CriticalUpdates
 *                 - SecurityUpdates
 *             - key: MSRC_SEVERITY
 *               values:
 *                 - Critical
 *                 - Important
 *         - approveAfterDays: 7
 *           patchFilters:
 *             - key: PATCH_SET
 *               values:
 *                 - APPLICATION
 *             - key: PRODUCT
 *               values:
 *                 - Office 2013
 *                 - Office 2016
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Advanced usage, specifying alternate patch source repository
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const al201709 = new aws.ssm.PatchBaseline("al_2017_09", {
 *     approvalRules: [{}],
 *     name: "Amazon-Linux-2017.09",
 *     description: "My patch repository for Amazon Linux 2017.09",
 *     operatingSystem: "AMAZON_LINUX",
 *     sources: [{
 *         name: "My-AL2017.09",
 *         products: ["AmazonLinux2017&#46;09"],
 *         configuration: `[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./awsregion./awsdomain//releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * `,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * al201709 = aws.ssm.PatchBaseline("al_2017_09",
 *     approval_rules=[{}],
 *     name="Amazon-Linux-2017.09",
 *     description="My patch repository for Amazon Linux 2017.09",
 *     operating_system="AMAZON_LINUX",
 *     sources=[{
 *         "name": "My-AL2017.09",
 *         "products": ["AmazonLinux2017&#46;09"],
 *         "configuration": """[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * """,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var al201709 = new Aws.Ssm.PatchBaseline("al_2017_09", new()
 *     {
 *         ApprovalRules = new[]
 *         {
 *             null,
 *         },
 *         Name = "Amazon-Linux-2017.09",
 *         Description = "My patch repository for Amazon Linux 2017.09",
 *         OperatingSystem = "AMAZON_LINUX",
 *         Sources = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineSourceArgs
 *             {
 *                 Name = "My-AL2017.09",
 *                 Products = new[]
 *                 {
 *                     "AmazonLinux2017.09",
 *                 },
 *                 Configuration = @"[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * ",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "al_2017_09", &ssm.PatchBaselineArgs{
 * 			ApprovalRules: ssm.PatchBaselineApprovalRuleArray{
 * 				nil,
 * 			},
 * 			Name:            pulumi.String("Amazon-Linux-2017.09"),
 * 			Description:     pulumi.String("My patch repository for Amazon Linux 2017.09"),
 * 			OperatingSystem: pulumi.String("AMAZON_LINUX"),
 * 			Sources: ssm.PatchBaselineSourceArray{
 * 				&ssm.PatchBaselineSourceArgs{
 * 					Name: pulumi.String("My-AL2017.09"),
 * 					Products: pulumi.StringArray{
 * 						pulumi.String("AmazonLinux2017.09"),
 * 					},
 * 					Configuration: pulumi.String(`[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * `),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var al201709 = new PatchBaseline("al201709", PatchBaselineArgs.builder()
 *             .approvalRules()
 *             .name("Amazon-Linux-2017.09")
 *             .description("My patch repository for Amazon Linux 2017.09")
 *             .operatingSystem("AMAZON_LINUX")
 *             .sources(PatchBaselineSourceArgs.builder()
 *                 .name("My-AL2017.09")
 *                 .products("AmazonLinux2017.09")
 *                 .configuration("""
 * [amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 *                 """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   al201709:
 *     type: aws:ssm:PatchBaseline
 *     name: al_2017_09
 *     properties:
 *       approvalRules:
 *         - {}
 *       name: Amazon-Linux-2017.09
 *       description: My patch repository for Amazon Linux 2017.09
 *       operatingSystem: AMAZON_LINUX
 *       sources:
 *         - name: My-AL2017.09
 *           products:
 *             - AmazonLinux2017.09
 *           configuration: |
 *             [amzn-main]
 *             name=amzn-main-Base
 *             mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 *             mirrorlist_expire=300
 *             metadata_expire=300
 *             priority=10
 *             failovermethod=priority
 *             fastestmirror_enabled=0
 *             gpgcheck=1
 *             gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 *             enabled=1
 *             retries=3
 *             timeout=5
 *             report_instanceid=yes
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSM Patch Baselines using their baseline ID. For example:
 * ```sh
 * $ pulumi import aws:ssm/patchBaseline:PatchBaseline example pb-12345678
 * ```
 */
public class PatchBaseline internal constructor(
    override val javaResource: com.pulumi.aws.ssm.PatchBaseline,
) : KotlinCustomResource(javaResource, PatchBaselineMapper) {
    /**
     * Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    public val approvalRules: Output<List<PatchBaselineApprovalRule>>?
        get() = javaResource.approvalRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        patchBaselineApprovalRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of explicitly approved patches for the baseline. Cannot be specified with `approval_rule`.
     */
    public val approvedPatches: Output<List<String>>?
        get() = javaResource.approvedPatches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`. The default value is `UNSPECIFIED`.
     */
    public val approvedPatchesComplianceLevel: Output<String>?
        get() = javaResource.approvedPatchesComplianceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the list of approved patches includes non-security updates that should be applied to the instances. Applies to Linux instances only.
     */
    public val approvedPatchesEnableNonSecurity: Output<Boolean>?
        get() = javaResource.approvedPatchesEnableNonSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the baseline.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the patch baseline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    public val globalFilters: Output<List<PatchBaselineGlobalFilter>>?
        get() = javaResource.globalFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        patchBaselineGlobalFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * JSON definition of the baseline.
     */
    public val json: Output<String>
        get() = javaResource.json().applyValue({ args0 -> args0 })

    /**
     * Name of the patch baseline.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operating system the patch baseline applies to. Valid values are `ALMA_LINUX`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `AMAZON_LINUX_2022`, `AMAZON_LINUX_2023`, `CENTOS`, `DEBIAN`, `MACOS`, `ORACLE_LINUX`, `RASPBIAN`, `REDHAT_ENTERPRISE_LINUX`, `ROCKY_LINUX`, `SUSE`, `UBUNTU`, and `WINDOWS`. The default value is `WINDOWS`.
     */
    public val operatingSystem: Output<String>?
        get() = javaResource.operatingSystem().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of rejected patches.
     */
    public val rejectedPatches: Output<List<String>>?
        get() = javaResource.rejectedPatches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Action for Patch Manager to take on patches included in the `rejected_patches` list. Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
     */
    public val rejectedPatchesAction: Output<String>
        get() = javaResource.rejectedPatchesAction().applyValue({ args0 -> args0 })

    /**
     * Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    public val sources: Output<List<PatchBaselineSource>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> patchBaselineSourceToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PatchBaselineMapper : ResourceMapper<PatchBaseline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.PatchBaseline::class == javaResource::class

    override fun map(javaResource: Resource): PatchBaseline = PatchBaseline(
        javaResource as
            com.pulumi.aws.ssm.PatchBaseline,
    )
}

/**
 * @see [PatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PatchBaseline].
 */
public suspend fun patchBaseline(
    name: String,
    block: suspend PatchBaselineResourceBuilder.() -> Unit,
): PatchBaseline {
    val builder = PatchBaselineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun patchBaseline(name: String): PatchBaseline {
    val builder = PatchBaselineResourceBuilder()
    builder.name(name)
    return builder.build()
}
