@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.PatchBaselineArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineApprovalRuleArgs
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineApprovalRuleArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineGlobalFilterArgs
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineGlobalFilterArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineSourceArgs
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an SSM Patch Baseline resource.
 * > **NOTE on Patch Baselines:** The `approved_patches` and `approval_rule` are
 * both marked as optional fields, but the Patch Baseline requires that at least one
 * of them is specified.
 * ## Example Usage
 * ### Basic Usage
 * Using `approved_patches` only.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const production = new aws.ssm.PatchBaseline("production", {
 *     name: "patch-baseline",
 *     approvedPatches: ["KB123456"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * production = aws.ssm.PatchBaseline("production",
 *     name="patch-baseline",
 *     approved_patches=["KB123456"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var production = new Aws.Ssm.PatchBaseline("production", new()
 *     {
 *         Name = "patch-baseline",
 *         ApprovedPatches = new[]
 *         {
 *             "KB123456",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "production", &ssm.PatchBaselineArgs{
 * 			Name: pulumi.String("patch-baseline"),
 * 			ApprovedPatches: pulumi.StringArray{
 * 				pulumi.String("KB123456"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .name("patch-baseline")
 *             .approvedPatches("KB123456")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   production:
 *     type: aws:ssm:PatchBaseline
 *     properties:
 *       name: patch-baseline
 *       approvedPatches:
 *         - KB123456
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Advanced Usage, specifying patch filters
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const production = new aws.ssm.PatchBaseline("production", {
 *     name: "patch-baseline",
 *     description: "Patch Baseline Description",
 *     approvedPatches: [
 *         "KB123456",
 *         "KB456789",
 *     ],
 *     rejectedPatches: ["KB987654"],
 *     globalFilters: [
 *         {
 *             key: "PRODUCT",
 *             values: ["WindowsServer2008"],
 *         },
 *         {
 *             key: "CLASSIFICATION",
 *             values: ["ServicePacks"],
 *         },
 *         {
 *             key: "MSRC_SEVERITY",
 *             values: ["Low"],
 *         },
 *     ],
 *     approvalRules: [
 *         {
 *             approveAfterDays: 7,
 *             complianceLevel: "HIGH",
 *             patchFilters: [
 *                 {
 *                     key: "PRODUCT",
 *                     values: ["WindowsServer2016"],
 *                 },
 *                 {
 *                     key: "CLASSIFICATION",
 *                     values: [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                         "Updates",
 *                     ],
 *                 },
 *                 {
 *                     key: "MSRC_SEVERITY",
 *                     values: [
 *                         "Critical",
 *                         "Important",
 *                         "Moderate",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             approveAfterDays: 7,
 *             patchFilters: [{
 *                 key: "PRODUCT",
 *                 values: ["WindowsServer2012"],
 *             }],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * production = aws.ssm.PatchBaseline("production",
 *     name="patch-baseline",
 *     description="Patch Baseline Description",
 *     approved_patches=[
 *         "KB123456",
 *         "KB456789",
 *     ],
 *     rejected_patches=["KB987654"],
 *     global_filters=[
 *         {
 *             "key": "PRODUCT",
 *             "values": ["WindowsServer2008"],
 *         },
 *         {
 *             "key": "CLASSIFICATION",
 *             "values": ["ServicePacks"],
 *         },
 *         {
 *             "key": "MSRC_SEVERITY",
 *             "values": ["Low"],
 *         },
 *     ],
 *     approval_rules=[
 *         {
 *             "approve_after_days": 7,
 *             "compliance_level": "HIGH",
 *             "patch_filters": [
 *                 {
 *                     "key": "PRODUCT",
 *                     "values": ["WindowsServer2016"],
 *                 },
 *                 {
 *                     "key": "CLASSIFICATION",
 *                     "values": [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                         "Updates",
 *                     ],
 *                 },
 *                 {
 *                     "key": "MSRC_SEVERITY",
 *                     "values": [
 *                         "Critical",
 *                         "Important",
 *                         "Moderate",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             "approve_after_days": 7,
 *             "patch_filters": [{
 *                 "key": "PRODUCT",
 *                 "values": ["WindowsServer2012"],
 *             }],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var production = new Aws.Ssm.PatchBaseline("production", new()
 *     {
 *         Name = "patch-baseline",
 *         Description = "Patch Baseline Description",
 *         ApprovedPatches = new[]
 *         {
 *             "KB123456",
 *             "KB456789",
 *         },
 *         RejectedPatches = new[]
 *         {
 *             "KB987654",
 *         },
 *         GlobalFilters = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineGlobalFilterArgs
 *             {
 *                 Key = "PRODUCT",
 *                 Values = new[]
 *                 {
 *                     "WindowsServer2008",
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineGlobalFilterArgs
 *             {
 *                 Key = "CLASSIFICATION",
 *                 Values = new[]
 *                 {
 *                     "ServicePacks",
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineGlobalFilterArgs
 *             {
 *                 Key = "MSRC_SEVERITY",
 *                 Values = new[]
 *                 {
 *                     "Low",
 *                 },
 *             },
 *         },
 *         ApprovalRules = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 ComplianceLevel = "HIGH",
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PRODUCT",
 *                         Values = new[]
 *                         {
 *                             "WindowsServer2016",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "CLASSIFICATION",
 *                         Values = new[]
 *                         {
 *                             "CriticalUpdates",
 *                             "SecurityUpdates",
 *                             "Updates",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "MSRC_SEVERITY",
 *                         Values = new[]
 *                         {
 *                             "Critical",
 *                             "Important",
 *                             "Moderate",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PRODUCT",
 *                         Values = new[]
 *                         {
 *                             "WindowsServer2012",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "production", &ssm.PatchBaselineArgs{
 * 			Name:        pulumi.String("patch-baseline"),
 * 			Description: pulumi.String("Patch Baseline Description"),
 * 			ApprovedPatches: pulumi.StringArray{
 * 				pulumi.String("KB123456"),
 * 				pulumi.String("KB456789"),
 * 			},
 * 			RejectedPatches: pulumi.StringArray{
 * 				pulumi.String("KB987654"),
 * 			},
 * 			GlobalFilters: ssm.PatchBaselineGlobalFilterArray{
 * 				&ssm.PatchBaselineGlobalFilterArgs{
 * 					Key: pulumi.String("PRODUCT"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("WindowsServer2008"),
 * 					},
 * 				},
 * 				&ssm.PatchBaselineGlobalFilterArgs{
 * 					Key: pulumi.String("CLASSIFICATION"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("ServicePacks"),
 * 					},
 * 				},
 * 				&ssm.PatchBaselineGlobalFilterArgs{
 * 					Key: pulumi.String("MSRC_SEVERITY"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("Low"),
 * 					},
 * 				},
 * 			},
 * 			ApprovalRules: ssm.PatchBaselineApprovalRuleArray{
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					ComplianceLevel:  pulumi.String("HIGH"),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PRODUCT"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("WindowsServer2016"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("CLASSIFICATION"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("CriticalUpdates"),
 * 								pulumi.String("SecurityUpdates"),
 * 								pulumi.String("Updates"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("MSRC_SEVERITY"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("Critical"),
 * 								pulumi.String("Important"),
 * 								pulumi.String("Moderate"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PRODUCT"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("WindowsServer2012"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineGlobalFilterArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .name("patch-baseline")
 *             .description("Patch Baseline Description")
 *             .approvedPatches(
 *                 "KB123456",
 *                 "KB456789")
 *             .rejectedPatches("KB987654")
 *             .globalFilters(
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("PRODUCT")
 *                     .values("WindowsServer2008")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("CLASSIFICATION")
 *                     .values("ServicePacks")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("MSRC_SEVERITY")
 *                     .values("Low")
 *                     .build())
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .complianceLevel("HIGH")
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values("WindowsServer2016")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates",
 *                                 "Updates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important",
 *                                 "Moderate")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                         .key("PRODUCT")
 *                         .values("WindowsServer2012")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   production:
 *     type: aws:ssm:PatchBaseline
 *     properties:
 *       name: patch-baseline
 *       description: Patch Baseline Description
 *       approvedPatches:
 *         - KB123456
 *         - KB456789
 *       rejectedPatches:
 *         - KB987654
 *       globalFilters:
 *         - key: PRODUCT
 *           values:
 *             - WindowsServer2008
 *         - key: CLASSIFICATION
 *           values:
 *             - ServicePacks
 *         - key: MSRC_SEVERITY
 *           values:
 *             - Low
 *       approvalRules:
 *         - approveAfterDays: 7
 *           complianceLevel: HIGH
 *           patchFilters:
 *             - key: PRODUCT
 *               values:
 *                 - WindowsServer2016
 *             - key: CLASSIFICATION
 *               values:
 *                 - CriticalUpdates
 *                 - SecurityUpdates
 *                 - Updates
 *             - key: MSRC_SEVERITY
 *               values:
 *                 - Critical
 *                 - Important
 *                 - Moderate
 *         - approveAfterDays: 7
 *           patchFilters:
 *             - key: PRODUCT
 *               values:
 *                 - WindowsServer2012
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Advanced usage, specifying Microsoft application and Windows patch rules
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const windowsOsApps = new aws.ssm.PatchBaseline("windows_os_apps", {
 *     name: "WindowsOSAndMicrosoftApps",
 *     description: "Patch both Windows and Microsoft apps",
 *     operatingSystem: "WINDOWS",
 *     approvalRules: [
 *         {
 *             approveAfterDays: 7,
 *             patchFilters: [
 *                 {
 *                     key: "CLASSIFICATION",
 *                     values: [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                     ],
 *                 },
 *                 {
 *                     key: "MSRC_SEVERITY",
 *                     values: [
 *                         "Critical",
 *                         "Important",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             approveAfterDays: 7,
 *             patchFilters: [
 *                 {
 *                     key: "PATCH_SET",
 *                     values: ["APPLICATION"],
 *                 },
 *                 {
 *                     key: "PRODUCT",
 *                     values: [
 *                         "Office 2013",
 *                         "Office 2016",
 *                     ],
 *                 },
 *             ],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * windows_os_apps = aws.ssm.PatchBaseline("windows_os_apps",
 *     name="WindowsOSAndMicrosoftApps",
 *     description="Patch both Windows and Microsoft apps",
 *     operating_system="WINDOWS",
 *     approval_rules=[
 *         {
 *             "approve_after_days": 7,
 *             "patch_filters": [
 *                 {
 *                     "key": "CLASSIFICATION",
 *                     "values": [
 *                         "CriticalUpdates",
 *                         "SecurityUpdates",
 *                     ],
 *                 },
 *                 {
 *                     "key": "MSRC_SEVERITY",
 *                     "values": [
 *                         "Critical",
 *                         "Important",
 *                     ],
 *                 },
 *             ],
 *         },
 *         {
 *             "approve_after_days": 7,
 *             "patch_filters": [
 *                 {
 *                     "key": "PATCH_SET",
 *                     "values": ["APPLICATION"],
 *                 },
 *                 {
 *                     "key": "PRODUCT",
 *                     "values": [
 *                         "Office 2013",
 *                         "Office 2016",
 *                     ],
 *                 },
 *             ],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var windowsOsApps = new Aws.Ssm.PatchBaseline("windows_os_apps", new()
 *     {
 *         Name = "WindowsOSAndMicrosoftApps",
 *         Description = "Patch both Windows and Microsoft apps",
 *         OperatingSystem = "WINDOWS",
 *         ApprovalRules = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "CLASSIFICATION",
 *                         Values = new[]
 *                         {
 *                             "CriticalUpdates",
 *                             "SecurityUpdates",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "MSRC_SEVERITY",
 *                         Values = new[]
 *                         {
 *                             "Critical",
 *                             "Important",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Ssm.Inputs.PatchBaselineApprovalRuleArgs
 *             {
 *                 ApproveAfterDays = 7,
 *                 PatchFilters = new[]
 *                 {
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PATCH_SET",
 *                         Values = new[]
 *                         {
 *                             "APPLICATION",
 *                         },
 *                     },
 *                     new Aws.Ssm.Inputs.PatchBaselineApprovalRulePatchFilterArgs
 *                     {
 *                         Key = "PRODUCT",
 *                         Values = new[]
 *                         {
 *                             "Office 2013",
 *                             "Office 2016",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "windows_os_apps", &ssm.PatchBaselineArgs{
 * 			Name:            pulumi.String("WindowsOSAndMicrosoftApps"),
 * 			Description:     pulumi.String("Patch both Windows and Microsoft apps"),
 * 			OperatingSystem: pulumi.String("WINDOWS"),
 * 			ApprovalRules: ssm.PatchBaselineApprovalRuleArray{
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("CLASSIFICATION"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("CriticalUpdates"),
 * 								pulumi.String("SecurityUpdates"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("MSRC_SEVERITY"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("Critical"),
 * 								pulumi.String("Important"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&ssm.PatchBaselineApprovalRuleArgs{
 * 					ApproveAfterDays: pulumi.Int(7),
 * 					PatchFilters: ssm.PatchBaselineApprovalRulePatchFilterArray{
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PATCH_SET"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("APPLICATION"),
 * 							},
 * 						},
 * 						&ssm.PatchBaselineApprovalRulePatchFilterArgs{
 * 							Key: pulumi.String("PRODUCT"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("Office 2013"),
 * 								pulumi.String("Office 2016"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var windowsOsApps = new PatchBaseline("windowsOsApps", PatchBaselineArgs.builder()
 *             .name("WindowsOSAndMicrosoftApps")
 *             .description("Patch both Windows and Microsoft apps")
 *             .operatingSystem("WINDOWS")
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PATCH_SET")
 *                             .values("APPLICATION")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values(
 *                                 "Office 2013",
 *                                 "Office 2016")
 *                             .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   windowsOsApps:
 *     type: aws:ssm:PatchBaseline
 *     name: windows_os_apps
 *     properties:
 *       name: WindowsOSAndMicrosoftApps
 *       description: Patch both Windows and Microsoft apps
 *       operatingSystem: WINDOWS
 *       approvalRules:
 *         - approveAfterDays: 7
 *           patchFilters:
 *             - key: CLASSIFICATION
 *               values:
 *                 - CriticalUpdates
 *                 - SecurityUpdates
 *             - key: MSRC_SEVERITY
 *               values:
 *                 - Critical
 *                 - Important
 *         - approveAfterDays: 7
 *           patchFilters:
 *             - key: PATCH_SET
 *               values:
 *                 - APPLICATION
 *             - key: PRODUCT
 *               values:
 *                 - Office 2013
 *                 - Office 2016
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Advanced usage, specifying alternate patch source repository
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const al201709 = new aws.ssm.PatchBaseline("al_2017_09", {
 *     approvalRules: [{}],
 *     name: "Amazon-Linux-2017.09",
 *     description: "My patch repository for Amazon Linux 2017.09",
 *     operatingSystem: "AMAZON_LINUX",
 *     sources: [{
 *         name: "My-AL2017.09",
 *         products: ["AmazonLinux2017&#46;09"],
 *         configuration: `[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./awsregion./awsdomain//releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * `,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * al201709 = aws.ssm.PatchBaseline("al_2017_09",
 *     approval_rules=[{}],
 *     name="Amazon-Linux-2017.09",
 *     description="My patch repository for Amazon Linux 2017.09",
 *     operating_system="AMAZON_LINUX",
 *     sources=[{
 *         "name": "My-AL2017.09",
 *         "products": ["AmazonLinux2017&#46;09"],
 *         "configuration": """[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * """,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var al201709 = new Aws.Ssm.PatchBaseline("al_2017_09", new()
 *     {
 *         ApprovalRules = new[]
 *         {
 *             null,
 *         },
 *         Name = "Amazon-Linux-2017.09",
 *         Description = "My patch repository for Amazon Linux 2017.09",
 *         OperatingSystem = "AMAZON_LINUX",
 *         Sources = new[]
 *         {
 *             new Aws.Ssm.Inputs.PatchBaselineSourceArgs
 *             {
 *                 Name = "My-AL2017.09",
 *                 Products = new[]
 *                 {
 *                     "AmazonLinux2017.09",
 *                 },
 *                 Configuration = @"[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * ",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewPatchBaseline(ctx, "al_2017_09", &ssm.PatchBaselineArgs{
 * 			ApprovalRules: ssm.PatchBaselineApprovalRuleArray{
 * 				nil,
 * 			},
 * 			Name:            pulumi.String("Amazon-Linux-2017.09"),
 * 			Description:     pulumi.String("My patch repository for Amazon Linux 2017.09"),
 * 			OperatingSystem: pulumi.String("AMAZON_LINUX"),
 * 			Sources: ssm.PatchBaselineSourceArray{
 * 				&ssm.PatchBaselineSourceArgs{
 * 					Name: pulumi.String("My-AL2017.09"),
 * 					Products: pulumi.StringArray{
 * 						pulumi.String("AmazonLinux2017.09"),
 * 					},
 * 					Configuration: pulumi.String(`[amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 * `),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var al201709 = new PatchBaseline("al201709", PatchBaselineArgs.builder()
 *             .approvalRules()
 *             .name("Amazon-Linux-2017.09")
 *             .description("My patch repository for Amazon Linux 2017.09")
 *             .operatingSystem("AMAZON_LINUX")
 *             .sources(PatchBaselineSourceArgs.builder()
 *                 .name("My-AL2017.09")
 *                 .products("AmazonLinux2017.09")
 *                 .configuration("""
 * [amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 *                 """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   al201709:
 *     type: aws:ssm:PatchBaseline
 *     name: al_2017_09
 *     properties:
 *       approvalRules:
 *         - {}
 *       name: Amazon-Linux-2017.09
 *       description: My patch repository for Amazon Linux 2017.09
 *       operatingSystem: AMAZON_LINUX
 *       sources:
 *         - name: My-AL2017.09
 *           products:
 *             - AmazonLinux2017.09
 *           configuration: |
 *             [amzn-main]
 *             name=amzn-main-Base
 *             mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 *             mirrorlist_expire=300
 *             metadata_expire=300
 *             priority=10
 *             failovermethod=priority
 *             fastestmirror_enabled=0
 *             gpgcheck=1
 *             gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 *             enabled=1
 *             retries=3
 *             timeout=5
 *             report_instanceid=yes
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSM Patch Baselines using their baseline ID. For example:
 * ```sh
 * $ pulumi import aws:ssm/patchBaseline:PatchBaseline example pb-12345678
 * ```
 * @property approvalRules Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
 * @property approvedPatches List of explicitly approved patches for the baseline. Cannot be specified with `approval_rule`.
 * @property approvedPatchesComplianceLevel Compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`. The default value is `UNSPECIFIED`.
 * @property approvedPatchesEnableNonSecurity Whether the list of approved patches includes non-security updates that should be applied to the instances. Applies to Linux instances only.
 * @property description Description of the patch baseline.
 * @property globalFilters Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
 * @property name Name of the patch baseline.
 * The following arguments are optional:
 * @property operatingSystem Operating system the patch baseline applies to. Valid values are `ALMA_LINUX`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `AMAZON_LINUX_2022`, `AMAZON_LINUX_2023`, `CENTOS`, `DEBIAN`, `MACOS`, `ORACLE_LINUX`, `RASPBIAN`, `REDHAT_ENTERPRISE_LINUX`, `ROCKY_LINUX`, `SUSE`, `UBUNTU`, and `WINDOWS`. The default value is `WINDOWS`.
 * @property rejectedPatches List of rejected patches.
 * @property rejectedPatchesAction Action for Patch Manager to take on patches included in the `rejected_patches` list. Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
 * @property sources Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PatchBaselineArgs(
    public val approvalRules: Output<List<PatchBaselineApprovalRuleArgs>>? = null,
    public val approvedPatches: Output<List<String>>? = null,
    public val approvedPatchesComplianceLevel: Output<String>? = null,
    public val approvedPatchesEnableNonSecurity: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val globalFilters: Output<List<PatchBaselineGlobalFilterArgs>>? = null,
    public val name: Output<String>? = null,
    public val operatingSystem: Output<String>? = null,
    public val rejectedPatches: Output<List<String>>? = null,
    public val rejectedPatchesAction: Output<String>? = null,
    public val sources: Output<List<PatchBaselineSourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.PatchBaselineArgs> {
    override fun toJava(): com.pulumi.aws.ssm.PatchBaselineArgs =
        com.pulumi.aws.ssm.PatchBaselineArgs.builder()
            .approvalRules(
                approvalRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .approvedPatches(approvedPatches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .approvedPatchesComplianceLevel(approvedPatchesComplianceLevel?.applyValue({ args0 -> args0 }))
            .approvedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .globalFilters(
                globalFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .operatingSystem(operatingSystem?.applyValue({ args0 -> args0 }))
            .rejectedPatches(rejectedPatches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .rejectedPatchesAction(rejectedPatchesAction?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PatchBaselineArgs].
 */
@PulumiTagMarker
public class PatchBaselineArgsBuilder internal constructor() {
    private var approvalRules: Output<List<PatchBaselineApprovalRuleArgs>>? = null

    private var approvedPatches: Output<List<String>>? = null

    private var approvedPatchesComplianceLevel: Output<String>? = null

    private var approvedPatchesEnableNonSecurity: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var globalFilters: Output<List<PatchBaselineGlobalFilterArgs>>? = null

    private var name: Output<String>? = null

    private var operatingSystem: Output<String>? = null

    private var rejectedPatches: Output<List<String>>? = null

    private var rejectedPatchesAction: Output<String>? = null

    private var sources: Output<List<PatchBaselineSourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    @JvmName("yumwrokpibwiolbj")
    public suspend fun approvalRules(`value`: Output<List<PatchBaselineApprovalRuleArgs>>) {
        this.approvalRules = value
    }

    @JvmName("gxlovxlruwooyxbd")
    public suspend fun approvalRules(vararg values: Output<PatchBaselineApprovalRuleArgs>) {
        this.approvalRules = Output.all(values.asList())
    }

    /**
     * @param values Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    @JvmName("agafkiswekdyhxbg")
    public suspend fun approvalRules(values: List<Output<PatchBaselineApprovalRuleArgs>>) {
        this.approvalRules = Output.all(values)
    }

    /**
     * @param value List of explicitly approved patches for the baseline. Cannot be specified with `approval_rule`.
     */
    @JvmName("xqtufollfrncaxhf")
    public suspend fun approvedPatches(`value`: Output<List<String>>) {
        this.approvedPatches = value
    }

    @JvmName("tdgwgydausdbcedf")
    public suspend fun approvedPatches(vararg values: Output<String>) {
        this.approvedPatches = Output.all(values.asList())
    }

    /**
     * @param values List of explicitly approved patches for the baseline. Cannot be specified with `approval_rule`.
     */
    @JvmName("qixsqoputepxgupl")
    public suspend fun approvedPatches(values: List<Output<String>>) {
        this.approvedPatches = Output.all(values)
    }

    /**
     * @param value Compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`. The default value is `UNSPECIFIED`.
     */
    @JvmName("jmigmahjurmkhvdy")
    public suspend fun approvedPatchesComplianceLevel(`value`: Output<String>) {
        this.approvedPatchesComplianceLevel = value
    }

    /**
     * @param value Whether the list of approved patches includes non-security updates that should be applied to the instances. Applies to Linux instances only.
     */
    @JvmName("olmudymbeplfmpys")
    public suspend fun approvedPatchesEnableNonSecurity(`value`: Output<Boolean>) {
        this.approvedPatchesEnableNonSecurity = value
    }

    /**
     * @param value Description of the patch baseline.
     */
    @JvmName("ihmwfjgcxrxtnudq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("wlccgpwhpjatqwep")
    public suspend fun globalFilters(`value`: Output<List<PatchBaselineGlobalFilterArgs>>) {
        this.globalFilters = value
    }

    @JvmName("wfakgipqxhipaqqq")
    public suspend fun globalFilters(vararg values: Output<PatchBaselineGlobalFilterArgs>) {
        this.globalFilters = Output.all(values.asList())
    }

    /**
     * @param values Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("tygnkfcidgcjqnwp")
    public suspend fun globalFilters(values: List<Output<PatchBaselineGlobalFilterArgs>>) {
        this.globalFilters = Output.all(values)
    }

    /**
     * @param value Name of the patch baseline.
     * The following arguments are optional:
     */
    @JvmName("bamcxjmduwbnydii")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Operating system the patch baseline applies to. Valid values are `ALMA_LINUX`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `AMAZON_LINUX_2022`, `AMAZON_LINUX_2023`, `CENTOS`, `DEBIAN`, `MACOS`, `ORACLE_LINUX`, `RASPBIAN`, `REDHAT_ENTERPRISE_LINUX`, `ROCKY_LINUX`, `SUSE`, `UBUNTU`, and `WINDOWS`. The default value is `WINDOWS`.
     */
    @JvmName("dtgyylowvvmolyrm")
    public suspend fun operatingSystem(`value`: Output<String>) {
        this.operatingSystem = value
    }

    /**
     * @param value List of rejected patches.
     */
    @JvmName("cxyjiwbrixvlpkak")
    public suspend fun rejectedPatches(`value`: Output<List<String>>) {
        this.rejectedPatches = value
    }

    @JvmName("enqfpcipopadgoit")
    public suspend fun rejectedPatches(vararg values: Output<String>) {
        this.rejectedPatches = Output.all(values.asList())
    }

    /**
     * @param values List of rejected patches.
     */
    @JvmName("wxnsrecqrssntwvv")
    public suspend fun rejectedPatches(values: List<Output<String>>) {
        this.rejectedPatches = Output.all(values)
    }

    /**
     * @param value Action for Patch Manager to take on patches included in the `rejected_patches` list. Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
     */
    @JvmName("nejhuqhskivgbajh")
    public suspend fun rejectedPatchesAction(`value`: Output<String>) {
        this.rejectedPatchesAction = value
    }

    /**
     * @param value Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    @JvmName("qbhqoujrsngkjbna")
    public suspend fun sources(`value`: Output<List<PatchBaselineSourceArgs>>) {
        this.sources = value
    }

    @JvmName("xexjsolqvvuetrse")
    public suspend fun sources(vararg values: Output<PatchBaselineSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    @JvmName("duesjxoeaiqhkvim")
    public suspend fun sources(values: List<Output<PatchBaselineSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tannqmapmaotvbry")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    @JvmName("varmktipkvttownr")
    public suspend fun approvalRules(`value`: List<PatchBaselineApprovalRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param argument Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    @JvmName("ukulqhlxrtwceibs")
    public suspend fun approvalRules(argument: List<suspend PatchBaselineApprovalRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PatchBaselineApprovalRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    @JvmName("qmkuwnpqfbdeptld")
    public suspend fun approvalRules(vararg argument: suspend PatchBaselineApprovalRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PatchBaselineApprovalRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    @JvmName("mkllkhidcudmdyfo")
    public suspend fun approvalRules(argument: suspend PatchBaselineApprovalRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PatchBaselineApprovalRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param values Set of rules used to include patches in the baseline. Up to 10 approval rules can be specified. See `approval_rule` below.
     */
    @JvmName("rddfbrythrbwvguo")
    public suspend fun approvalRules(vararg values: PatchBaselineApprovalRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param value List of explicitly approved patches for the baseline. Cannot be specified with `approval_rule`.
     */
    @JvmName("gfnifkuuofeipfak")
    public suspend fun approvedPatches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatches = mapped
    }

    /**
     * @param values List of explicitly approved patches for the baseline. Cannot be specified with `approval_rule`.
     */
    @JvmName("aqdoysqwnhisukcg")
    public suspend fun approvedPatches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.approvedPatches = mapped
    }

    /**
     * @param value Compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`. The default value is `UNSPECIFIED`.
     */
    @JvmName("ywdabiyptvcgvxks")
    public suspend fun approvedPatchesComplianceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatchesComplianceLevel = mapped
    }

    /**
     * @param value Whether the list of approved patches includes non-security updates that should be applied to the instances. Applies to Linux instances only.
     */
    @JvmName("uyllgyhyyjaqnkjt")
    public suspend fun approvedPatchesEnableNonSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatchesEnableNonSecurity = mapped
    }

    /**
     * @param value Description of the patch baseline.
     */
    @JvmName("wwnqfxtcqqwjeusn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("nycwbcxtradlabim")
    public suspend fun globalFilters(`value`: List<PatchBaselineGlobalFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalFilters = mapped
    }

    /**
     * @param argument Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("uhweruypvxpnruox")
    public suspend fun globalFilters(argument: List<suspend PatchBaselineGlobalFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PatchBaselineGlobalFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.globalFilters = mapped
    }

    /**
     * @param argument Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("qilyopctpdaywgxj")
    public suspend fun globalFilters(vararg argument: suspend PatchBaselineGlobalFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PatchBaselineGlobalFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.globalFilters = mapped
    }

    /**
     * @param argument Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("nfqgooigoavctcxl")
    public suspend fun globalFilters(argument: suspend PatchBaselineGlobalFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PatchBaselineGlobalFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.globalFilters = mapped
    }

    /**
     * @param values Set of global filters used to exclude patches from the baseline. Up to 4 global filters can be specified using Key/Value pairs. Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("puxkxgvidfjweqlp")
    public suspend fun globalFilters(vararg values: PatchBaselineGlobalFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.globalFilters = mapped
    }

    /**
     * @param value Name of the patch baseline.
     * The following arguments are optional:
     */
    @JvmName("dftypncfyhdxsqev")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Operating system the patch baseline applies to. Valid values are `ALMA_LINUX`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `AMAZON_LINUX_2022`, `AMAZON_LINUX_2023`, `CENTOS`, `DEBIAN`, `MACOS`, `ORACLE_LINUX`, `RASPBIAN`, `REDHAT_ENTERPRISE_LINUX`, `ROCKY_LINUX`, `SUSE`, `UBUNTU`, and `WINDOWS`. The default value is `WINDOWS`.
     */
    @JvmName("guoxkjuhvfdinjxs")
    public suspend fun operatingSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystem = mapped
    }

    /**
     * @param value List of rejected patches.
     */
    @JvmName("ebiotnkjvmfvteos")
    public suspend fun rejectedPatches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectedPatches = mapped
    }

    /**
     * @param values List of rejected patches.
     */
    @JvmName("fsvhktrrlidstdor")
    public suspend fun rejectedPatches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rejectedPatches = mapped
    }

    /**
     * @param value Action for Patch Manager to take on patches included in the `rejected_patches` list. Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
     */
    @JvmName("xbptvhggjivpfymq")
    public suspend fun rejectedPatchesAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectedPatchesAction = mapped
    }

    /**
     * @param value Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    @JvmName("fhhvaiguqgoelhjx")
    public suspend fun sources(`value`: List<PatchBaselineSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    @JvmName("stvfvahpkmfkqcex")
    public suspend fun sources(argument: List<suspend PatchBaselineSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PatchBaselineSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    @JvmName("yvpqmdpgpnpefaht")
    public suspend fun sources(vararg argument: suspend PatchBaselineSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PatchBaselineSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    @JvmName("vjawrevphegblhnn")
    public suspend fun sources(argument: suspend PatchBaselineSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PatchBaselineSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values Configuration block with alternate sources for patches. Applies to Linux instances only. See `source` below.
     */
    @JvmName("uhjkwayekjbjhrpx")
    public suspend fun sources(vararg values: PatchBaselineSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tnerkwfgtyqybdhq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fqjekjljmonoiutj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PatchBaselineArgs = PatchBaselineArgs(
        approvalRules = approvalRules,
        approvedPatches = approvedPatches,
        approvedPatchesComplianceLevel = approvedPatchesComplianceLevel,
        approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity,
        description = description,
        globalFilters = globalFilters,
        name = name,
        operatingSystem = operatingSystem,
        rejectedPatches = rejectedPatches,
        rejectedPatchesAction = rejectedPatchesAction,
        sources = sources,
        tags = tags,
    )
}
