@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.ResourceDataSyncArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.ResourceDataSyncS3DestinationArgs
import com.pulumi.aws.ssm.kotlin.inputs.ResourceDataSyncS3DestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a SSM resource data sync.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const hogeBucketV2 = new aws.s3.BucketV2("hoge", {bucket: "tf-test-bucket-1234"});
 * const hoge = aws.iam.getPolicyDocument({
 *     statements: [
 *         {
 *             sid: "SSMBucketPermissionsCheck",
 *             effect: "Allow",
 *             principals: [{
 *                 type: "Service",
 *                 identifiers: ["ssm&#46;amazonaws&#46;com"],
 *             }],
 *             actions: ["s3:GetBucketAcl"],
 *             resources: ["arn:aws:s3:::tf-test-bucket-1234"],
 *         },
 *         {
 *             sid: "SSMBucketDelivery",
 *             effect: "Allow",
 *             principals: [{
 *                 type: "Service",
 *                 identifiers: ["ssm&#46;amazonaws&#46;com"],
 *             }],
 *             actions: ["s3:PutObject"],
 *             resources: ["arn:aws:s3:::tf-test-bucket-1234/*"],
 *             conditions: [{
 *                 test: "StringEquals",
 *                 variable: "s3:x-amz-acl",
 *                 values: ["bucket-owner-full-control"],
 *             }],
 *         },
 *     ],
 * });
 * const hogeBucketPolicy = new aws.s3.BucketPolicy("hoge", {
 *     bucket: hogeBucketV2.id,
 *     policy: hoge.then(hoge => hoge.json),
 * });
 * const foo = new aws.ssm.ResourceDataSync("foo", {
 *     name: "foo",
 *     s3Destination: {
 *         bucketName: hogeBucketV2.bucket,
 *         region: hogeBucketV2.region,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * hoge_bucket_v2 = aws.s3.BucketV2("hoge", bucket="tf-test-bucket-1234")
 * hoge = aws.iam.get_policy_document(statements=[
 *     {
 *         "sid": "SSMBucketPermissionsCheck",
 *         "effect": "Allow",
 *         "principals": [{
 *             "type": "Service",
 *             "identifiers": ["ssm&#46;amazonaws&#46;com"],
 *         }],
 *         "actions": ["s3:GetBucketAcl"],
 *         "resources": ["arn:aws:s3:::tf-test-bucket-1234"],
 *     },
 *     {
 *         "sid": "SSMBucketDelivery",
 *         "effect": "Allow",
 *         "principals": [{
 *             "type": "Service",
 *             "identifiers": ["ssm&#46;amazonaws&#46;com"],
 *         }],
 *         "actions": ["s3:PutObject"],
 *         "resources": ["arn:aws:s3:::tf-test-bucket-1234/*"],
 *         "conditions": [{
 *             "test": "StringEquals",
 *             "variable": "s3:x-amz-acl",
 *             "values": ["bucket-owner-full-control"],
 *         }],
 *     },
 * ])
 * hoge_bucket_policy = aws.s3.BucketPolicy("hoge",
 *     bucket=hoge_bucket_v2.id,
 *     policy=hoge.json)
 * foo = aws.ssm.ResourceDataSync("foo",
 *     name="foo",
 *     s3_destination={
 *         "bucket_name": hoge_bucket_v2.bucket,
 *         "region": hoge_bucket_v2.region,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hogeBucketV2 = new Aws.S3.BucketV2("hoge", new()
 *     {
 *         Bucket = "tf-test-bucket-1234",
 *     });
 *     var hoge = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "SSMBucketPermissionsCheck",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "ssm.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "s3:GetBucketAcl",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:s3:::tf-test-bucket-1234",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "SSMBucketDelivery",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "ssm.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "s3:PutObject",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:s3:::tf-test-bucket-1234/*",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "s3:x-amz-acl",
 *                         Values = new[]
 *                         {
 *                             "bucket-owner-full-control",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var hogeBucketPolicy = new Aws.S3.BucketPolicy("hoge", new()
 *     {
 *         Bucket = hogeBucketV2.Id,
 *         Policy = hoge.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var foo = new Aws.Ssm.ResourceDataSync("foo", new()
 *     {
 *         Name = "foo",
 *         S3Destination = new Aws.Ssm.Inputs.ResourceDataSyncS3DestinationArgs
 *         {
 *             BucketName = hogeBucketV2.Bucket,
 *             Region = hogeBucketV2.Region,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		hogeBucketV2, err := s3.NewBucketV2(ctx, "hoge", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test-bucket-1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		hoge, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("SSMBucketPermissionsCheck"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"ssm.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"s3:GetBucketAcl",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:s3:::tf-test-bucket-1234",
 * 					},
 * 				},
 * 				{
 * 					Sid:    pulumi.StringRef("SSMBucketDelivery"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"ssm.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"s3:PutObject",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:s3:::tf-test-bucket-1234/*",
 * 					},
 * 					Conditions: []iam.GetPolicyDocumentStatementCondition{
 * 						{
 * 							Test:     "StringEquals",
 * 							Variable: "s3:x-amz-acl",
 * 							Values: []string{
 * 								"bucket-owner-full-control",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketPolicy(ctx, "hoge", &s3.BucketPolicyArgs{
 * 			Bucket: hogeBucketV2.ID(),
 * 			Policy: pulumi.String(hoge.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssm.NewResourceDataSync(ctx, "foo", &ssm.ResourceDataSyncArgs{
 * 			Name: pulumi.String("foo"),
 * 			S3Destination: &ssm.ResourceDataSyncS3DestinationArgs{
 * 				BucketName: hogeBucketV2.Bucket,
 * 				Region:     hogeBucketV2.Region,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.ssm.ResourceDataSync;
 * import com.pulumi.aws.ssm.ResourceDataSyncArgs;
 * import com.pulumi.aws.ssm.inputs.ResourceDataSyncS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hogeBucketV2 = new BucketV2("hogeBucketV2", BucketV2Args.builder()
 *             .bucket("tf-test-bucket-1234")
 *             .build());
 *         final var hoge = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("SSMBucketPermissionsCheck")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("ssm.amazonaws.com")
 *                         .build())
 *                     .actions("s3:GetBucketAcl")
 *                     .resources("arn:aws:s3:::tf-test-bucket-1234")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("SSMBucketDelivery")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("ssm.amazonaws.com")
 *                         .build())
 *                     .actions("s3:PutObject")
 *                     .resources("arn:aws:s3:::tf-test-bucket-1234/*")
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("s3:x-amz-acl")
 *                         .values("bucket-owner-full-control")
 *                         .build())
 *                     .build())
 *             .build());
 *         var hogeBucketPolicy = new BucketPolicy("hogeBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(hogeBucketV2.id())
 *             .policy(hoge.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new ResourceDataSync("foo", ResourceDataSyncArgs.builder()
 *             .name("foo")
 *             .s3Destination(ResourceDataSyncS3DestinationArgs.builder()
 *                 .bucketName(hogeBucketV2.bucket())
 *                 .region(hogeBucketV2.region())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   hogeBucketV2:
 *     type: aws:s3:BucketV2
 *     name: hoge
 *     properties:
 *       bucket: tf-test-bucket-1234
 *   hogeBucketPolicy:
 *     type: aws:s3:BucketPolicy
 *     name: hoge
 *     properties:
 *       bucket: ${hogeBucketV2.id}
 *       policy: ${hoge.json}
 *   foo:
 *     type: aws:ssm:ResourceDataSync
 *     properties:
 *       name: foo
 *       s3Destination:
 *         bucketName: ${hogeBucketV2.bucket}
 *         region: ${hogeBucketV2.region}
 * variables:
 *   hoge:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: SSMBucketPermissionsCheck
 *             effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - ssm.amazonaws.com
 *             actions:
 *               - s3:GetBucketAcl
 *             resources:
 *               - arn:aws:s3:::tf-test-bucket-1234
 *           - sid: SSMBucketDelivery
 *             effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - ssm.amazonaws.com
 *             actions:
 *               - s3:PutObject
 *             resources:
 *               - arn:aws:s3:::tf-test-bucket-1234/*
 *             conditions:
 *               - test: StringEquals
 *                 variable: s3:x-amz-acl
 *                 values:
 *                   - bucket-owner-full-control
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSM resource data sync using the `name`. For example:
 * ```sh
 * $ pulumi import aws:ssm/resourceDataSync:ResourceDataSync example example-name
 * ```
 * @property name Name for the configuration.
 * @property s3Destination Amazon S3 configuration details for the sync.
 * */*/*/*/*/*/
 */
public data class ResourceDataSyncArgs(
    public val name: Output<String>? = null,
    public val s3Destination: Output<ResourceDataSyncS3DestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.ResourceDataSyncArgs> {
    override fun toJava(): com.pulumi.aws.ssm.ResourceDataSyncArgs =
        com.pulumi.aws.ssm.ResourceDataSyncArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .s3Destination(s3Destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceDataSyncArgs].
 */
@PulumiTagMarker
public class ResourceDataSyncArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var s3Destination: Output<ResourceDataSyncS3DestinationArgs>? = null

    /**
     * @param value Name for the configuration.
     */
    @JvmName("kswwplgryvvmwoag")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Amazon S3 configuration details for the sync.
     */
    @JvmName("ogdbbukxbmioglbd")
    public suspend fun s3Destination(`value`: Output<ResourceDataSyncS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value Name for the configuration.
     */
    @JvmName("dxsqmedkcseynoik")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Amazon S3 configuration details for the sync.
     */
    @JvmName("mqjlvxdnmawpouip")
    public suspend fun s3Destination(`value`: ResourceDataSyncS3DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument Amazon S3 configuration details for the sync.
     */
    @JvmName("bokhsdxrjtdqfuxm")
    public suspend fun s3Destination(argument: suspend ResourceDataSyncS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceDataSyncS3DestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    internal fun build(): ResourceDataSyncArgs = ResourceDataSyncArgs(
        name = name,
        s3Destination = s3Destination,
    )
}
