@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceSetting].
 */
@PulumiTagMarker
public class ServiceSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceSettingArgs = ServiceSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceSettingArgsBuilder.() -> Unit) {
        val builder = ServiceSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceSetting {
        val builtJavaResource = com.pulumi.aws.ssm.ServiceSetting(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceSetting(builtJavaResource)
    }
}

/**
 * This setting defines how a user interacts with or uses a service or a feature of a service.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testSetting = new aws.ssm.ServiceSetting("test_setting", {
 *     settingId: "arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled",
 *     settingValue: "true",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_setting = aws.ssm.ServiceSetting("test_setting",
 *     setting_id="arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled",
 *     setting_value="true")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testSetting = new Aws.Ssm.ServiceSetting("test_setting", new()
 *     {
 *         SettingId = "arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled",
 *         SettingValue = "true",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewServiceSetting(ctx, "test_setting", &ssm.ServiceSettingArgs{
 * 			SettingId:    pulumi.String("arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled"),
 * 			SettingValue: pulumi.String("true"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.ServiceSetting;
 * import com.pulumi.aws.ssm.ServiceSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSetting = new ServiceSetting("testSetting", ServiceSettingArgs.builder()
 *             .settingId("arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled")
 *             .settingValue("true")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testSetting:
 *     type: aws:ssm:ServiceSetting
 *     name: test_setting
 *     properties:
 *       settingId: arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled
 *       settingValue: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS SSM Service Setting using the `setting_id`. For example:
 * ```sh
 * $ pulumi import aws:ssm/serviceSetting:ServiceSetting example arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled
 * ```
 */
public class ServiceSetting internal constructor(
    override val javaResource: com.pulumi.aws.ssm.ServiceSetting,
) : KotlinCustomResource(javaResource, ServiceSettingMapper) {
    /**
     * ARN of the service setting.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ID of the service setting.
     */
    public val settingId: Output<String>
        get() = javaResource.settingId().applyValue({ args0 -> args0 })

    /**
     * Value of the service setting.
     */
    public val settingValue: Output<String>
        get() = javaResource.settingValue().applyValue({ args0 -> args0 })

    /**
     * Status of the service setting. Value can be `Default`, `Customized` or `PendingUpdate`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ServiceSettingMapper : ResourceMapper<ServiceSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.ServiceSetting::class == javaResource::class

    override fun map(javaResource: Resource): ServiceSetting = ServiceSetting(
        javaResource as
            com.pulumi.aws.ssm.ServiceSetting,
    )
}

/**
 * @see [ServiceSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceSetting].
 */
public suspend fun serviceSetting(
    name: String,
    block: suspend ServiceSettingResourceBuilder.() -> Unit,
): ServiceSetting {
    val builder = ServiceSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceSetting(name: String): ServiceSetting {
    val builder = ServiceSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
