@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.ServiceSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This setting defines how a user interacts with or uses a service or a feature of a service.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testSetting = new aws.ssm.ServiceSetting("test_setting", {
 *     settingId: "arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled",
 *     settingValue: "true",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_setting = aws.ssm.ServiceSetting("test_setting",
 *     setting_id="arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled",
 *     setting_value="true")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testSetting = new Aws.Ssm.ServiceSetting("test_setting", new()
 *     {
 *         SettingId = "arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled",
 *         SettingValue = "true",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssm.NewServiceSetting(ctx, "test_setting", &ssm.ServiceSettingArgs{
 * 			SettingId:    pulumi.String("arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled"),
 * 			SettingValue: pulumi.String("true"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.ServiceSetting;
 * import com.pulumi.aws.ssm.ServiceSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testSetting = new ServiceSetting("testSetting", ServiceSettingArgs.builder()
 *             .settingId("arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled")
 *             .settingValue("true")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testSetting:
 *     type: aws:ssm:ServiceSetting
 *     name: test_setting
 *     properties:
 *       settingId: arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled
 *       settingValue: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS SSM Service Setting using the `setting_id`. For example:
 * ```sh
 * $ pulumi import aws:ssm/serviceSetting:ServiceSetting example arn:aws:ssm:us-east-1:123456789012:servicesetting/ssm/parameter-store/high-throughput-enabled
 * ```
 * @property settingId ID of the service setting.
 * @property settingValue Value of the service setting.
 */
public data class ServiceSettingArgs(
    public val settingId: Output<String>? = null,
    public val settingValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.ServiceSettingArgs> {
    override fun toJava(): com.pulumi.aws.ssm.ServiceSettingArgs =
        com.pulumi.aws.ssm.ServiceSettingArgs.builder()
            .settingId(settingId?.applyValue({ args0 -> args0 }))
            .settingValue(settingValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSettingArgs].
 */
@PulumiTagMarker
public class ServiceSettingArgsBuilder internal constructor() {
    private var settingId: Output<String>? = null

    private var settingValue: Output<String>? = null

    /**
     * @param value ID of the service setting.
     */
    @JvmName("fdcxhbsquslhygke")
    public suspend fun settingId(`value`: Output<String>) {
        this.settingId = value
    }

    /**
     * @param value Value of the service setting.
     */
    @JvmName("unyjmhsupbnregfa")
    public suspend fun settingValue(`value`: Output<String>) {
        this.settingValue = value
    }

    /**
     * @param value ID of the service setting.
     */
    @JvmName("esfwhsbucsgqefse")
    public suspend fun settingId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingId = mapped
    }

    /**
     * @param value Value of the service setting.
     */
    @JvmName("yokmxpyymhunxjrr")
    public suspend fun settingValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingValue = mapped
    }

    internal fun build(): ServiceSettingArgs = ServiceSettingArgs(
        settingId = settingId,
        settingValue = settingValue,
    )
}
