@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.SsmFunctions.getContactsRotationPlain
import com.pulumi.aws.ssm.SsmFunctions.getDocumentPlain
import com.pulumi.aws.ssm.SsmFunctions.getInstancesPlain
import com.pulumi.aws.ssm.SsmFunctions.getMaintenanceWindowsPlain
import com.pulumi.aws.ssm.SsmFunctions.getParameterPlain
import com.pulumi.aws.ssm.SsmFunctions.getParametersByPathPlain
import com.pulumi.aws.ssm.SsmFunctions.getPatchBaselinePlain
import com.pulumi.aws.ssm.kotlin.inputs.GetContactsRotationPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetContactsRotationPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetDocumentPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetDocumentPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetInstancesFilter
import com.pulumi.aws.ssm.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetMaintenanceWindowsFilter
import com.pulumi.aws.ssm.kotlin.inputs.GetMaintenanceWindowsPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetMaintenanceWindowsPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetParameterPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetParameterPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetParametersByPathPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetParametersByPathPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetPatchBaselinePlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetPatchBaselinePlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.outputs.GetContactsRotationResult
import com.pulumi.aws.ssm.kotlin.outputs.GetDocumentResult
import com.pulumi.aws.ssm.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.ssm.kotlin.outputs.GetMaintenanceWindowsResult
import com.pulumi.aws.ssm.kotlin.outputs.GetParameterResult
import com.pulumi.aws.ssm.kotlin.outputs.GetParametersByPathResult
import com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.ssm.kotlin.outputs.GetContactsRotationResult.Companion.toKotlin as getContactsRotationResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetDocumentResult.Companion.toKotlin as getDocumentResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetMaintenanceWindowsResult.Companion.toKotlin as getMaintenanceWindowsResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetParameterResult.Companion.toKotlin as getParameterResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetParametersByPathResult.Companion.toKotlin as getParametersByPathResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineResult.Companion.toKotlin as getPatchBaselineResultToKotlin

public object SsmFunctions {
    /**
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssm.getContactsRotation({
     *     arn: "arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssm.get_contacts_rotation(arn="arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ssm.GetContactsRotation.Invoke(new()
     *     {
     *         Arn = "arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssm.LookupContactsRotation(ctx, &ssm.LookupContactsRotationArgs{
     * 			Arn: "arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetContactsRotationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmFunctions.getContactsRotation(GetContactsRotationArgs.builder()
     *             .arn("arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssm:getContactsRotation
     *       Arguments:
     *         arn: arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getContactsRotation.
     * @return A collection of values returned by getContactsRotation.
     */
    public suspend fun getContactsRotation(argument: GetContactsRotationPlainArgs): GetContactsRotationResult =
        getContactsRotationResultToKotlin(getContactsRotationPlain(argument.toJava()).await())

    /**
     * @see [getContactsRotation].
     * @param arn The Amazon Resource Name (ARN) of the rotation.
     * @return A collection of values returned by getContactsRotation.
     */
    public suspend fun getContactsRotation(arn: String): GetContactsRotationResult {
        val argument = GetContactsRotationPlainArgs(
            arn = arn,
        )
        return getContactsRotationResultToKotlin(getContactsRotationPlain(argument.toJava()).await())
    }

    /**
     * @see [getContactsRotation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetContactsRotationPlainArgs].
     * @return A collection of values returned by getContactsRotation.
     */
    public suspend fun getContactsRotation(argument: suspend GetContactsRotationPlainArgsBuilder.() -> Unit): GetContactsRotationResult {
        val builder = GetContactsRotationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactsRotationResultToKotlin(getContactsRotationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the contents of the specified Systems Manager document.
     * ## Example Usage
     * To get the contents of the document owned by AWS.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const foo = aws.ssm.getDocument({
     *     name: "AWS-GatherSoftwareInventory",
     *     documentFormat: "YAML",
     * });
     * export const content = foo.then(foo => foo.content);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ssm.get_document(name="AWS-GatherSoftwareInventory",
     *     document_format="YAML")
     * pulumi.export("content", foo.content)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Ssm.GetDocument.Invoke(new()
     *     {
     *         Name = "AWS-GatherSoftwareInventory",
     *         DocumentFormat = "YAML",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["content"] = foo.Apply(getDocumentResult => getDocumentResult.Content),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		foo, err := ssm.LookupDocument(ctx, &ssm.LookupDocumentArgs{
     * 			Name:           "AWS-GatherSoftwareInventory",
     * 			DocumentFormat: pulumi.StringRef("YAML"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("content", foo.Content)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = SsmFunctions.getDocument(GetDocumentArgs.builder()
     *             .name("AWS-GatherSoftwareInventory")
     *             .documentFormat("YAML")
     *             .build());
     *         ctx.export("content", foo.applyValue(getDocumentResult -> getDocumentResult.content()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:ssm:getDocument
     *       Arguments:
     *         name: AWS-GatherSoftwareInventory
     *         documentFormat: YAML
     * outputs:
     *   content: ${foo.content}
     * ```
     * <!--End PulumiCodeChooser -->
     * To get the contents of the custom document.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ssm.getDocument({
     *     name: testAwsSsmDocument.name,
     *     documentFormat: "JSON",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ssm.get_document(name=test_aws_ssm_document["name"],
     *     document_format="JSON")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ssm.GetDocument.Invoke(new()
     *     {
     *         Name = testAwsSsmDocument.Name,
     *         DocumentFormat = "JSON",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssm.LookupDocument(ctx, &ssm.LookupDocumentArgs{
     * 			Name:           testAwsSsmDocument.Name,
     * 			DocumentFormat: pulumi.StringRef("JSON"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = SsmFunctions.getDocument(GetDocumentArgs.builder()
     *             .name(testAwsSsmDocument.name())
     *             .documentFormat("JSON")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ssm:getDocument
     *       Arguments:
     *         name: ${testAwsSsmDocument.name}
     *         documentFormat: JSON
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDocument.
     * @return A collection of values returned by getDocument.
     */
    public suspend fun getDocument(argument: GetDocumentPlainArgs): GetDocumentResult =
        getDocumentResultToKotlin(getDocumentPlain(argument.toJava()).await())

    /**
     * @see [getDocument].
     * @param documentFormat The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
     * @param documentVersion The document version.
     * @param name The name of the document.
     * @return A collection of values returned by getDocument.
     */
    public suspend fun getDocument(
        documentFormat: String? = null,
        documentVersion: String? = null,
        name: String,
    ): GetDocumentResult {
        val argument = GetDocumentPlainArgs(
            documentFormat = documentFormat,
            documentVersion = documentVersion,
            name = name,
        )
        return getDocumentResultToKotlin(getDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetDocumentPlainArgs].
     * @return A collection of values returned by getDocument.
     */
    public suspend fun getDocument(argument: suspend GetDocumentPlainArgsBuilder.() -> Unit): GetDocumentResult {
        val builder = GetDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDocumentResultToKotlin(getDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the instance IDs of SSM managed instances.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssm.getInstances({
     *     filters: [{
     *         name: "PlatformTypes",
     *         values: ["Linux"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssm.get_instances(filters=[{
     *     "name": "PlatformTypes",
     *     "values": ["Linux"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ssm.GetInstances.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ssm.Inputs.GetInstancesFilterInputArgs
     *             {
     *                 Name = "PlatformTypes",
     *                 Values = new[]
     *                 {
     *                     "Linux",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssm.GetInstances(ctx, &ssm.GetInstancesArgs{
     * 			Filters: []ssm.GetInstancesFilter{
     * 				{
     * 					Name: "PlatformTypes",
     * 					Values: []string{
     * 						"Linux",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmFunctions.getInstances(GetInstancesArgs.builder()
     *             .filters(GetInstancesFilterArgs.builder()
     *                 .name("PlatformTypes")
     *                 .values("Linux")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssm:getInstances
     *       Arguments:
     *         filters:
     *           - name: PlatformTypes
     *             values:
     *               - Linux
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(filters: List<GetInstancesFilter>? = null): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            filters = filters,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the window IDs of SSM maintenance windows.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssm.getMaintenanceWindows({
     *     filters: [{
     *         name: "Enabled",
     *         values: ["true"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssm.get_maintenance_windows(filters=[{
     *     "name": "Enabled",
     *     "values": ["true"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ssm.GetMaintenanceWindows.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ssm.Inputs.GetMaintenanceWindowsFilterInputArgs
     *             {
     *                 Name = "Enabled",
     *                 Values = new[]
     *                 {
     *                     "true",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssm.GetMaintenanceWindows(ctx, &ssm.GetMaintenanceWindowsArgs{
     * 			Filters: []ssm.GetMaintenanceWindowsFilter{
     * 				{
     * 					Name: "Enabled",
     * 					Values: []string{
     * 						"true",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetMaintenanceWindowsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmFunctions.getMaintenanceWindows(GetMaintenanceWindowsArgs.builder()
     *             .filters(GetMaintenanceWindowsFilterArgs.builder()
     *                 .name("Enabled")
     *                 .values("true")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssm:getMaintenanceWindows
     *       Arguments:
     *         filters:
     *           - name: Enabled
     *             values:
     *               - 'true'
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMaintenanceWindows.
     * @return A collection of values returned by getMaintenanceWindows.
     */
    public suspend fun getMaintenanceWindows(argument: GetMaintenanceWindowsPlainArgs): GetMaintenanceWindowsResult =
        getMaintenanceWindowsResultToKotlin(getMaintenanceWindowsPlain(argument.toJava()).await())

    /**
     * @see [getMaintenanceWindows].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getMaintenanceWindows.
     */
    public suspend fun getMaintenanceWindows(filters: List<GetMaintenanceWindowsFilter>? = null): GetMaintenanceWindowsResult {
        val argument = GetMaintenanceWindowsPlainArgs(
            filters = filters,
        )
        return getMaintenanceWindowsResultToKotlin(getMaintenanceWindowsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMaintenanceWindows].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetMaintenanceWindowsPlainArgs].
     * @return A collection of values returned by getMaintenanceWindows.
     */
    public suspend fun getMaintenanceWindows(argument: suspend GetMaintenanceWindowsPlainArgsBuilder.() -> Unit): GetMaintenanceWindowsResult {
        val builder = GetMaintenanceWindowsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMaintenanceWindowsResultToKotlin(getMaintenanceWindowsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides an SSM Parameter data source.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const foo = aws.ssm.getParameter({
     *     name: "foo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ssm.get_parameter(name="foo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Ssm.GetParameter.Invoke(new()
     *     {
     *         Name = "foo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssm.LookupParameter(ctx, &ssm.LookupParameterArgs{
     * 			Name: "foo",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetParameterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = SsmFunctions.getParameter(GetParameterArgs.builder()
     *             .name("foo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:ssm:getParameter
     *       Arguments:
     *         name: foo
     * ```
     * <!--End PulumiCodeChooser -->
     * > **Note:** The unencrypted value of a SecureString will be stored in the raw state as plain-text.
     * @param argument A collection of arguments for invoking getParameter.
     * @return A collection of values returned by getParameter.
     */
    public suspend fun getParameter(argument: GetParameterPlainArgs): GetParameterResult =
        getParameterResultToKotlin(getParameterPlain(argument.toJava()).await())

    /**
     * @see [getParameter].
     * @param name Name of the parameter.
     * @param withDecryption Whether to return decrypted `SecureString` value. Defaults to `true`.
     * In addition to all arguments above, the following attributes are exported:
     * @return A collection of values returned by getParameter.
     */
    public suspend fun getParameter(name: String, withDecryption: Boolean? = null): GetParameterResult {
        val argument = GetParameterPlainArgs(
            name = name,
            withDecryption = withDecryption,
        )
        return getParameterResultToKotlin(getParameterPlain(argument.toJava()).await())
    }

    /**
     * @see [getParameter].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetParameterPlainArgs].
     * @return A collection of values returned by getParameter.
     */
    public suspend fun getParameter(argument: suspend GetParameterPlainArgsBuilder.() -> Unit): GetParameterResult {
        val builder = GetParameterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParameterResultToKotlin(getParameterPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getParametersByPath.
     * @return A collection of values returned by getParametersByPath.
     */
    public suspend fun getParametersByPath(argument: GetParametersByPathPlainArgs): GetParametersByPathResult =
        getParametersByPathResultToKotlin(getParametersByPathPlain(argument.toJava()).await())

    /**
     * @see [getParametersByPath].
     * @param path The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. The last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. **Note:** If the parameter name (e.g., `/my-app/my-param`) is specified, the data source will not retrieve any value as designed, unless there are other parameters that happen to use the former path in their hierarchy (e.g., `/my-app/my-param/my-actual-param`).
     * @param recursive Whether to retrieve all parameters within the hirerachy. Defaults to `false`.
     * @param withDecryption Whether to retrieve all parameters in the hierarchy, particularly those of `SecureString` type, with their value decrypted. Defaults to `true`.
     * @return A collection of values returned by getParametersByPath.
     */
    public suspend fun getParametersByPath(
        path: String,
        recursive: Boolean? = null,
        withDecryption: Boolean? = null,
    ): GetParametersByPathResult {
        val argument = GetParametersByPathPlainArgs(
            path = path,
            recursive = recursive,
            withDecryption = withDecryption,
        )
        return getParametersByPathResultToKotlin(getParametersByPathPlain(argument.toJava()).await())
    }

    /**
     * @see [getParametersByPath].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetParametersByPathPlainArgs].
     * @return A collection of values returned by getParametersByPath.
     */
    public suspend fun getParametersByPath(argument: suspend GetParametersByPathPlainArgsBuilder.() -> Unit): GetParametersByPathResult {
        val builder = GetParametersByPathPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParametersByPathResultToKotlin(getParametersByPathPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides an SSM Patch Baseline data source. Useful if you wish to reuse the default baselines provided.
     * ## Example Usage
     * To retrieve a baseline provided by AWS:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const centos = aws.ssm.getPatchBaseline({
     *     owner: "AWS",
     *     namePrefix: "AWS-",
     *     operatingSystem: "CENTOS",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * centos = aws.ssm.get_patch_baseline(owner="AWS",
     *     name_prefix="AWS-",
     *     operating_system="CENTOS")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var centos = Aws.Ssm.GetPatchBaseline.Invoke(new()
     *     {
     *         Owner = "AWS",
     *         NamePrefix = "AWS-",
     *         OperatingSystem = "CENTOS",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssm.LookupPatchBaseline(ctx, &ssm.LookupPatchBaselineArgs{
     * 			Owner:           "AWS",
     * 			NamePrefix:      pulumi.StringRef("AWS-"),
     * 			OperatingSystem: pulumi.StringRef("CENTOS"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetPatchBaselineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var centos = SsmFunctions.getPatchBaseline(GetPatchBaselineArgs.builder()
     *             .owner("AWS")
     *             .namePrefix("AWS-")
     *             .operatingSystem("CENTOS")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   centos:
     *     fn::invoke:
     *       Function: aws:ssm:getPatchBaseline
     *       Arguments:
     *         owner: AWS
     *         namePrefix: AWS-
     *         operatingSystem: CENTOS
     * ```
     * <!--End PulumiCodeChooser -->
     * To retrieve a baseline on your account:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const defaultCustom = aws.ssm.getPatchBaseline({
     *     owner: "Self",
     *     namePrefix: "MyCustomBaseline",
     *     defaultBaseline: true,
     *     operatingSystem: "WINDOWS",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * default_custom = aws.ssm.get_patch_baseline(owner="Self",
     *     name_prefix="MyCustomBaseline",
     *     default_baseline=True,
     *     operating_system="WINDOWS")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultCustom = Aws.Ssm.GetPatchBaseline.Invoke(new()
     *     {
     *         Owner = "Self",
     *         NamePrefix = "MyCustomBaseline",
     *         DefaultBaseline = true,
     *         OperatingSystem = "WINDOWS",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssm.LookupPatchBaseline(ctx, &ssm.LookupPatchBaselineArgs{
     * 			Owner:           "Self",
     * 			NamePrefix:      pulumi.StringRef("MyCustomBaseline"),
     * 			DefaultBaseline: pulumi.BoolRef(true),
     * 			OperatingSystem: pulumi.StringRef("WINDOWS"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetPatchBaselineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var defaultCustom = SsmFunctions.getPatchBaseline(GetPatchBaselineArgs.builder()
     *             .owner("Self")
     *             .namePrefix("MyCustomBaseline")
     *             .defaultBaseline(true)
     *             .operatingSystem("WINDOWS")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   defaultCustom:
     *     fn::invoke:
     *       Function: aws:ssm:getPatchBaseline
     *       Arguments:
     *         owner: Self
     *         namePrefix: MyCustomBaseline
     *         defaultBaseline: true
     *         operatingSystem: WINDOWS
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPatchBaseline.
     * @return A collection of values returned by getPatchBaseline.
     */
    public suspend fun getPatchBaseline(argument: GetPatchBaselinePlainArgs): GetPatchBaselineResult =
        getPatchBaselineResultToKotlin(getPatchBaselinePlain(argument.toJava()).await())

    /**
     * @see [getPatchBaseline].
     * @param defaultBaseline Filters the results against the baselines default_baseline field.
     * @param namePrefix Filter results by the baseline name prefix.
     * @param operatingSystem Specified OS for the baseline. Valid values: `AMAZON_LINUX`, `AMAZON_LINUX_2`, `UBUNTU`, `REDHAT_ENTERPRISE_LINUX`, `SUSE`, `CENTOS`, `ORACLE_LINUX`, `DEBIAN`, `MACOS`, `RASPBIAN` and `ROCKY_LINUX`.
     * @param owner Owner of the baseline. Valid values: `All`, `AWS`, `Self` (the current account).
     * The following arguments are optional:
     * @return A collection of values returned by getPatchBaseline.
     */
    public suspend fun getPatchBaseline(
        defaultBaseline: Boolean? = null,
        namePrefix: String? = null,
        operatingSystem: String? = null,
        owner: String,
    ): GetPatchBaselineResult {
        val argument = GetPatchBaselinePlainArgs(
            defaultBaseline = defaultBaseline,
            namePrefix = namePrefix,
            operatingSystem = operatingSystem,
            owner = owner,
        )
        return getPatchBaselineResultToKotlin(getPatchBaselinePlain(argument.toJava()).await())
    }

    /**
     * @see [getPatchBaseline].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetPatchBaselinePlainArgs].
     * @return A collection of values returned by getPatchBaseline.
     */
    public suspend fun getPatchBaseline(argument: suspend GetPatchBaselinePlainArgsBuilder.() -> Unit): GetPatchBaselineResult {
        val builder = GetPatchBaselinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPatchBaselineResultToKotlin(getPatchBaselinePlain(builtArgument.toJava()).await())
    }
}
